.TH mathALib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
mathALib - C callable math routines for the MC68881/2 
.SH SYNOPSIS
.nf
mathInit - initialize floating point math package
acos - floating point arc-cosine
asin - floating point arcsine
atan - floating point arctangent
cos - floating point cosine
cosh - floating point hyperbolic cosine
exp - floating point inverse natural logarithm (e ** (x))
fabs - floating point absolute value
log - floating point natural logarithm 
log10 - floating point logarithm base 10 
log2 - floating point logarithm base 2 
sin - floating point sine
sinh - floating point hyperbolic sine
sqrt - floating point square root
tan - floating point tangent
tanh - floating point hyperbolic tangent
sincos - simultaneous floating point sine and cosine
rmod - floating point modulo remainder
floor - floating point floor
ceil - floating point ceiling
trunc - floating point truncation
round - floating point rounding
entier - floating point
iround - INTEGER floating point rounding
irint - convert double to integer

VOID mathInit ()
double acos (dblParam)
double asin (dblParam)
double atan (dblParam)
double cos (dblParam)
double cosh (dblParam)
double exp (dblParam)
double fabs (dblParam)
double log (dblParam)
double log10 (dblParam)
double log2 (dblParam)
double sin (dblParam)
double sinh (dblParam)
double sqrt (dblParam)
double tan (dblParam)
double tanh (dblParam)
double sincos (dblParam, sinResult, cosResult)
double rmod (dblParam, divisor)
double floor (dblParam)
double ceil (dblParam)
double trunc (dblParam)
double round (dblParam)
double entier (dblParam)
int iround (dblParam)
int irint (dblParam)
.fi
.SH DESCRIPTION
This library provides a C interface to the high level math functions
on the MC68881/2 floating point coprocessor.  Each routine has the following
format:

 . save f7
 . calculate fp function using double parameter 
 . transfer result to parameter storage
 . store result to d0, d1 reg.'s
 . restore old f7

.SH WARNING
This library only works if there is a MC68881/2 coprocessor in the system!
Attempts to use these routines with no coprocessor present will result
in illegal instruction traps.

.SH SEE ALSO
fppLib (1)
