.TH lstLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
lstLib.c - doubly linked list subroutine library 
.SH SYNOPSIS
.nf
lstInit - initialize list descriptor
lstAdd - add node to end of list
lstConcat - concatenate two lists
lstCount - report number of nodes in list
lstDelete - delete specified node from list
lstExtract - extract a sublist from a list
lstFirst - find first node in list
lstGet - get (delete and return) first node from list
lstInsert - insert node in list after specified node
lstLast - find last node in list
lstNext - find next node in list
lstNth - find n-th node in list
lstPrevious - find previous node in list
lstNStep - find a node in the list 'nStep' nodes away from the given node 
lstFind - find a node in a list
lstFree - free up the list

VOID lstInit (pList)
VOID lstAdd (pList, pNode)
VOID lstConcat (pDstList, pAddList)
int lstCount (pList)
VOID lstDelete (pList, pNode)
VOID lstExtract (pSrcList, pStartNode, pEndNode, pDstList)
NODE *lstFirst (pList)
NODE *lstGet (pList)
VOID lstInsert (pList, pPrev, pNode)
NODE *lstLast (pList)
NODE *lstNext (pNode)
NODE *lstNth (pList, nodenum)
NODE *lstPrevious (pNode)
NODE *lstNStep (pNode, nStep)
int lstFind (pList, pNode)
VOID lstFree (pList)
.fi
.SH DESCRIPTION
This subroutine library supports the creation and maintenance of a
doubly linked list.  The user supplies a list descriptor (type LIST)
that will contain pointers to the first and last nodes in the list,
and a count of the number of nodes in the list.  The nodes in the
list can be any user-defined structure, but they must reserve space
for two pointers as their first elements.  Both the forward and
backward chains are terminated with a NULL pointer.

.ne 16
.SH NON-EMPTY LIST
.CS

   ---------             --------          --------
   | head--------------->| next----------->| next---------
   |       |             |      |          |      |      |
   |       |       ------- prev |<---------- prev |      |
   |       |       |     |      |          |      |      |
   | tail------    |     | ...  |    ----->| ...  |      |
   |       |  |    v                 |                   v
   |count=2|  |  -----               |                 -----
   ---------  |   ---                |                  ---
              |    -                 |                   -
              |                      |
              ------------------------

.CE
.ne 12
.SH EMPTY LIST
.CS

        -----------
        |  head------------------
        |         |             |
        |  tail----------       |
        |         |     |       v
        | count=0 |   -----   -----
        -----------    ---     ---
                        -       -

.CE

.SH INCLUDE FILE
lstLib.h
