.TH loadLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
loadLib.c - BSD UNIX object module loader 
.SH SYNOPSIS
.nf
loadModule - load object module into memory
loadModuleAt - load object module into memory

STATUS loadModule (fd, symFlag)
STATUS loadModuleAt (fd, symFlag, ppText, ppData, ppBss)
.fi
.SH DESCRIPTION
This library provides an object module loading facility.  UNIX BSD a.out
format files may be loaded into memory, relocated properly, their
external references resolved, and their external definitions added to
the system symbol table for use by other modules, and from the shell.
Modules may be loaded from any I/O stream, anywhere in memory.

.SH EXAMPLE
.CS
    fdX = open ("/devX/objFile", READ);
    loadModule (fdX, ALL_SYMBOLS);
    close (fdX);
.CE
This code fragment would load the a.out file objFile located on device /devX/
into memory which would be allocated from the system memory pool.  All
external and static definitions from the file would be added to the
system symbol table.

This could also have been accomplished from the shell, by typing:
.CS
    -> ld (1) </devX/objFile
.CE

.SH INCLUDE FILE
loadLib.h

.SH SEE ALSO
"Architecture", usrLib (1), symLib (1), memLib (1)
