.TH iosLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
iosLib.c - I/O system 
.SH SYNOPSIS
.nf
iosInit - initialize I/O system
iosDrvInstall - install I/O driver
iosDrvRemove - remove I/O driver
iosDevAdd - add device to I/O system
iosDevDelete - delete device from I/O system
iosDevFind - find an I/O device in the device list
iosNextDevGet - given a pointer to a device, get the next device in the list
iosDevShow - print a list of devices in the system
iosDrvShow - print a list of drivers in the system
iosFdShow - print a list of file descriptor names in the system
iosFdValue - verify valid open fd and return driver specific value
iosFdFree - free an fd entry in the fd table
iosFdSet - fill in file descriptor specifics
iosFdNew - allocate and initialize a new fd

STATUS iosInit (max_drivers, max_files, nullDevName)
int iosDrvInstall (pCreate, pDelete, pOpen, pClose, pRead, pWrite, pIoctl)
STATUS iosDrvRemove (drvnum, forceClose)
STATUS iosDevAdd (pDevHdr, name, drvnum)
VOID iosDevDelete (pDevHdr)
DEV_HDR *iosDevFind (name, pNameTail)
DEV_HDR *iosNextDevGet (pDev)
VOID iosDevShow ()
VOID iosDrvShow ()
VOID iosFdShow ()
int iosFdValue (fd)
VOID iosFdFree (fd)
VOID iosFdSet (fd, pDevHdr, name, value)
int iosFdNew (pDevHdr, name, value)
.fi
.SH DESCRIPTION
This is the I/O system for VxWorks.  It's primary job is to route user I/O
requests to the proper drivers, and with the proper parameters.  In order
to do this, it keeps various tables of the available drivers and their names,
open files, etc.  

The I/O system should be initialized by calling iosInit before any other
routines here are called.  Each driver then installs itself by calling
iosDrvInstall.  Finally, each device serviced by each driver is added to
the I/O system by calling iosDevAdd.

The I/O system is described much more fully in the chapter "I/O System".

.SH SEE ALSO
"I/O System", intLib (1), ioLib (1)
