.TH ioLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ioLib.c - I/O interface library 
.SH SYNOPSIS
.nf
creat - create a file
delete - delete a file
open - open a file
close - close a file
read - read bytes from a file or device
write - write bytes to a file
ioctl - do file specific control function
lseek - set file read/write pointer
ioFullFileNameGet - get the full file name using the current directory
ioDefPathSet - set current default path
ioDefPathGet - get current default directory
ioDefDevGet - get current default device
ioDefDirGet - get current default directory
ioGlobalStdSet - set underlying global fd for standard input/output/error
ioGlobalStdGet - get underlying global fd for standard input/output/error
ioTaskStdSet - set underlying task fd for standard input/output/error
ioTaskStdGet - get underlying task fd for standard input/output/error

int creat (name, mode)
STATUS delete (name)
int open (name, flags, mode)
STATUS close (fd)
int read (fd, buffer, maxbytes)
int write (fd, buffer, nbytes)
int ioctl (fd, function, arg)
int lseek (fd, offset, whence)
STATUS ioFullFileNameGet (partName, ppDevHdr, fullFileName)
STATUS ioDefPathSet (name)
VOID ioDefPathGet (name)
VOID ioDefDevGet (devName)
VOID ioDefDirGet (dirName)
VOID ioGlobalStdSet (stdFd, newFd)
int ioGlobalStdGet (stdFd)
VOID ioTaskStdSet (taskId, stdFd, newFd)
int ioTaskStdGet (taskId, stdFd)
.fi
.SH DESCRIPTION
This library contains the interface to the I/O system.  Calls to the
routines in this module cause calls to the corresponding routines in the
driver for a particular device.  Those driver routines do all the actual
work, so much of what actually transpires during a read, write, etc.  is
device dependent.  If the drivers adhere to convention, however, the
results should be consistent from device to device.

.SH GLOBAL FD'S
Just as VxWorks has a single address space for all tasks, there is
single "file descriptor space" for all fd's.  Like UNIX, an fd
is a small integer returned by a creat, open or socket call.
When VxWorks starts up in usrConfig (1), a console device is opened
and this file descriptor is assigned to the global standard input, output,
and error fd's with ioGlobalStdSet.  The term global conveys that
all tasks use these file descriptors when using standard input (0),
standard output (1), and standard error (2).  A task may reassign
its default I/O with ioTaskStdSet.

.SH INCLUDE FILE
ioLib.h

.SH SEE ALSO
"I/O System", iosLib (1)
