.TH hostLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
hostLib.c - host table subroutine library 
.SH SYNOPSIS
.nf
hostTblInit - initialize network host table
hostAdd - add a host to the host table
hostDelete - delete a host from host table.
hostGetByName - look up a host in the host table by its name.
hostGetByAddr - look up a host in the host table by its internet address
hostShow - show the host table

VOID hostTblInit ()
STATUS hostAdd (hostName, hostAddr)
STATUS hostDelete (name, addr)
int hostGetByName (name)
STATUS hostGetByAddr (addr, name)
VOID hostShow ()
.fi
.SH DESCRIPTION
This module provides routines to store and access the network host database.
The host table contains information regarding the known hosts on the
local network.  The host table (displayed with hostShow (2)) contains
the internet address, the official host name, and aliases.

By convention network addresses are specified in a dot (`.') notation.
The library inetLib (1) contains internet address manipulation routines.
Host names, and aliases, may contain any printable character.

.SH SEE ALSO
inetLib (1), "Network"
