.TH fppLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
fppLib.c - floating-point coprocessor support library 
.SH SYNOPSIS
.nf
fppInit - initialize floating-point coprocessor support
fppTaskRegsShow - print contents of a task's floating-point registers
fppTaskRegsGet - get a task's floating-point registers from TCB
fppTaskRegsSet - set a task's floating-point registers 
fppProbe - probe for presence of floating-point coprocessor

VOID fppInit ()
VOID fppTaskRegsShow (task)
STATUS fppTaskRegsGet (task, fpregs, pFpcr, pFpsr, pFpiar)
STATUS fppTaskRegsSet (task, fpregs, fpcr, fpsr, fpiar)
STATUS fppProbe ()
.fi
.SH DESCRIPTION
This library provides a low-level interface to the MC68881/MC68882 coprocessor.
To activate this floating point coporcessor support,
fppInit(1) must be called before any tasks using the coprocessor are spawned.
This is done by the root task, usrRoot(2), in usrConfig(1).

Routines fppTaskRegsShow, fppTaskRegsSet, and fppTaskRegsGet allow inspection
and setting of copocessor registers on a per task basis.  FppProbe checks
the presence of the MC68881/MC68882 coprocessor.
Excepting fppProbe, users should not normally use these routines but
use the higher level facilities in dbgLib(1) and usrLib(1).

.SH VX_FP_TASK OPTION BIT
Saving and restoring the floating point context adds to the context switch
time of a task (approximately 10us on a 20Mhz 68020).
Therefore the floating point context is NOT saved and restored for EVERY task.
Only those tasks spawned with the VX_FP_TASK task option bit will
have a valid floating point context saved and restored.

  IF A TASK WILL EXECUTE FLOATING POINT INSTRUCTIONS,
  THE TASK MUST BE SPAWNED WITH THE ``VX_FP_TASK'' TASK OPTION BIT.

.SH INTERRUPT LEVEL
The floating point context is NOT saved and restored for interrupt
service routines connected with intConnect(1).  However, an interrupt
service routine can easily save and restore the floating point context
itself, if necessary, by calling routines in fppALib(2).

.SH SEE ALSO
MC68881/MC68882 User's Manual
