.TH excLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
excLib.c - exception handling library 
.SH SYNOPSIS
.nf
excVecInit - initialize exception/interrupt vectors
excInit - initialize exception handling package
excHookAdd - specify routine to be called on exceptions
excTask - exception handling task-level support task

STATUS excVecInit ()
STATUS excInit ()
VOID excHookAdd (excepHook)
VOID excTask ()
.fi
.SH DESCRIPTION
This module provides facilities for handling 680x0 exceptions.
When installed, this package will safely trap and report exceptions
caused by program errors in VxWorks tasks,
and will report occurrence of any interrupts that have not been explicitly
connected to other handlers.

.SH INITIALIZATION
Initialization of the exception handling package is in two parts.
First, the routine excVecInit is called to set all the 680x0
exception, trap, and interrupt vectors to the default handlers provided
by this module.
This does not involve any VxWorks kernel facilities,
and so is normally done very early in the system start-up routine
usrInit (2) in usrConfig (1), with interrupts disabled.

The rest of this package is initialized by calling excInit.
This routine spawns the exception support task, excTask, and creates
the pipe used to communicate with it.
This initialization uses VxWorks' kernel facilities and the pipe driver,
and so must be performed in the root task, usrRoot (2) in usrConfig (1),
after the pipe driver has been installed.

Exceptions or uninitialized interrupts that occur after the vectors 
have been initialized by the excVecInit routine, but before the
the excInit routine has initialized the rest of this package,
simply cause a trap to the ROM monitor.

.SH NORMAL EXCEPTION HANDLING
When a program error generates an exception
(divide by 0, bus error, address error, etc.)
the task that was executing when the error occurred is
suspended and a description of the exception is printed on standard output.
The VxWorks kernel and other tasks in the system continue uninterrupted.
The suspended task may then be examined with the usual VxWorks routines,
including ti (2) for task information, and tt (2) for a stack trace.
It may be possible to fix the task and resume its execution 
(with the routine tr (2)).
However, tasks that have aborted in this way are often unsalvageable.
The task can be deleted in the usual way with the routine "td".

When an interrupt occurs which has not been connected to a handler,
the default handler provided by this module just prints a description
of the interrupt on standard output.

.SH ADDITIONAL EXCEPTION HANDLING ROUTINE
Additional exception processing can be added from outside of
this module by calling the routine excHookAdd.
This routine allows a routine to be specified that will be called
whenever a hardware exception occurs.  This routine will be called
at the end of the normal exception handling.

.SH EXCTASK - TASK LEVEL SUPPORT
A special task, excTask, is spawned by excInit to perform 
certain exception handling functions that need to be done at task level.
Do not suspend it, delete it, or change its priority.

.SH DBGLIB
The facilities of excLib, including excTask, are used by dbgLib
to support breakpoints and single-stepping and additional exception
handling functions.

.SH SIGLIB
SigLib provides a higher level UNIX compatible interface for
hardware and software exceptions.  If a "sigvec" is initialized
for the appropriate hardware exception/interrupt, eg. BUS ERROR == SIGSEGV,
excLib will use the signal mechanism instead.

.SH SEE ALSO
dbgLib (1), sigLib (1), intLib (1)
