.TH etherLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
etherLib.c - ethernet raw I/O routines and hooks 
.SH SYNOPSIS
.nf
etherOutput - send packet on ethernet interface
etherInputHookAdd - add routine to receive all ethernet input packets
etherOutputHookAdd - add routine to receive all ethernet output packets

STATUS etherOutput (pIf, pEtherHeader, pData, dataLength)
STATUS etherInputHookAdd (inputHook)
STATUS etherOutputHookAdd (outputHook)
.fi
.SH DESCRIPTION
This module provides utilities that give direct access to ethernet packets.
Raw packets can be output directly to an interface using etherOutput (2).
Hooks are provided to examine and optionally process all incoming packets
(etherInputHookAdd (2)) and all outgoing packets (etherOutputHookAdd (2)).
The input hook can be used to receive raw packets that are not part
of any of the supported network protocols.
The input and output hooks can also be used to build network monitoring
and testing tools. 

Most VxWorks network drivers, even if they are not truly ethernet,
are still accessible via these routines.
This includes the backplane drivers, Pronet driver, etc.

.SH NOTE
Most normal network access should go through the higher level socket
interface.  These routines should rarely, if ever, be necessary for
applications.

.SH SEE ALSO
"Network"
