.TH dsmLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
dsmLib.c - a 68K disassembler 
.SH SYNOPSIS
.nf
dsmData - disassemble and print a word as data
dsmInst - disassemble and print a single instruction
dsmNbytes - find out how big an instruction is

int dsmData (binInst, address)
int dsmInst (binInst, address, prtAddress)
int dsmNbytes (binInst)
.fi
.SH DESCRIPTION
This library has all the stuff necessary to print 680x0 object code in
assembly language format. The disassembly is done into Motorola format.

The programming interface is via dsmInst, which prints a single disassembled
instruction, and dsmNbytes, which will tell you how big an instruction is.

To disassemble from the shell, use the 'l' instruction, which calls this
library to do the actual work.  See dbgLib for details.

.SH ADDRESS PRINTING ROUTINE
Many of the operands to assembly language instructions are addresses.  In
order to allow the ability to print these symbolically, the call to dsmInst
has, as a parameter, the address of a routine to call to print an address.
When dsmLib needs to print an address as part of an operand field, it will call
the supplied routine to do the actual printing.  The routine should be declared
as:

    VOID prtAddress (address)
        int address;    * address to print *

When called, the routine should print the address on standard out (with printf
or whatever) in whatever form, numeric or symbolic, that it desires.  The
routine used by 'l', for instance, looks up the address in the system symbol
table and prints the symbol associated with it, if there is one.  If not, it
just prints the address as a hex number.

If the prtAddress argument to dsmPrint is NULL, a default print routine is used,
which just prints the address as a hex number.

.SH DEFICIENCIES
Movem's are not disassembled very nicely.  Some instructions and 
effective addressing modes that are actually illegal are not recognized 
as such, and are happily printed as whatever instruction they would 
probably be, if they weren't illegal.

DIVUL and DIVSL never get printed out.  DIVU and DIVS, respectively, are printed
instead.

Instructions should really be compared by their first two words since the
68020 is a 32 bit processor.  This would lessen the chance of bugs where
a word can be disassembled into more than one instruction.

.SH INCLUDE FILE
dsmLib.h
