.TH dbgLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
dbgLib.c - debugging facilities subroutine library 
.SH SYNOPSIS
.nf
dbgHelp - print dbgLib help menu
dbgInit - initialize debug package
b - set breakpoint
bd - delete breakpoint
bdall - delete all breakpoints
c - continue from breakpoint
cret - continue until return from current subroutine
s - single step
so - single step, but step over subroutine
l - print a number of disassembled instructions
tt - print a stack trace of a task

VOID dbgHelp ()
STATUS dbgInit (breakpointTrapNum)
STATUS b (addr, taskNameOrId, count, quiet)
STATUS bd (addr, taskNameOrId)
STATUS bdall (taskNameOrId)
STATUS c (taskNameOrId, addr)
STATUS cret (taskNameOrId)
STATUS s (taskNameOrId, addr)
STATUS so (taskNameOrId)
VOID l (addr, count)
STATUS tt (taskNameOrId)
.fi
.SH DESCRIPTION
This module provides VxWorks primary interactive debugging aids.
It provides the following facilities:

  - task breakpoints,
  - task single-stepping.

In addition, it provides the "glue" necessary to provide enhanced 
use of other VxWorks modules, including:

  - symbolic disassembly (via dsmLib),
  - symbolic task stack tracing (via trcLib),
  - enhanced shell abort and exception handling (via tyLib and excLib).

This module is optional.  It may be eliminated from production
systems simply by removing the call to dbgInit (see below).

.SH INITIALIZATION
To initialize the debugging facilities provided by this package,
the routine dbgInit must be called.
DbgInit must be called before any other routines in this package are called.
This is normally done by the root task, usrRoot (2), in usrConfig (1).

.SH BREAKPOINTS
You can set breakpoints in tasks with the b (2) command.  Breakpoints may
be set so that any task hitting a breakpoint will hit it, or so that
only a specific task will hit it.  Multiple breakpoints, for different
tasks, may be set at the same address.  The breakpoints are cleared
with bd (2) and bdall (2).

When a breakpoint is hit, the task hitting it is suspended and a message
is printed on the console.  At this point, you can examine the task, do
a trace on it (with tt (2)) to find out how it got where it is, change
variables used by the task, delete the task, etc.  If you examine the
task status at this point (by the i (2) command), you will find that it
is suspended.  The instruction at the breakpoint address has not yet
been executed.

When you wish the task to continue executing, use the c (2) command.
At this point, the instruction that had contained the breakpoint is executed,
and the task will then continue.  The breakpoint remains in until it is
explicitly removed.

.SH UNBREAKABLE TASKS
When a task is "unbreakable" it ignores all breakpoints.
Tasks can be spawned "unbreakable" by specifying the VX_UNBREAKABLE task
option.  Tasks can subsequently be set "unbreakable" or "breakable" by setting
or resetting the VX_UNBREAKABLE task option with the taskOptionsSet(2) routine.
Several VxWorks tasks are spawned unbreakable, including the shell,
the exception support task (excTask), and several network related tasks.

.SH DISASSEMBLER AND STACK TRACER
The routine l (2) provides a symbolic disassembler, using the low-level
disassembly routines in dsmLib (1).
The routine tt (2) provides a symbolic stack tracer, using the low-level
stack trace routines in trcLib (1).

.SH SHELL ABORT AND EXCEPTION HANDLING
This package includes enhanced support for the shell in a debugging
environment.
The terminal "abort" function is set to restart the shell.
This function is invoked when the "abort" key is
typed on a terminal for which the OPT_ABORT option has been set.
The "abort" key is by default control-C.
See tyAbortSet(2) and tyAbortFuncSet(2).

.SH DEFAULT TASK
Many routines in this package take a task id as an argument.
In all such cases, if the task id argument is missing or zero,
the last task id referenced is used.
This package uses the routine taskIdDefault(1) to set and get
the "last referenced task id", as do many VxWorks routines in other modules.

.SH EXCLIB
DbgLib uses the facilities of excLib (1), including excTask,
to support breakpoints and single-stepping and additional exception
handling functions.

.SH CAVEATS
Currently, some internals of vxWorks should not have breakpoints placed in
them.  Most notable are semGive(2) and semTake(2) which are used to manage
crucial non-preemptable resources.  One may work around this restriction
by placing a breakpoint on the call to these routines.

.SH SEE ALSO
excLib (1), dsmLib (1), tyLib (1), tyAbortSet(2), tyAbortFuncSet(2)
