.TH bALib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
bALib.s - buffer manipulation library assembly language routines 
.SH SYNOPSIS
.nf
bcopy - copy one buffer to another
bcopyBytes - copy one buffer to another a byte at a time
bcopyWords - copy one buffer to another a word at a time
bcopyLongs - copy one buffer to another a long at a time
bfill - fill buffer with character
bfillBytes - fill buffer with character a byte at a time

VOID bcopy (source, destination, nbytes)
VOID bcopyBytes (source, destination, nbytes)
VOID bcopyWords (source, destination, nwords)
VOID bcopyLongs (source, destination, nlongs)
VOID bfill (buf, nbytes, ch)
VOID bfillBytes (buf, nbytes, ch)
.fi
.SH DESCRIPTION
This library contains routines to manipulate buffers, which are just
variable length byte arrays.  These routines are highly optimized.
Operations are performed on long words where possible, even though the 
buffer lengths are specified in terms of bytes.
This particular optimization will only occur if source and
destination buffers are aligned such that either both start on an
odd address, or both start at an even address.  If one is even and one is odd,
operations must be done a byte at a time (because of alignment problems
inherent in the MC68000) and the process will be slower.

Certain applications, such as byte-wide memory-mapped peripherals,
may require that only byte operations be performed.  For this purpose,
the routines bcopyBytes and bfillBytes provide the same functions 
as bcopy and bfill but only using byte at a time operations.

These routines do not check for null termination as the routines found
in strLib (1) do.
 
.SH SEE ALSO
bLib (1), strLib (1)
