.WP "Shell" VxWorks 4.00
.TL
THE VxWORKS SHELL
.SP
.N 1 "INTRODUCTION"
.LP
Much of VxWorks' power comes from the uniformity of the environment it offers
the application developer.
A key element of this environment is the interactive access to system
and application facilities provided by the VxWorks
.B shell .
.LP
Most systems are supplied with some kind of command interpreter program which
provides the user with a limited and fixed set of commands that can be invoked
interactively.
The VxWorks shell, however,
provides a much simpler and vastly more powerful mechanism:
the shell allows the user to
.B "interactively invoke any subroutine"
that has been loaded into memory,
including both those supplied in VxWorks modules
and those in application modules.
In fact, the shell can interactively interpret almost any C language expression,
including execution of most C operators
and resolution of symbolic data references and subroutine invocations.
.LP
Note that the shell is not required in a VxWorks system.
It can be omitted, in a production system for example, simply by not
spawning it in the root task.
.SP
.N 2 "Accessing the Shell \(em \fIrlogin\fP"
.LP
The shell can be accessed in one of two ways \(em from a terminal, or
via the network.  In order to access the shell via the network, the
standard UNIX tool
.To rlogin
is used.
.LP
When VxWorks is first booted, the shell's terminal is normally
the system console.  The
.Ch RLOGIN
section below explains how to access the shell using
.To rlogin .

.N 1 "USING THE SHELL"
.LP
The VxWorks shell reads lines of input from an input stream, parses and
evaluates each line, and writes the result of the evaluation to an output
stream.
The shell accepts the same expression syntax as the C compiler with a
few variations.
This simple mechanism can be used in many different ways.
The following examples illustrate some typical uses of the shell.
(Note: the shell prompt is
``->'' and this prompt is shown before each user command in the
examples below.
The shell's responses are set in italics.)
.sp .5
.DS
.B "\(bu Data Conversion:"
.RS

.Ci
-> 68
.Co
    value = 68 = 0x44 = 'D'
.sp .5
.Ci
-> 0xf5de
.Co
    value = 62942 = 0xf5de = _init + 0x52
.sp .5
.Ci
-> 's'
.Co
    value = 115 = 0x73 = 's'

.R
(The shell prints all integers and characters in decimal and
hexadecimal, and if possible, as a character
constant or a symbolic address and offset.)
.RE
.DE
.DS
.B "\(bu Data Calculation:"
.RS

.Ci
-> (14 * 9) / 3
.Co
    value = 42 = 0x2a = '*'
.sp .5
.Ci
-> (0x1355 << 3) & 0x0f0f
.Co
    value = 2568 = 0xa08
.sp .5
.Ci
-> 4.3 * 5
.Co
    value = 21.5
.sp .5
.R
(Almost all C operators can be used.)
.RE
.DE
.DS
.B "\(bu Calculations With Variables:"
.RS

.Ci
-> (j + k) * 3
.Co
    value = ...
.sp .5
.Ci
-> *(j + 8 * k)
.Co
    (...address (j + 8 * k)...): value = ...
.sp .5
.Ci
-> x = (val1 - val2) / val3
.Co
    new symbol "x" added to symbol table
    address = ...
    value = ...
.sp .5
.Ci
-> f = 1.41 * 2
.Co
    new symbol "f" added to symbol table
    f = (...address of f...): value = 2.82
.sp .5
.R
(Variable \fIf\fP will get a 4-byte floating point value.)
.RE
.DE
.DS
.B "\(bu Invocations of VxWorks Subroutines:"
.RS

.Ci
-> errnoGet ( )
.Co
    value = (...value returned...)
.sp .5
.Ci
-> taskSpawn ("myTask", 10, 0, 1000, myTask, fd1, 300)
.Co
    value = ...
.sp .5
.Ci
-> fd = open ("file", 0)
.Co
    new symbol "fd" added to symbol table
    fd = (...address of fd...): value = ...
.sp .5
.Ci
-> fprintf (fd, "status = %d.", status)
.Co
    value = ...
.RE
.DE
.DS
.B "\(bu Invocations of Application Functions:"
.RS

.Ci
-> testFunc (123)
.Co
    value = ...
.sp .5
.Ci
-> myValue = myFunc (1, &val, testFunc (123))
.Co
    myValue = (...address of myValue...): value = ...
.sp .5
.Ci
-> myFloat = (float ()) myFuncWhichReturnsAFloat (x)
.Co
    myFloat = (...address of myFloat...): value = ...
.sp .5
.R
(For an explanation of cases where a routine does not return a 4-byte integer,
see the
.Ch "Function Calls"
section below.)
.RE
.DE
.N 2 "Terminal Control Characters"
.LP
There are several special characters available on a terminal, like the
one connected to the shell.  These characters can be changed, but by
default the following will work:
.DS
.IP \fB^H\fP
(backspace) Delete a character.
.IP \fB^U\fP
Delete an entire line.
.IP \fB^S\fP
Temporarily suspend output.
.IP \fB^Q\fP
Resume output.
.IP \fB^C\fP
Abort the shell.  See below.
.IP \fB^X\fP
Trap to the ROM monitor, or boot ROM.
.IP \fBESC\fP
Toggle between regular input mode and K-Shell command mode.
.DE
.LP
For more information, see the
.Ch I/O\ SYSTEM
chapter.
.N 2 "The Nature of the Shell:\ \ A Caveat"
.LP
The VxWorks shell serves a dual role.
First, it acts as a command interpreter
that provides access to all VxWorks facilities,
simply by allowing the user to call any VxWorks subroutine.
Second, as can be seen from the examples above,
the shell can be used as
a powerful debugging tool for the application developer.
Application modules can be easily tested and debugged
interactively by calling any application routine directly.
.LP
However, it is important to note that the power of the shell makes it a
potentially dangerous facility.
It is up to the user to know the consequences of calling a particular routine,
and to specify correctly the arguments to be passed to it.
By invoking routines incorrectly,
it is possible to cause system failures that require rebooting the system.
Thus the shell is
.UL not
an appropriate interface for naive end-users.
But it is an excellent interface for application developers.

.N 1 "SHELL LANGUAGE"
.LP
This section details the language accepted by the shell.
.N 2 "Data Types"
.LP
The most significant difference between the VxWorks shell and the C compiler
lies in the way that they handle data types.
The shell does not accept any C declaration statements,
and no data type information is available in the system symbol table.
Instead, an expression's type is determined by the types of its terms.
.LP
Unless explicit type-casting is done, the shell makes the following assumptions
about data types:
.sp .5
.RS
.IP \(bu .15i
All variables are assumed to be 4-byte integers.
.IP \(bu
Function and routine calls are assumed to return 4-byte integers.
.IP \(bu
All constants with decimal points are assumed to be 8-byte floating
point numbers (\fIdouble\fP's),
all other constants are assumed to be 4-byte integers (\fIint\fP's or
\fIlong\fP's).
.IP \(bu
If a variable is used as a floating point value, it is treated as
an 8-byte floating point number (a \fIdouble\fP).
.IP \(bu
In an assignment statement, the type of the left hand side is determined
by the type of the right hand side.
.IP \(bu
If floating point numbers and integers both appear in an arithmetic
expression, the resulting type is a floating point number.  For instance:
.DS
.Ci
-> x = 3
.br
.Co
    x = 0xfde4: value = 3 = 0x3

.Ci
-> y = x + 1.1
.br
.Co
    y = 0xfef6: value = 4.1

.Ci
-> y = x + (float)2
.br
.Co
    y= 0xfef6: value = 5

.DE
In both cases above,
.Sy y
is assigned a floating point value since the right sides of the expressions
contain floating point terms.
.RE
.sp .5
.LP
A constant, variable, or return value of a routine can be treated as a
different type than what the shell assumes it to be by explicitly specifying the
type in a similar fashion to C type-casting.
.LP
Table 1 provides information on the various data types available in VxWorks.
.sp .5
.KF
.TS
box,center;
cp12fB s s s
lfB | cfB | lfB | lfB
lfR | cfR | lfR | lfR .
.sp .25
VxWorks Data Types
.sp .25
_
.sp .25
Type	# of Bytes	Set Variable	Display Variable
.sp .25
=
.sp .25
int	4	x = 99	T{
.nf
-> x
-> (int) x
.fi
T}
.sp .25
_
.sp .25
long	4	T{
.nf
x = 33
x = (long)33
.fi
T}	T{
.nf
-> x
-> (long) x
.fi
T}
.sp .25
_
.sp .25
short	2	x = (short)20	-> (short) x
.sp .25
_
.sp .25
char	1	T{
.nf
x = 'A'
x = (char)65
x = (char)0x41
.fi
T}	T{
.nf
-> (char) x
.fi
T}
.sp .25
_
.sp .25
double	8	T{
.nf
x = 11.2
x = (double)11.2
.fi
T}	T{
.nf
-> (double)x
-> printf ("%g", (double)x)
-> printf ("%f", (double)x)
-> printf ("%e", (double)x)
.fi
T}
.sp .25
_
.sp .25
float	4	x = (float)5.42	T{
.nf
-> (float)x
-> printf ("%g", (float)x)
-> printf ("%f", (float)x)
-> printf ("%e", (float)x)
.fi
T}
.sp .25
.TE
.ce
\fBTable 1.\fP
.sp .5
.KE
.LP
Strings, or character arrays, are not actual data types in the VxWorks shell.
To declare a string, set a variable to a string value.  For example:
.DS
.Ci
-> ss = "shoe bee doo"
.R
.DE
The variable
.Sy ss
is a pointer to the string ``shoe bee doo''.
To display
.Sy ss ,
type:
.DS
.Ci
-> printf ("%s", ss)
.R
.DE
or
.DS
.Ci
-> d ss
.DE
The
.Sy d
command displays memory where
.Sy ss
is pointing.
.R
.LP
The shell places no type restrictions on the application of operators.
For example, the shell expression:
.DS
*(1000 + 3 * 16)
.DE
evaluates to the 4-byte integer value contained in memory location 1048.
.N 2 "Lines and Statements"
.LP
The shell parses and evaluates its input a line at a time.
A line may consist of a single shell statement
or several shell statements separated by semicolons.
A semicolon is not required on a line containing only a single statement.
A statement cannot continue on more than one line.
.LP
Shell statements are either C expressions or assignment statements.
.N 2 "Expressions"
.LP
Shell expressions consist of literals, symbolic data references,
function calls, and the usual C operators.
.N 3 "Literals"
.LP
The shell interprets the following literals in the same way as the C compiler:
.RS
.IP \(bu .15i
decimal numbers (e.g. 143967)
.IP \(bu
octal numbers (e.g. 017734)
.IP \(bu
hex numbers (e.g. 0xf3ba)
.IP \(bu
floating point numbers (e.g. 666.666)
.IP \(bu
character constants (e.g. 'x', '$')
.IP \(bu
string constants (e.g. "hello world!!!")
.RE
.LP
The shell also allows hex numbers to be preceded by ``$'' instead
of ``0x'' (e.g.  $f3ba).
.N 3 "Data Variable References"
.LP
Shell expressions may contain references to data variables whose names
have been entered in the system symbol table.
(Except in the case of assignment statements discussed below,
it is an error if an identifier in an expression is not found
in the symbol table.)
Unless a particular type has been specified for a data variable,
the variable's value in an expression
is the 4-byte value at the memory address obtained from the symbol table.
.LP
The C compiler prefixes all user defined identifiers with an underline,
so that the identifier
.Sy myVar
is actually in the symbol table as
.Sy _myVar .
The identifier can be entered either way to the shell.
The shell searches the symbol table for a match
either with or without a prefixed underline.
.LP
Shell expressions can also access data in memory that does not have a symbolic
name in the symbol table but whose address is known to the user.
This can be done with the C indirection operator ``*'' applied to a constant.
For example,
``*0x1000'' refers to the 4-byte integer value at memory address 1000 hex.
.N 3 "Operators"
.LP
The shell interprets the following operators in the
same way as the C compiler:
.RS
.IP \(bu .15i
arithmetic operators (+, -, *, /, unary -)
.IP \(bu
relational operators (==, !=, <, >, <=, >=)
.IP \(bu
shift operators (<<, >>)
.IP \(bu
logical operators (||, &&, !)
.IP \(bu
bitwise operators (|, &, ~, ^)
.IP \(bu
address and indirection operators (&, *)
.RE
.LP
The shell assigns the same precedence to the operators as the C compiler.
However, unlike the C compiler, the shell always evaluates both sub-expressions
of the logical binary operators ``||'' and ``&&''.
.N 3 "Function Calls"
.LP
Shell expressions may contain calls to C functions (or C compatible functions)
whose names have been entered in the system symbol table.
The shell executes such function calls just as though the function
had been called, with the specified arguments,
from the body of the shell itself, in the context of the shell task.
The value of a function call is the 4-byte integer value returned
by the function.
.LP
The shell allows up to ten arguments to be passed to a function.
In fact, the shell always passes exactly ten arguments to every function called,
passing values of zero for those arguments not specified.
This is harmless since the UNIX C function-call protocol handles
passing of variable numbers of arguments.
However, it allows trailing arguments of value zero to be omitted
from function calls in shell expressions.
.LP
Function calls can be nested.
That is, a function call can be an argument to another function call.
.LP
Shell expressions can also contain references to function addresses instead of
function invocations.
As in C,
this is indicated by the absence of parentheses after the function name.
Thus the expression ``myFunc ( ) + 4'' evaluates to the
result returned by the function
.Sy myFunc ,
added to 4,
while the expression ``myFunc + 4'' evaluates to the address of
.Sy myFunc
added to 4.
However, an important exception to this occurs when the function name
is the very first item encountered in a statement.
This is discussed in the next section.
.LP
Shell expressions can also contain calls to functions that do not have a
symbolic name in the symbol table, but whose addresses are known to the user.
This can be done by simply supplying the address in place of the function name.
Thus the expression ``0x1000 ( )'' would call a parameter-less function
whose entry point is at address 1000 hex.
.N 3 "Omitting Parentheses"
.LP
In practice, most statements input to the shell are function calls, often to
invoke VxWorks facilities.
To simplify this use of the shell, an important
exception is allowed to the standard expression syntax required by C.
When a function name is the very first item encountered in a shell statement,
the parentheses surrounding the function's arguments may be omitted.
Thus the following shell statements are synonymous:
.DS
.Ci
-> rename ("oldname", "newname")
-> rename "oldname", "newname"
.R
.DE
as are:
.DS
.Ci
-> errnoGet ( )
-> errnoGet
.R
.DE
.N 2 "Assignments"
.LP
The VxWorks shell interprets assignment statements of the form:
.DS
addressExpression = expression
.DE
The left side of an expression must evaluate to an addressable entity (a
legal C value).
The data type of the left side is determined by the type of the right
side.  If the right side of the expression does not contain any
floating point constants or non-integer type-casts,
then the type of the left side will be integer.
The value of the right side of the assignment
is put at the address indicated by the left side of the assignment.
For example, the assignment:
.DS
.Ci
-> x = 0x1000
.R
.DE
sets the 4-byte integer variable
.Sy x
to 0x1000.
The assignment:
.DS
.Ci
-> *0x1000 = x
.R
.DE
sets the 4-byte integer value at memory address 0x1000
to the current value of
.Sy x .
.LP
The compound assignment:
.DS
.Ci
-> x += 300
.R
.DE
adds 300 to the 4-byte integer variable
.Sy x .
The assignment:
.DS
.Ci
-> *0x1000 += 300
.R
.DE
adds 300 to the 4-byte integer value at memory address 0x1000.
The compound assignment operator ``-='', as well as
the auto-increment and auto-decrement operators ``++'' and ``--'',
are also available.
.N 3 "Automatic Creation of New Variables"
.LP
New variables can be created automatically by assigning a value to an unknown
identifier (one not found in the system symbol table) with an assignment
statement.
When the shell encounters such an assignment, it allocates space for the
variable and enters the new identifier in the system symbol table
along with the address of the newly allocated variable.
The new variable is set to the value and type of
the right side expression of the assignment statement.
The shell prints a message indicating that a new variable
has been allocated and assigned the specified value.
.LP
For example, if the identifier
.Sy fd
does not currently exist in the system symbol table, the statement:
.DS
.Ci
-> fd = open ("file", 0)
.R
.DE
would create a new variable named
.Sy fd
and assign to it the result of the function call.
.N 2 "Comments"
.LP
The shell allows two kinds of comments.
First, comments of the form ``/*\ ...\ */'' can be included
anywhere on a shell input line.
These comments are simply discarded,
and the rest of the input line evaluated as usual.
Second, any line whose first non-blank character is '#' is ignored completely.
Comments are particularly useful for VxWorks shell scripts.  See the
.Ch Scripts
section below.
.N 2 "Strings"
.LP
When the shell encounters a string literal ("...") in an expression,
it allocates space for the string including the null byte string terminator.
The value of the literal is the address of the string in the newly allocated
storage.
For instance, the expression:
.DS
.Ci
-> x = "hello there"
.R
.DE
allocates 12 bytes from the memory pool, enters the string in those 12 bytes
(including the null terminator), and assigns the address of the string to
.Sy x .
The expression:
.DS
.Ci
-> free (x)
.R
.DE
can be used to put those 12 bytes back into the memory pool.
See
.Ch memLib(1)
for information on memory management.
.LP
Furthermore, even when a string literal is not assigned to a symbol,
memory is still permanently allocated for it.  For instance, calling:
.DS
.Ci
-> printf ("hello there")
.R
.DE
from the shell uses 12 bytes of memory which is never freed.
This is because if strings were only temporarily allocated, and a
string literal were passed to a routine being spawned as a task,
then by the time the task executes and accesses the string, the shell
will have already released, and possibly even re-used, the temporary storage
in which the string was held.
.N 2 "Ambiguity of Arrays and Pointers"
.LP
In a C expression, an unsubscripted reference to an array has a special meaning,
namely the address of the first element of the array.
The shell, to be compatible, should use the address obtained from the
symbol table as the value of such a reference,
rather than the contents of memory at that address.
.LP
Unfortunately, the information that the identifier is an array,
as all data type information, is not available after compilation.
For example, if a module contains the following:
.DS
char string [ ] = "hello";
.DE
one might be tempted to enter a shell expression like:
.DS
.ta 1.5i
-> printf (string)	[1]
.DE
While this would be correct in C, the VxWorks shell will pass the first
4 bytes of the string itself to
.Sy printf ,
instead of the address of the string.
To correct this, the shell expression must explicitly
take the address of the identifier:
.DS
.ta 1.5i
-> printf (&string)	[2]
.DE
To make matters worse, if the identifier had been declared a character pointer
instead of a character array:
.DS
char *string = "hello";
.DE
then [1] would be correct and [2] would be wrong!
This is especially confusing since C allows pointers to be subscripted exactly
like arrays (so that the value of ``string[0]'' is 'h' in either declaration of
the identifier "string" above).
.LP
The moral of the story is that in shell expressions, unlike in C itself,
array references and pointer references are different.
In particular, array references require an explicit application of
the address operator ``&''.
.N 2 "Pointer Arithmetic"
.LP
Since VxWorks treats all variables that are not type-cast as 4-byte integers,
pointer arithmetic,
which the C language treats specially, is somewhat different.  Pointer
arithmetic is no different in the VxWorks shell than integer
arithmetic; that is, it is perfectly valid, but it does not take into
account the size of the variable pointed to.  Consider this example:
.DS
.Ci
-> *(myPtr + 4) = 5
.R
.DE
Assume that the value of
.Sy myPtr
is 0x1000.  In C, if
.Sy myPtr
is of type
.Sy char ,
this would put the value 5 in the
byte at address at 0x1004.  If
.Sy myPtr
is a 4-byte integer, the
4-byte value 0x00000005 would go into bytes 0x1010-0x1013.
The VxWorks shell, on the other hand, treats variables as integers, and
therefore would put the 4-byte value 0x00000005 in bytes
0x1004-0x1007.

.N 1 "REDIRECTION"
.LP
The shell and many other facilities in VxWorks direct I/O to three globally
known streams, known as standard input, standard output, and standard error.
These streams are set and accessed through the subroutine library
.Mo fioLib
(see the chapter
.Ch "I/O SYSTEM"
and the manual entry for
.Ch fioLib(1)
).
.LP
The shell provides a ``redirection'' mechanism for momentarily
re-assigning the standard in and standard out streams just for the duration of
the parse and evaluation of a line of input.
The redirection streams are indicated by ``<'' and ``>'' symbols followed by
stream names, at the very end of a line of input.
No other syntactic elements may follow the redirection specifications.
The redirections are in effect during the evaluation
of all statements on the line.
.LP
For example, the input line:
.DS
.Ci
-> copy < input > output
.R
.DE
would cause the standard input stream of
.Mo fioLib
to be set to the stream named
``input'' and the standard output to the stream named ``output'' during the
execution of the routine
.Sy copy .
.LP
If the file to which standard out is redirected does not exist, it
will be created on the default device.
.N 2 "Ambiguity Between Redirection and Operators"
.LP
There is an ambiguity between redirection specifications and the relational
operators ``less than'' and ``greater than''.
The shell always assumes that an ambiguous use of ``<'' or ``>''
specifies a redirection rather than a relational operation.
Thus the ambiguous input line:
.DS
-> x > y
.DE
would cause the printout of the value of the variable
.Sy x
to be written to the
stream named ``y'',
rather than comparing the value of variable
.Sy x
to the value of variable
.Sy y .
However, a semicolon can always be used to explicitly
remove the ambiguity,
since the shell requires that the redirection specification be the last
thing on a line.
Thus the input lines:
.DS
-> x; >y
-> x >y;
.DE
are unambiguous.  The first line prints the value of the variable
.Sy x
to the output stream ``y''.
The second line prints on standard out the value of the expression ``
.Sy x
greater than
.Sy y'' .
.N 2 "The Nature of Redirection"
.LP
The redirection mechanism of the VxWorks shell is fundamentally different from
that of the UNIX shell, although the syntax and terminology are similar.
VxWorks does
.UL not
have a notion of standard input and output streams for each task.
In VxWorks, standard in and standard out are a single pair of globally
available open streams, commonly used by system and application modules for
debugging and diagnostic I/O.
For example, one might be tempted to specify
redirection streams when spawning a routine as a task,
intending to send the output of
.Sy printf
calls in the new task to the stream ``output'',
while leaving the shell's I/O directed at the current terminal.
This is
.UL not
possible.
For example, the shell input line:
.DS
.Ci
-> taskSpawn (...myFunc...) > output
.R
.DE
will momentarily redirect the global standard out during the brief
execution of the spawn routine,
but will not effect the I/O of the resulting task.
.N 2 "Scripts"
.LP
A special case of I/O redirection occurs when one wants to redirect the I/O of
the shell itself; that is, redirect the streams from which shell input is read
and to which shell output is written.
The syntax for this is simply the usual redirection specification
on a line containing no other expressions.
This causes the shell to call
.UL itself ,
recursively, after redirecting the I/O.
Thus the new invocation of the shell will do I/O to and from
the redirected streams.
New invocations of the shell return to the original invocation of the shell upon
reaching an end-of-file on their input streams.
This returns the standard in and out to their previous streams,
and resumes the processing of those streams by the original shell.
.LP
The usual use of this mechanism is to cause the shell to read and execute lines
from a file on a disk or across the network.
For example, the input lines:
.DS
.Ci
-> <startup				[1]
-> <host:/usr/fred/startup	[2]
.R
.DE
would cause the shell to read and execute the commands in the file named
``startup'', either on the \fIdefault device\fP as in [1] or explicitly on
the networked machine ``host'' as in [2].  If one had already
.Sy cd 'd
to ``host:/usr/fred'' commands [1] and [2] would be equivalent.
.LP
Such command files are called scripts.
Scripts are processed exactly like input from an interactive terminal.
Upon reaching the end of the script file,
the shell returns to processing I/O from the original streams.
.LP
It is very easy to create a shell script from a list of commands which you
have just executed in the shell.  The VxWorks routine
.Sy h
prints a list of the last 20 commands that were typed to the shell.
Therefore, typing:
.DS
.Ci
-> h > host:/tmp/newscript
.R
.DE
creates a file
.Mo /tmp/newscript
which contains the current shell history on the networked machine ``host''.
.LP
Note that scripts can be nested.
That is, scripts can contain shell input redirections that cause
additional invocations of the shell to process other scripts.

.N 1 "SHELL LINE EDITING"
.LP
The shell provides a history mechanism similar to the UNIX K-Shell
history facility with a built-in line editor that allows the user to edit
previously typed commands.
As mentioned earlier, the command
.Sy h
displays the previous commands that were typed into the shell
(up to 20; old commands fall off the top as new ones are entered).
To edit a command that was typed in earlier, type \s-2ESC\s+2
followed by one of the search commands mentioned below.
The \s-2ESC\s+2 key toggles the shell into
.Sy command
mode, the mode which enables editing of the shell history.
The
.To vi -like
commands shown in Table 2 are available for line editing.
.LP
See the manual section on the line editing library
.Ch ledLib(1) .
.LP
*Warning:  Since the shell toggles between raw and line mode, type-ahead
can be lost.  See the
.Ch I/O\ SYSTEM
chapter for information on ``raw mode'' and ``line mode''.
.KF
.vs 11
.TS
box,center;
cp11fB s
cfB cfB
cp9 s
a l.
.sp .25
Shell Line Editing Commands
.sp .25
_
Command	Action
_
.sp .25
NOTE:  The default value for <n> is 1.
.sp .5
<n>G	Go to to command number <n>.
/<s>	Search for string <s> back in history.
?<s>	Search for string <s> forward in history.
n	Repeat last search.
N	Repeat last search but in the opposite direction.
<n>k	Get previous shell command, <n> relative.
<n>-	Same as ``k''.
<n>j	Get next history, <n> relative.
<n>+	Same as ``j''.
<n>h	Move left n characters.
^H	Same as ``h''.
<n>l	Move right n characters.
\s-3SPACEBAR\s0	Same as ``l''.
<n>w	Move n words forward.
<n>W	Move n blank-separated words forward.
<n>e	Move to the next end of word.
<n>E	Move to the end of blank-separated word.
<n>b	Move back n words.
<n>B	Move back n blank-separated words.
f<c>	Find character <c>, searching forwards.
F<c>	Find character <c>, searching backwards.
<n>r<c>	Replace the following <n> chars with <c>.
a	Append.
A	Append at end of line.
<n>x	Delete character under cursor.
<n>X	Delete character to left of cursor.
c \s-3SPACEBAR\s0	Change character.
cl	Change character.
cw	Change word.
cc	Change entire line.
c$	Change everything from cursor to end of line.
C	Same as ``c$''.
S	Same as ``cc''.
d \s-3SPACEBAR\s0	Delete character.
dl	Delete character.
dw	Delete word.
dd	Delete entire line.
d$	Delete everything from cursor to end of line.
D	Same as ``d$''.
i	Insert.
I	Insert at beginning of line.
p	Put whatever was last deleted after cursor.
P	Put whatever was last deleted before cursor.
u	Undo last command.
$	Go to end of line.
0	Go to beginning of line.
~	Toggle case, upper to lower or lower to upper.
^	Move cursor to first non-blank character in line.
R	Type-over mode.
^U	Delete line (leaves command mode).
^L	Redraw line.
\s-3RETURN\s0 	Give line to shell.
.sp .25
.TE
.vs
.ce
\fBTable 2.\fP
.KE

.N 1 "ABORTING THE SHELL"
.LP
Occasionally it is desirable to abort the shell's evaluation of a statement.
For example, an invoked routine may loop excessively, suspend,
or wait on a semaphore.
This may happen as the result of errors in arguments
specified in the invocation, errors in the implementation of the routine itself,
or simply oversight as to the consequences of calling the routine at all.
.LP
In such cases it is usually possible to abort and restart the shell task.
This is done by hitting a special abort key on the keyboard,
by default
\s-2CONTROL-C\s+2.
This causes the shell task to restart execution at its original entry point.
Upon restarting, the shell automatically re-assigns the system
standard input and output streams to the original assignments they had
when the shell was first spawned.
Thus any shell redirections are canceled,
also aborting the execution of any shell scripts.
.LP
The abort facility only works if
(1)
.Sy dbgInit
has been called (see the
.Ch DEBUGGING
chapter), (2)
.Sy excTask
is running,
(3) the driver for the particular keyboard device supports it
(all VxWorks supplied drivers do), and (4) the device's
.Sy abort
option is enabled
(done by an
.Sy ioctl
call, usually in the root task in
.Mo usrConfig ).
The abort key can be changed to a character other than
\s-2CONTROL-C\s+2
by calling
.Sy tyAbortSet .
See the
.Ch "I/O SYSTEM"
chapter for more information.
.LP
Also, you may occasionally enter an expression which causes
the shell to incur a fatal error such as a bus or address error, privilege
violation, etc.
Such errors normally result
in the suspension of the offending task, which allows further debugging.
However, when such an error is incurred by the shell task,
VxWorks automatically restarts the shell,
since further debugging would be impossible without access to it.
Note that for this reason,
as well as to allow the use of breakpoints and single-stepping,
when debugging a routine it is often useful
to spawn it as a task instead of just calling it directly from the shell
(see the
.Ch DEBUGGING
chapter for more information).
.LP
When the shell is aborted for any reason, either because of a fatal
error or because it is aborted from the terminal, a task trace is
displayed automatically.  This trace shows where the shell was executing
when it died.
.LP
Note that an offending routine may have left things in a state which may
not be cleared when the shell is aborted.  For instance, it may
have taken a semaphore, which cannot be given automatically as part of
the abort.

.N 1 "THE USER LIBRARY"
.LP
Although all VxWorks routines are available whenever needed,
VxWorks includes some libraries of routines that are specifically geared
towards simple interactive use.
The library
.Mo usrLib
includes routines to report system and task
information, to load object modules from files, to spawn, delete, hold, and
resume tasks, to display and modify memory, to examine the system symbol table,
to list system devices and disk directories, to copy and rename files,
and a few other higher-level facilities.
The
.Mo usrLib
library also includes a routine
.Sy help
that prints a list of commonly used routines and their arguments.
See the manual entry for
.Ch usrLib(1)
for details.
.LP
Other VxWorks modules have sets of routines specially designed to
be called from the shell, including
.Mo dbgLib ,
.Mo rlogLib ,
.Mo timexLib ,
and
.Mo spyLib .
Many other modules have status display routines that are intended primarily
for interactive use.
Application developers are encouraged to add routines of their own geared
towards interactive use, either to
.Mo usrLib
or to separate modules.
Note that the interactive use of routines is enhanced if they
do additional parameter verification, error checking, error reporting, etc.
.N 2 "Help Routines"
.LP
Several libraries include their own help routines.  To find them all,
type:
.DS
.Ci
-> lkup "Help"
.R
.DE
The
.Sy lkup
command is described in
.Ch lkup(2) .

.N 1 "RLOGIN"
.LP
When VxWorks is first booted, the shell's terminal is normally
the system console.  In order to access the shell from a UNIX host
via the network, simply type (on UNIX):
.DS
% rlogin vxTarget
.DE
where, in this case, ``vxTarget'' is the name of the target system in
the UNIX file
.Mo /etc/hosts .
A message will be printed on the VxWorks system
console indicating that the shell is being accessed via
.To rlogin ,
and that it is no longer available from its console.  To end a shell
session from
.To rlogin ,
type
.Sy logout
or the characters ``~ . \s-2RETURN\s+2'' (\s-2TILDE\s+2 - \s-2DOT\s+2
- \s-2CARRIAGE RETURN\s+2) as the only characters on a line.
.LP
Note that the shell can only be accessed from one place at a time.  If
someone is accessing the shell via
.To rlogin ,
typing at the console terminal will have no effect.  Also, only one
.To rlogin
can be in progress for a particular target system at any one time.
To stop someone from accessing the shell at the console via
.To rlogin ,
use the routine
.Sy shellLock
which is described in
.Ch shellLock(2) .
.LP
Since
.To rlogin
can be accessed via a UNIX window on a workstation-type environment,
it is possible to access more than one target system via
.To rlogin
at any one time, from the same UNIX workstation.
.N 2 "Using \fIrlogin\fP From VxWorks"
.LP
So far we have only discussed accessing VxWorks target systems using
the
.To rlogin
tool on a UNIX host machine.  It is also possible to
.Sy rlogin
.UL from
a VxWorks system to either a UNIX host, or another VxWorks system.
From the VxWorks shell, simply type:
.DS
.Ci
-> rlogin "anotherMachine"
.R
.DE
You would now be accessing the VxWorks or UNIX shell on the machine called
``anotherMachine''.
When you are finished, use
.Sy logout
to return to the original VxWorks shell.
.N 2 "Telnet"
.LP
VxWorks can also be connected using
.To ftp
via
.To telnet .
See the
.Ch NETWORK
chapter for more information.

.N 1 "THE SHELL TASK"
.LP
The VxWorks shell is spawned as a task by the root task in the module
.Mo usrConfig .
There are other tasks associated with the shell including
.Sy rlogin
and
.Sy telnet
tasks, if those facilities are included in VxWorks.
.LP
The shell and other tasks associated with it are all created with the
.Sy VX_UNBREAKABLE
option, so breakpoints cannot be set in those
tasks.  This is necessary, since a breakpoint in the shell (or one
of the
.Sy rlogin
tasks during an
.Sy rlogin )
would make it impossible for the user to interact with the system.  See
.Mo dbgLib(1)
for information on ``unbreakable'' tasks.
.LP
Only one shell may run on a vxWorks system at a time.
This is because the shell's parser is not currently re-entrant since it is
implemented using the UNIX tool
.To yacc .
.TO
