.de Ch
.B "\\$1" "\\$2"
..
.po 1.25i
.WP "Overview" VxWorks 4.00
.TL
VxWORKS OVERVIEW
.SP
.N 1 "OVERVIEW"
.LP
VxWorks is a high-performance real-time operating system and
a powerful development environment for real-time applications.
VxWorks includes a fast and flexible run-time system,
powerful testing and debugging facilities,
and an unparalleled UNIX cross-development package.
The heart of the cross-development lies in VxWorks' extensive UNIX-compatible
networking facilities.
.LP
The networking facilities allow VxWorks and UNIX to combine to form a complete,
integrated development and operational environment.
Each is used for what it does best.
The UNIX system is used for software development
and non-real-time components of an application, while VxWorks is used for
testing, debugging, and running real-time applications.
.LP
Once development is complete, the VxWorks system may operate either
standalone or networked with other systems running VxWorks or UNIX.
.LP
VxWorks is available for several families of target microprocessors and can
be networked with any BSD 4.2 or 4.3 UNIX host systems, or any other operating
system with TCP/IP networking facilities.
.LP
Here's what the VxWorks real-time system includes:

.IP "\(bu  \fBHigh-performance real-time operating system facilities\fR"
.br
Multi-tasking with pre-emptive priority scheduling,
intertask synchronization and communications facilities,
interrupt handling support, watchdog timers, and memory management;

.IP "\(bu  \fBNetwork facilities\fR"
.br
Provides ``transparent'' access to other VxWorks and UNIX systems
via UNIX source-compatible sockets, remote command execution, remote login,
remote procedure calls (RPC), source-level remote debugging,
and remote file access,
all using the TCP/IP network
protocols both loosely-coupled over standard Ethernet connections and
tightly-coupled over a backplane bus using shared memory;

.IP "\(bu  \fBModule loader and system symbol table\fR"
.br
Can load UNIX-format object modules dynamically over the network or
from a disk, with run-time relocation and linking;

.IP "\(bu  \fBShell\fR"
.br
A C interpreter interface that allows interactive execution of most
C language expressions, VxWorks functions, and any other loaded functions.
Also includes symbolic references to variables;

.IP "\(bu  \fBDebugging facilities\fR"
.br
Source-level debugging, a symbolic disassembler, a symbolic C
subroutine traceback, task-specific breakpoints and single-stepping,
system status displays,
and exception handling to safely trap and report safely
on interrupts and hardware
exceptions such as bus or address errors;

.IP "\(bu  \fBI/O system\fR"
.br
A fast and flexible UNIX source-compatible I/O system, including UNIX standard
buffered I/O;

.IP "\(bu  \fBLocal file system\fR"
.br
A fast file system appropriate for real-time systems, compatible with the
RT-11 file system;

.IP "\(bu  \fBRemote file system\fR"
.br
Network File System (NFS) for accessing files ``transparently'' on any NFS
server on the network, and a non-NFS network facility for accessing the host
file systems from VxWorks using
.Sy rsh
or
.Sy ftp ;

.IP "\(bu  \fBPerformance evaluation tools\fR"
.br
An execution timer that allows timing of a routine or group of routines,
and utilities to show CPU utilization percentage by task;

.IP "\(bu  \fBUtility libraries\fR"
.br
An extensive set of utility functions available to application developers,
including:
message logging,
string formatting and scanning,
linear and ring buffer manipulations,
linked-list manipulations,
and symbol table manipulation;

.IP "\(bu  \fBI/O drivers\fR"
.br
.DS
.ta 1.5i
ty driver	- for on-board serial I/O devices
network driver	- for remote files
pipe driver	- for intertask communication
ram ``disk'' driver	- for memory resident files
pseudo ty driver	- for pseudo terminals
drivers for additional peripheral controllers (e.g. disk drivers, serial I/O);
.ta
.DE

.IP "\(bu  \fBTarget-specific board support packages\fR"
.br
Routines for hardware initialization, interrupt management,
timer management, memory mapping, memory sizing, etc;

.IP "\(bu  \fBBoot ROMs\fR"
.br
Allow a target CPU to be booted directly over the network;

.IP "\(bu  \fBSystem configuration utilities\fR"
.br
Allow reconfiguration and extension of VxWorks
and placement of applications in ROM.
.N 1 "VxWORKS:\ \ A REAL-TIME PARTNER FOR UNIX COMPUTERS"
.LP
The UNIX Operating System has proven itself to be an excellent system
for program development and for many interactive applications.
However, it is notoriously poor at supporting real-time applications.
On the other hand, traditional real-time operating systems provide
very poor environments for program development or for non-real-time
components of an application.
.LP
Rather than trying to create a single operating system that ``does it all,''
the VxWorks philosophy is to network two different, but cooperating
operating systems, VxWorks and UNIX, and let each do what it does best.
VxWorks handles the critical real-time chores, while UNIX is
used for program development and for non-time-critical applications.
VxWorks and UNIX work well together because VxWorks was designed to be
UNIX-compatible at many levels, especially in its extensive networking
facilities.
.LP
As a cross-development host, UNIX is used to edit, compile,
link, and store real-time code that is then run and debugged on VxWorks.
The resulting VxWorks application can then be run stand-alone either in
ROM or disk based, with no further need for the network or the host system.
.LP
However, UNIX and VxWorks can also work together in a hybrid application,
with UNIX systems using VxWorks systems as real-time ``servers''
in a networked environment.
For instance, a VxWorks system controlling
a robot might itself be controlled by the UNIX system running an
expert system, or a number of VxWorks systems running factory equipment
might be connected to UNIX systems tracking inventory or generating reports.

.N 1 "DEVELOPMENT CYCLE"
.LP
To understand the environment provided by VxWorks, it is useful to
outline a typical development cycle.
First, the hardware in a typical development environment
includes one or more multi-user UNIX host systems and one or more
single-user VxWorks target systems connected by an Ethernet network.
The UNIX system can be fully-loaded with large main memory,
large disks, back-up media, printers, and terminals.
The target systems, on the other hand,
usually have only the resources required
by the real-time system, plus some for testing and debugging.
This may be as little as a CPU, some serial I/O channels,
and an Ethernet connection.
.LP
Software development for a real-time system begins on the UNIX host development
system.
Using the development and management tools on UNIX,
the application team begins to design and implement the application modules.
Developers are free to use the usual UNIX tools such
as text editors, compilers, assemblers,
.Sy make ,
.Sy RCS ,
.Sy SCCS ,
and so on.
The applications themselves can make use of the many libraries of facilities
supplied by VxWorks.
.LP
Application modules in C are compiled in the usual way with the
UNIX C compiler.
The application modules do not need to be linked
with the VxWorks system libraries or even with each other.
Instead, VxWorks is capable of loading the UNIX-generated
object modules directly, using the symbol table contained in all
UNIX object modules to dynamically resolve external symbol references.
.LP
At this point, developers can load selected modules dynamically across
the network for testing and debugging.
The VxWorks ``shell'' program is used interactively to invoke and test
individual application subroutines, or complete tasks.
.LP
VxWorks remembers the symbol tables from previously loaded object modules,
giving symbolic access to data and subroutine names.
One can examine data variables, call subroutines, spawn tasks, disassemble
code in memory, set breakpoints, obtain subroutine call tracebacks, and so on,
all using the original symbolic names.
Also, program errors detected by the hardware, such as illegal memory
references or illegal instructions, are safely trapped and reported by VxWorks,
allowing further symbolic debugging.
.LP
Source level debuggers are available that allow the application to be
viewed and debugged in the original source code.
Setting breakpoints, single stepping, examining variables, and so on,
can be done at the source level, using either commands at an ASCII terminal
or a mouse-based menu-driven interface on a windowed workstation.
.LP
The cycle of building, downloading, and testing application modules
is iterated until the application is ready for the production environment.
VxWorks debugging facilities can be removed from the production system,
if necessary, to make a system requiring minimal resources.  At that point,
the application can easily be linked with VxWorks, and put into ROM if
so desired.
.LP
The rest of this chapter outlines each of the components listed
in the overview above,
and gives reference to further documentation.

.N 1 "MULTI-TASKING AND INTERTASK COMMUNICATIONS"
.LP
Modern real-time systems are based on the complementary concepts of
multi-tasking and intertask communications.
A multi-tasking environment allows real-time applications to be constructed
as set of independent tasks, each with its own thread of execution
and set of system resources.
The intertask communication facilities allow these tasks to synchronize
and communicate in order to coordinate their activity.
.LP
The VxWorks multi-tasking kernel uses interrupt driven,
priority-based task scheduling.
It features very fast context switch times and very low interrupt latency.
.LP
Under VxWorks, any C subroutine may be ``spawned'' as a separate task,
with its own context and stack.
Other basic task control allows tasks to be suspended, resumed, deleted,
delayed, and moved in priority.
See the section on
.Ch Tasks
in the
.Ch ARCHITECTURE
chapter as well as the manual entry on
.Mo taskLib(1) .
.LP
VxWorks supplies traditional task-blocking semaphores as the basic task
synchronization and mutual-exclusion mechanism.
VxWorks semaphores are fast and efficient.
In addition to being available to application builders,
they are also used extensively in building higher level
communication facilities such as pipes, sockets, and signals.
Pipes and sockets are UNIX compatible mechanisms that
allow messages or byte streams to be exchanged between tasks.
Signals are a UNIX compatible mechanism for asynchronous transfer
of control within a task upon hardware or software exceptions.
See the section on
.Ch "Intertask Communications"
in the
.Ch ARCHITECTURE
chapter.
Semaphores are described in
.Mo semLib(1) ;
pipes are described in the
.Ch "I/O SYSTEM"
chapter and in
.Mo pipeDrv(4) ;
sockets are described in the
.Ch NETWORK
chapter and in
.Mo sockLib(1) ;
and signals are described in
.Mo sigLib(1) .

.N 1 "NETWORK"
.LP
The key to VxWorks' partnership with UNIX is its extensive networking
facilities.
By providing a fast, easy-to-use connection between
the two systems, the network allows UNIX to be fully utilized
as a development system, as a debugging host, and as a provider of
non-real-time services in a final system.
.LP
VxWorks currently supports network connections both loosely-coupled over
Ethernet (IEEE 802.3) networks,
and tightly-coupled over a backplane bus using shared memory.
VxWorks uses the TCP/IP network protocols as implemented in BSD 4.3
for all network communications.
.LP
VxWorks provides several levels of network access: process-to-process
sockets, remote command execution, remote login, remote procedure calls,
remote file access, and remote source level debugging.
.N 2 "Sockets"
.LP
VxWorks provides standard UNIX socket calls, which allow real-time
VxWorks processes and other processes, such as UNIX processes, to
communicate in any combination with each other over the network.
The VxWorks socket calls are source compatible with UNIX BSD 4.3.
Any process can open one or more sockets, to which other sockets
may be connected.
Data written to one socket of a connected pair
may be read from the other socket.
The network link is totally
transparent in the communications.
In fact, the two processes do not
necessarily know whether they are communicating with another process on
the same CPU or another CPU, or with a VxWorks process or a UNIX process.
.LP
See the manual entry for
.Mo sockLib(1) .
.N 2 "Remote File Access:\ \ NFS, \fIftp\fP, \fIrsh\fP"
.LP
Remote file access across the network is also available.
A program running on VxWorks is able to use a UNIX system as a
``virtual file system''.
Files on any UNIX system may be accessed, via the network, exactly as
if they were local to the VxWorks system.
A program running under VxWorks does not need to know where that file is, or
how to access it.  For example,
.Sy /dk/file
might be a file local to the VxWorks system, while
.Sy host:file
might be a file located on another machine entirely.
.LP
VxWorks has a full implementation of the SUN Microsystems standard
Network File System (NFS).
It runs as an NFS client with any other system that runs an NFS server.
Alternatively, VxWorks can use either of two other older protocols to provide
transparent remote file access:
.Sy rsh ,
or
.Sy ftp .
.LP
See
.Mo nfsLib(1) ,
.Mo remLib(1) ,
.Mo ftpLib(1) ,
and the section on
.Ch Network\ Devices
in the chapter
.Ch I/O\ SYSTEM .
.N 2 "Remote Log In:\ \ \fIrlogin\fP, \fItelnet\fP"
.LP
The remote login feature allows users to log into VxWorks or UNIX machines
from any other VxWorks or UNIX machine on the network.
This is convenient from the programmer's point of view.
For instance, on a UNIX workstation, the programmer can open an
.Sy rlogin
window that communicates with the VxWorks shell.
By opening such windows, the programmer can monitor and control
real-time VxWorks systems right from his desk.
.LP
VxWorks can also be accessed via
.Sy telnet ,
for systems that don't have
.Sy rlogin .
.LP
See the manual entries on
.Mo rlogLib(1) ,
.Mo telnetLib(1) .

.N 2 "Remote Procedure Calls (RPC)"
.LP
Remote Procedure Call (RPC) is a facility, originally designed by
SUN Microsystems and now in the public domain, which allows a process on
one machine to call a procedure which is executed by another process
on another machine.
Thus with RPC, a VxWorks task or UNIX process can invoke routines that
are executed on other VxWorks or UNIX machines, in any combination.
See the public domain RPC documentation and the manual entry for
.Mo rpcLib(1) .

.N 1 "MODULE LOADER AND SYSTEM SYMBOL TABLE"
.LP
The VxWorks real-time operating
system is unusual in that its facilities are made available to
application programs simply as an extensive set of C subroutines.
VxWorks does not need mechanisms such as system traps
to get to system functions.
Instead VxWorks supplies a system symbol table and a
loader with run-time linking to give dynamic and even interactive
access to all loaded modules.
.LP
The VxWorks module loader can load UNIX-format
.Sy \f1(\fPa.out
format)
object modules over the network or from a disk, and relocate them anywhere
in memory.  The loader also uses the symbol table contained in every
object module to build a system-wide symbol table of loaded function and
variable names.  Names from system and application modules alike are added
to the system symbol table.
.LP
This symbol table is the heart of many of VxWorks' most significant
development aids.
First, the loader itself uses the system symbol table to resolve undefined
references in modules being loaded, dynamically linking newly loaded modules
to previously loaded modules.
Also, VxWorks uses the system symbol table to provide
interactive access to all system and application modules that have been
loaded.
Finally, all of VxWorks' debugging facilities use the system symbol table
to provide symbolic references wherever possible.
.LP
Run-time linking makes it easy to have genuinely
.I shared
subroutine libraries, in which a single copy of a set of subroutines
may be used by several tasks, rather than requiring each task to be
linked with separate copies of needed subroutines.
As a result, there is no inherent distinction between VxWorks ``system'' modules
and user ``application'' modules.
This makes the VxWorks real-time system an especially ``open'' system:\ \ the
system facilities are easy to access, modify, and extend.
.LP
For more information on the module loader and the system symbol table,
see the chapter
.Ch CROSS-DEVELOPMENT .
Also see the manual entries for
.Mo loadLib(1) ,
and
.Mo symLib(1) .

.N 1 "SHELL"
.LP
VxWorks includes an interactive program called the ``shell'', that allows
developers to interact with all of VxWorks facilities.
The VxWorks shell provides one simple but very powerful capability:\ \ it
can interpret and execute almost all expressions of the C language,
including calls to functions and references to variables,
whose names are found in the system symbol table.
Thus the shell can be used to call VxWorks system functions,
call any application functions, examine and set application variables,
create new variables,
and even as a general purpose calculator with all C operators.
It can also be used to log into a remote UNIX or VxWorks machine with
.Sy rlogin .
In addition, the shell includes a command history facility and
.Sy vi -like
command line editing.
.LP
The VxWorks shell is discussed in detail in the
.Ch SHELL
chapter.
Also see the manual entries for
.Mo shellLib(1) ,
.Mo usrLib(1) ,
and
.Mo dbgLib(1)
which contain routines especially suited for interactive access of VxWorks
facilities.

.N 1 "DEBUGGING FACILITIES"
.LP
VxWorks supplies a powerful set of debugging facilities.  These include:
.RS
.IP \(bu .1i
routines to display system and task status,
.IP \(bu .1i
a symbolic disassembler that can disassemble any loaded module,
.IP \(bu .1i
a symbolic C subroutine traceback facility
that can be called at any time to list the current
sequence of nested subroutine calls of any task,
.IP \(bu .1i
complete trapping of hardware exceptions in a non-fatal way that allows
symbolic debugging to continue,
.IP \(bu .1i
a breakpoint and single-stepping facility that can be applied to specific
tasks, even in shared code.
.RE
.LP
In addition, VxWorks can be used optionally with source language debuggers,
such as
.Mo dbxWorks
from SUN Microsystems, and CDB from Third Eye Software.
These allow full remote source level debugging of applications running under
VxWorks.
.LP
As noted above, all these facilities use the system symbol table to provide
symbolic references wherever possible.
.LP
For more information on VxWorks' debugging facilities, see the
chapter
.Ch DEBUGGING .
Also see manual entries for
.Mo usrLib(1) ,
.Mo dbgLib(1) ,
.Mo excLib(1) ,
and
.Mo dsmLib(1) .
.N 1 "PERFORMANCE EVALUATION"
.LP
In order to understand and optimize the performance of a real-time system,
it is often necessary to time various functions that the system performs.
VxWorks provides various timing facilities in order to help with this
task.  The VxWorks execution timer is able to time any C subroutine,
or group of subroutines.
Because the system clock is too slow to provide the
resolution necessary to time very fast functions, the timer is also
able to iterate execution of a group of functions until the time of a single
iteration is known to a reasonable tolerance.
For more information on the execution timer, see the manual entry for
.Mo timexLib(1) .
.LP
VxWorks also provides a utility that shows the percentage of CPU utilization
by task, percentage of time spent at interrupt level,
and the amount of idle time.
For more information, see the manual entry for
.Mo spyLib(1) .

.N 1 "I/O SYSTEM"
.N 2 "User View"
.LP
The VxWorks I/O system provides uniform
device-independent access to all kinds of devices.
The user interface to VxWorks I/O is source compatible with
the standard C I/O library used on UNIX and elsewhere.
The user can call seven basic I/O functions:
.Sy creat ,
.Sy delete ,
.Sy open ,
.Sy close ,
.Sy read ,
.Sy write ,
and
.Sy ioctl .
Higher-level I/O functions, such as the UNIX-compatible
.Sy printf
and
.Sy scanf
routines, are provided and built on these basic functions.
.LP
VxWorks also provides a
.Sy stdio
buffered I/O package.
Standard UNIX-compatible buffered I/O routines are provided,
such as
.Sy fopen ,
.Sy fclose ,
.Sy fread ,
.Sy fwrite ,
.Sy getch ,
.Sy putch ,
etc.  These routines increase I/O performance in many cases.

.N 2 "I/O Drivers"
.LP
VxWorks includes I/O drivers for serial communications lines, disks,
ram ``disks'', intertask communication devices called pipes,
and devices on a network.
Application developers can easily write additional drivers, if needed.
VxWorks allows dynamic installation and removal of drivers without
rebooting the system.

.N 2 "Internal Architecture"
.LP
Internally, the VxWorks I/O system is fast and flexible,
allowing individual drivers complete control over how the user requests
are serviced.
Drivers can easily implement different protocols, unique device specific
functions, and even different file systems,
without interference from the I/O system itself.
VxWorks also supplies several high-level packages that make it easy for
drivers to implement common device protocols and file systems.
.LP
For a detailed discussion of the I/O system, see the chapter
.Ch I/O\ SYSTEM .
Relevant manual entries include
.Mo ioLib(1)
for basic I/O routines available to user tasks,
.Mo fioLib(1)
for various format-driven I/O routines, and
.Mo iosLib(1)
and
.Mo tyLib(1)
for routines available to driver writers.
Also see manual entries for the supplied drivers.

.N 1 "LOCAL FILE SYSTEM"
.N 2 "RT-11 File System"
.LP
VxWorks is supplied with a file system compatible with that of the RT-11
operating system.
This file system is appropriate for many real-time file systems,
since files are contiguous.
All file accesses require exactly one disk access, and sequential
file accesses involve minimal disk movement.
.LP
The RT-11 file system does have some drawbacks, however.
It lacks a hierarchical file organization that is particularly useful
on large disks.
Also the contiguous allocation scheme may result
in fragmentation of disk space.
.LP
The VxWorks implementation of the RT-11 file system includes byte-addressable
random access (seeking) to all files.
Each open file has a block buffer for optimized reading and writing.
Also see the manual entry for
.Mo rt11Lib(1) ,
which is the library that actually implements the file system.

.N 2 "Alternative File Systems"
.LP
In the VxWorks real-time system, the file system is
.I not
built into the operating system.
Instead it is a facility that individual drivers may or may not use.
Alternative file systems can be written and used by drivers in the same way.
Indeed the VxWorks I/O architecture makes it possible to have several
different file systems, even at the same time, on a single VxWorks system.

.N 1 "UTILITY LIBRARIES"
.LP
VxWorks supplies many subroutines of general utility to application developers.
These routines are organized as a set of subroutine libraries,
which are described below.
Application developers are encouraged to
use these libraries wherever possible.
Doing so reduces both development
time and memory requirements for the application.
For further information, see the manual entries for the specific libraries.

.N 2 "Interrupt Handling Support"
.LP
VxWorks supplies routines for handling hardware interrupts and software
traps without having to resort to assembly language coding.
Routines are provided to connect C routines to hardware interrupt vectors,
and to manipulate the processor interrupt level.
These routines are in
.Mo intLib(1)
and
.Mo intALib(1) .
.LP
See the chapter
\fBARCHITECTURE\fR for information about the context
in which interrupt level code runs, and for special restrictions that apply.

.N 2 "Watchdog Timers"
.LP
VxWorks supplies a watchdog facility that allows callers to schedule execution
of their own routines after specified time delays.
As soon as the specified number of ticks have elapsed, the specified
``timeout'' routine will be called at the interrupt level of the system clock,
unless the watchdog is canceled first.
Note that this mechanism is entirely different from the kernel's task delay
facility.
.LP
The watchdog functions are supplied by
.Mo wdLib(1) .
See the chapter
\fBARCHITECTURE\fR
and the manual entry on
.Mo wdLib(1)
for more information.

.N 2 "Message Logging"
.LP
VxWorks supplies a simple message logging facility
that allows error or status messages to be sent to a logging task
which then formats and outputs the messages to a system-wide logging device,
such as the system console, disk, or accessible memory.
The message logging facility can be used from interrupt level or task level.
.LP
The logging facility is supplied by routines in
.Mo logLib(1) .
Also see the chapter
.Ch I/O\ SYSTEM
for more details.

.N 2 "Memory Allocation"
.LP
VxWorks supplies a UNIX source-compatible memory management facility
useful for dynamically allocating, freeing, and reallocating blocks
of memory from a ``memory pool''.  The size of the pool can be set by the user.
Blocks of arbitrary size can be allocated.  This memory scheme is built on
a much more general mechanism which allows VxWorks to manage several
separate memory pools.

.N 2 "String Formatting and Scanning"
.LP
VxWorks includes string formatting and scanning subroutines that implement
UNIX-compatible
.Sy printf/scanf
format-driven encoding and decoding.
These routines are in
.Mo fioLib(1) .

.N 2 "Linear and Ring Buffer Manipulations"
.LP
The libraries
.Mo bLib(1)
and
.Mo bALib(1)
contain buffer manipulation functions such as
copying, filling, comparing, and so on, that have been optimized for speed.
The library
.Mo rngLib(1)
provides a set of general ring buffer routines that manage
first-in-first-out circular buffers.
Additionally, these ring buffers have the property that
a single writer and a single reader can access a
ring buffer ``simultaneously'' without
being required to interlock their accesses explicitly.

.N 2 "Linked-List Manipulations"
.LP
The library
.Mo lstLib(1)
contains a complete set of routines for creating and manipulating doubly-linked
lists.

.N 2 "Target Specific Board Support Packages"
.LP
Two target-specific libraries, called
.Mo sysLib(1)
and
.Mo sysALib(1)
are included with each port of VxWorks.
These libraries are the heart of VxWorks' portability because they provide
an identical software interface to the hardware functions of all boards.
They include routines for
hardware initialization,
interrupt handling and generation,
hardware clock and timer management,
mapping of local and bus memory spaces,
memory sizing,
and so on.
.TO
