/* vrtx.h - VRTX interface library header */

/*
modification history
--------------------
01c,24aug88,gae  changed VX_ types to VRTX_.
01b,13may88,rdc  added format field to TCB_STACK.
01a,25jan88,jcf  written.
*/

#ifndef INCvrtxh
#define INCvrtxh

#include "vwModNum.h"
#include "taskLib.h"

/* status codes */

#define S_vrtx_TASK_ID_ERROR		(M_vrtx | 1)
#define S_vrtx_NO_TCBS_AVAILABLE	(M_vrtx | 2)
#define S_vrtx_NO_MEMORY_AVAILABLE	(M_vrtx | 3)
#define S_vrtx_NOT_A_MEMORY_BLOCK	(M_vrtx | 4)
#define S_vrtx_MAILBOX_IN_USE		(M_vrtx | 5)
#define S_vrtx_ZERO_MESSAGE		(M_vrtx | 6)
#define S_vrtx_BUFFER_FULL		(M_vrtx | 7)
#define S_vrtx_WAITC_IN_PROGRESS	(M_vrtx | 8)
#define S_vrtx_INVALID_SYSTEM_CALL	(M_vrtx | 9)
#define S_vrtx_TIMEOUT			(M_vrtx | 10)
#define S_vrtx_NO_MESSAGE_PRESENT	(M_vrtx | 11)
#define S_vrtx_QUEUE_ID_ERROR		(M_vrtx | 12)
#define S_vrtx_QUEUE_FULL		(M_vrtx | 13)
#define S_vrtx_PARTITION_ID_ERROR	(M_vrtx | 14)


typedef struct vx_tcb		/* VRTX_TCB */
    {
    struct vx_tcb *tcb_next;	/* pointer to next tcb */
    struct vx_tcb *tcb_link;	/* reserved for system */
    TCBX *tcb_extension;	/* pointer to tcb extension */
    unsigned char tcb_priority;	/* task priority */
    unsigned char tcb_id;	/* task id */
    short tcb_status;		/* task status */
    int tcb_data_regs [6];	/* data regs 0-5 */
    int tcb_adrs_regs [4];	/* address regs 0-3 */
    char *tcb_sp;		/* stack pointer save */
    char *tcb_usp;		/* user stack pointer save */
    char *tcb_spbottom;		/* pointer to bottom of stack */
    short tcb_flags;		/* VRTX internal flags */
    int tcb_delay;		/* delay/timeout ticks */
    short tcb_qid;
    int reserved;		/* reserved for vrtx */
    } VRTX_TCB;


/* vrtx configuration table */

typedef struct		/* VRTX_CONFIG_TABLE */
    {
    char *wrkspcAdrs;		/* vrtx RAM address */
    int wrkspcSize;		/* vrtx RAM size */
    short sysStackSize;		/* system stack size */
    short isrStackSize;		/* interrupt service routine stack size */
    int blank1;			/* reserved by vrtx MUST BE SET TO 0 */
    int blank2;			/* reserved by vrtx MUST BE SET TO 0 */
    short vrtxDisableMask;	/* vrtx disable mask */
    short usrStackSize;		/* user stack size */
    int blank3;			/* reserved by vrtx MUST BE SET TO 0 */
    short maxTasks;		/* user task count (max tasks) */
    short blank4;		/* reserved by vrtx MUST BE SET TO 0 */
    FUNCPTR txrdyDriver;	/* Supported IO device driver */
    FUNCPTR tskCreate;		/* task create routine */
    FUNCPTR tskDelete;		/* task delete routine */
    FUNCPTR tskSwitch;		/* task swap routine */
    char *cvt;			/* component vector table address */
    } VRTX_CONFIG_TABLE;

typedef struct
    {
    int d6;
    int d7;
    int a4;
    int a5;
    int a6;
    short sr;
    INSTR *pc;
#if (CPU == MC68020)
    short format;		
#endif
#if (CPU == MC68010)
    short format;		
#endif
    } TCB_STACK;

/* task status values VRTX */

#define VRTX_READY	0x00	/* ready */
#define VRTX_SUSPEND	0x01	/* explicitly suspended */
#define VRTX_PEND	0x02	/* suspended for message */
#define VRTX_GETC	0x04	/* suspended for input */
#define VRTX_PUTC	0x08	/* suspended for output */
#define VRTX_WAITC	0x10	/* awaiting special character */
#define VRTX_DELAY	0x20	/* suspended for task delay (or timeout) */
#define VRTX_QPEND	0x40	/* suspended on queue */

#endif	INCvrtxh
