/* sysLib.h - system dependent routines header */

/*
modification history
--------------------
01k,23may89,dnw  added SYSFLG_NO_STARTUP_SCRIPT.
01j,02may89,dnw  added SYSFLG_VENDOR_{0,1,2,3}.
01i,15oct88,dnw  added SYSFLG_NO_AUTOBOOT, SYSFLG_QUICK_AUTOBOOT,
		   and BOOT_WARM_QUICK_AUTOBOOT.
01h,24mar88,ecs  added declaration of sysExcMsg.
01g,13nov87,jcf  changed names of boot types.
01f,29oct87,dnw  added SYSFLG_DEBUG.
01e,14oct87,dnw  added SYSFLG_NO_SYS_CONTROLLER.
01d,14jul87,dnw  added more system global varaibles.
		 deleted sysLocalToBusAdrs().
		 added system restart types.
01c,14feb87,dnw  added sysBus, sysCpu, sysLocalToBusAdrs
01b,18dec86,llk  added BOOT_FIELD_LEN.
01a,04aug84,dnw  written
*/

#ifndef INCsysLibh
#define INCsysLibh	1


/* system restart types */

#define BOOT_WARM_AUTOBOOT	 0	/* warm - autoboot after count down */
#define BOOT_WARM_NO_AUTOBOOT	 1	/* warm - don't autoboot */
#define BOOT_COLD		 2	/* cold (power on or reset) */
#define BOOT_WARM_QUICK_AUTOBOOT 3	/* warm - autoboot immediately */


/* system configuration flags in sysFlags */

#define SYSFLG_NO_SYS_CONTROLLER 0x01	/* For targets that have sys controllers
					 * that can be enabled in software,
					 * the sys controller is enabled for
					 * processor 0.  This flag inhibits
					 * enabling the sys controller even for
					 * processor 0.
					 */
#define SYSFLG_DEBUG             0x02	/* system debug option -
					 *   load kernel symbol table with all
					 *   symbols (not just globals)
					 */
#define SYSFLG_NO_AUTOBOOT	 0x04	/* Don't start autoboot sequence */
#define SYSFLG_QUICK_AUTOBOOT	 0x08	/* Immediate autoboot (no countdown) */
#define SYSFLG_NO_STARTUP_SCRIPT 0x10	/* Don't read startup script */

#define SYSFLG_VENDOR_0		 0x1000	/* vendor defined flag 0 */
#define SYSFLG_VENDOR_1		 0x2000	/* vendor defined flag 1 */
#define SYSFLG_VENDOR_2		 0x4000	/* vendor defined flag 2 */
#define SYSFLG_VENDOR_3		 0x8000	/* vendor defined flag 3 */


/* length of boot command fields, used for buffers */

#define BOOT_FIELD_LEN	70

/* system target CPU types */

#define TARGET_68K30		1	/* ISI 68K30 */
#define TARGET_68K20		2	/* ISI 68K20 */
#define TARGET_68225		3	/* ISI 68225 */
#define TARGET_E5		4	/* ISI Eagle 5 */

/* system parameters */

#ifndef ASMLANGUAGE

IMPORT int sysBus;		/* system bus type (VME_BUS, MULTI_BUS, etc) */
IMPORT int sysCpu;		/* system cpu type (MC680x0) */
IMPORT int sysTarget;		/* target cpu board type (68225, 68K30, etc)
IMPORT int sysProcNum;		/* processor number of this cpu */
IMPORT char *sysBootLine;	/* address of boot line */
IMPORT char *sysExcMsg;		/* address of exception message area */
IMPORT int sysFlags;		/* configuration flags */
IMPORT char sysBootHost[];	/* name of host from which system was booted */
IMPORT char sysBootFile[];	/* name of file from which system was booted */

/* function declarations */

IMPORT char *sysMemTop ();

#endif ASMLANGUAGE

#endif
