/* rt11Lib.h - header for RT11 file I/O library */

/*
modification history
--------------------
01w,05jun88,dnw  changed rtLib to rt11Lib.
01v,30may88,dnw  changed to v4 names.
01u,04may88,jcf  changed SEMAPHORE to SEM_ID.
01t,25may88,dnw  deleted erroneous ")" in S_rtLib_ENTRY_NUMBER_TOO_BIG def'n.
01s,19aug87,dnw  changed rfd_start to be int instead of short to support
		   disks larger than 32k blocks.
01r,21mar87,gae  spelling, S_rtLib_ENTRY_NUMBER_TO_BIG.
01q,04feb87,llk  made changes which allow a one segment directory to have any
		   number of file entries.  Segments are now dynamically 
		   allocated (vd_dir_seg).  Added vd_nSegBlocks field to 
		   volume descriptor.  It tells how many blocks are in the 
		   volume descriptor's segment.
01p,14jan87,llk  added RT_MAX_FILE_SIZE.  Made de_nblocks unsigned.
01o,24dec86,gae  changed stsLib.h to vwModNum.h.
01n,16oct86,gae	 added vd_mode to RT_VOL_DESC.
01m,07apr86,dnw  replaced vd_ready flag with vd_state in RT_VOL_DESC.
01l,11mar86,dnw  added vd_retry to RT_VOL_DESC.
01k,04sep85,jlf  added vd_ready and vd_reset to RT_VOL_DESC.
01j,14aug85,dnw  added S_rtLib_INVALID_DEVICE_PARAMETERS.
01i,28may85,jlf  changed RT_VOL_DESC to contain disk format info, and sec
		 read and write routines rather than block.
01h,13aug84,ecs  changed status codes: NO_ROOM_ON_DISK to DISK_FULL,
		   NO_SUCH_FILE to FILE_NOT_FOUND,
		   NAME_IN_USE to FILE_ALREADY_EXISTS.
01g,08aug84,ecs  added status codes and include of stsLib.h.
01f,01aug84,dnw  removed single density disk definitions, SD_..., to fd208Drv.c.
01e,06jul84,ecs  removed rfd_entry_num from RT_FILE_DESC.
		 added vd_sem to RT_VOL_DESC.
		 added include of semLib.h.
		 changed rfd_modified from TBOOL to BOOL.
01d,11jun84,dnw  removed vd_volume and added vd_rdblk, vd_wrtblk, and vd_nblocks
		   to RT_VOL_DESC.
		 added definitions of SD_RT_... for single density specific 
		   values.
01c,27jan84,ecs  added inclusion test.
01b,14aug83,dnw  replaced RT_FILE_DESC.rfd_vdnum volume descriptor number with
		   .rfd_vdptr volume descriptor pointer.
		 replaced RT_FILE_DESC.rfd_maxblock end block number with
		   .rfd_endptr end byte pointer.
01a,14Feb83,dnw  written
*/

#ifndef INCrt11Libh
#define INCrt11Libh	1

#include "iosLib.h"
#include "semLib.h"
#include "vwModNum.h"


/* rt11Lib status codes */

#define S_rt11Lib_VOLUME_NOT_AVAILABLE		(M_rt11Lib | 1)
#define S_rt11Lib_DISK_FULL			(M_rt11Lib | 2)
#define S_rt11Lib_FILE_NOT_FOUND		(M_rt11Lib | 3)
#define S_rt11Lib_NO_FREE_FILE_DESCRIPTORS	(M_rt11Lib | 4)
#define S_rt11Lib_INVALID_NUMBER_OF_BYTES	(M_rt11Lib | 5)
#define S_rt11Lib_FILE_ALREADY_EXISTS		(M_rt11Lib | 6)
#define S_rt11Lib_BEYOND_FILE_LIMIT		(M_rt11Lib | 7)
#define S_rt11Lib_INVALID_DEVICE_PARAMETERS	(M_rt11Lib | 8)
#define S_rt11Lib_NO_MORE_FILES_ALLOWED_ON_DISK	(M_rt11Lib | 9)
#define	S_rt11Lib_ENTRY_NUMBER_TOO_BIG		(M_rt11Lib | 10)

/* RT-11 file system constants */

#define RT_DIR_BLOCK		6
#define RT_BYTES_PER_BLOCK	512
#define RT_FILES_FOR_2_BLOCK_SEG 72
#define RT_MAX_BLOCKS_PER_FILE	0xffff	/* maximum number of blocks per file,
					   largest size described by an unsigned
					   short (de_nblocks field of
					   RT_DIR_ENTRY) */


/* directory entry status values */

#define DES_TENTATIVE	0x0100		/* tentative file */
#define DES_EMPTY	0x0200		/* empty space */
#define DES_PERMANENT	0x0400		/* permanent file */
#define DES_END		0x0800		/* end of directory segment marker */

#define DES_BOGUS	0x0000		/* not a real RT-11 directory entry */


/* miscellaneous */

#define NOT_IN_USE	-1		/* descriptor not-in-use flag,
					 *   in fd.rfd_status, vd.rfd_status */

/* RT-11 radix-50 name structure */

typedef struct		/* RT_NAME */
    {
    unsigned short nm_name1;	/* filename chars 1-3 in radix-50 */
    unsigned short nm_name2;	/* filename chars 4-6 in radix-50 */
    unsigned short nm_type;	/* file type chars 1-3 in radix-50 */
    } RT_NAME;


/* directory entry */

typedef struct		/* RT_DIR_ENTRY */
    {
    short de_status;		/* file status */
    RT_NAME de_name;		/* filename in radix-50 structure */
    unsigned short de_nblocks;	/* number of blocks in file */
    char  de_jobnum;		/* (temp file only) job with file open */
    char  de_channel;		/* (temp file only) channel with file is open */
    short de_date;		/* file creation date:
				 *	bits 14-10 = month (1-12) in decimal
				 *      bits  9- 5 = day (1-31) in decimal
				 *      bits  4- 0 = year minus 110 in octal
				 */
    } RT_DIR_ENTRY;


/* directory segment */

typedef struct		/* RT_DIR_SEG */
    {
    short ds_nsegs;		/* number of segments in directory */
    short ds_next_seg;		/* number of next segment (0 = end of list) */
    short ds_last_seg;		/* number of highest segment used */
    short ds_extra;		/* number of extra bytes on each dir entry */
    short ds_start;		/* number of first data block for this seg */
    RT_DIR_ENTRY ds_entries [1]; /* directory entries, 
				    actual size gets dynamically allocated */
    } RT_DIR_SEG;


/* volume descriptor */

typedef struct		/* RT_VOL_DESC */
    {
    DEV_HDR vd_devhdr;		/* i/o system device header (MUST COME FIRST!)*/
    short vd_status;		/* (OK | ERROR) */
    SEM_ID vd_semId;		/* volume descriptor semaphore id */
    int vd_nblocks;		/* number of blocks in volume */
    FUNCPTR vd_rdSec;		/* function to call to read a sector */
    FUNCPTR vd_wrtSec;		/* function to call to write a sector */
    FUNCPTR vd_reset;		/* function to call to reset device */
    BOOL vd_rtFmt;		/* TRUE if using RT-11 skew and track offset */
    int vd_bytesPerSec;		/* bytes-per-sector */
    int vd_secBlock;		/* Number of sectors per block */
    int vd_secTrack;		/* Number of physical sectors per track */
    int vd_nSectors;		/* Size of volume, in sectors */
    int vd_state;		/* state of volume (see below) */
    int vd_retry;		/* retry count of disk operations */
    int vd_mode;		/* mode of volume, READ, WRITE, UPDATE */
    int vd_nSegBlocks;		/* number of blocks in the directory segment,
				   there are always at least 2 */
    RT_DIR_SEG *vd_dir_seg;	/* pointer to current directory segment */
    } RT_VOL_DESC;

/* volume states */

#define RT_VD_READY_CHANGED	0	/* vol not accessed since ready change*/
#define RT_VD_RESET		1	/* volume reset but not mounted */
#define RT_VD_MOUNTED		2	/* volume mounted */
#define RT_VD_CANT_RESET	3	/* volume reset failed */
#define RT_VD_CANT_MOUNT	4	/* volume mount failed */


/* RT-11 file descriptor */

typedef struct		/* RT_FILE_DESC */
    {
    short rfd_status;		/* (OK | NOT_IN_USE) */
    RT_VOL_DESC *rfd_vdptr;	/* pointer to RT-11 volume descriptor */
    int rfd_start;		/* number of first block in file */
    short rfd_mode;		/* access mode: READ, WRITE, UPDATE */
    RT_DIR_ENTRY rfd_dir_entry;	/* directory entry for this file */
    int rfd_curptr;		/* file byte ptr of current buffer byte 0 */
    int rfd_newptr;		/* file byte ptr for new read/writes */
    int rfd_endptr;		/* file byte ptr to end of file */
    BOOL rfd_modified;		/* TRUE = buffer has been modified */
    char rfd_buffer [RT_BYTES_PER_BLOCK];
    } RT_FILE_DESC;


/* function declarations */

RT_FILE_DESC *rt11Create ();
RT_FILE_DESC *rt11Open ();

#endif
