/* rfDrv.h  header file for vxWorks rimfire 3200 SMD driver */ 

/*
modification history
--------------------
01b,01may89,del  documentation.
01a,29nov88,del  written.
*/


#define	HOST_ID		1	/* unique host identifier */
				/* can be 1 thru 7 , see ciprico man. 2-11 */

				/* VME address modifier for VME memory */
#define	VME_ADD_MOD	VME_AM_STD_SUP_DATA

				/* 32 bit xfer, NO word or byte swapping */
				/* OR in CTRLWID for 32 bit xfer*/
#define	CNTRL		(CTRLSET | CTRLWID)  

#define	NRFC	1 			/* no. controllers */
#define	NRF	1			/* no. of drives */
#define RF_MEM_BASE 0x800000		/* extened mem @ 8M */
#define RF_MEM_SIZE 0x080000		/* 512K */

/* macro for waiting for the controller to finish executing a command */
#define CDELAY(c, n) { \
			int end = tickGet () + n * sysClkRateGet (); \
                        while (tickGet () < end) \
                            { \
                            if (c) \
                                break; \
                            taskDelay (1); \
                            } \
                        }

#ifdef NOHANG
static int waitsb = FALSE;		/* wait for sb */
#endif NOHANG
					/* Debugging aids */
/* #define	DSKBUG    */

#ifdef	RFSTATS
					/* Statistic gathering information: */
static int	iorqsi = 0;
static IORQ	iorq;
static int	niorqs = sizeof (iorq.iorqs) / (sizeof iorq.iorqs[0]);
#endif

					/* How long can we hold the bus? */
#define THROTTLE 8 			/* 8 transfers (32 bytes)  
					 * - the size of the bus fifo */

					/* How long is too long ? */
#define TOOLONG 	20		/* 20 seconds */
#define WAYTOOLONG 	900		/* 900 seconds */


/* ----------------------------------------------------------------------------
*  COPTXHD = READ AHEAD ACROSS HEAD
*  COPTXCY = READ AHEAD ACROSS CYLINDERS
*  COPTSEA = SEARCH CACHE
*
*  Group 1, for physical I/O, is set up for read ahead across heads, cylinders,
*  and searching cache.  Also the read ahead length is 100 sectors.
*
*  Group 2, 4k Multiples: read ahead across heads, and search cache. 
*  Also the read ahead length is 100 sectors.
*
*  Group 3, NON 4k Multiples: set the same as group 2. 
*/

static IOCGRP iocg[MAXIOCG+1] = 
    {
    /* group, cache, readahead, recovery, dretry, ndretry, resv */
    { 0, 	  0, 	     0,	       0,     11,       3,    0 },
    { 1, COPTXHD | COPTSEA | COPTXCY, 255, 0, 3, 3, 0 },/* PHYS RD/WT */
			    /* 4K Multiples, to add cylinders add COPTXCY */
    { 2, COPTXHD | COPTSEA, 255, 0, 3, 3, 0 },
			       /* ~4K Multiples */ 
    { 3, COPTSEA, 0, 0, 3, 3, 0 },	
    };

#define	XTCFF	(1)	/* byte in "extra" field of geometry information) */
#define	POSCFF	(127)	/* byte position in dkl_asciilabel of conf flags  */


/* -------------------------------------- Label Stuff -----------------------*/

#define	DKL_MAGIC	0xDABE		/* magic number */
#define	NDKMAP	8			/* # of logical partitions */

/* ---------------------------------------Disk geometry ---------------------*/
typedef struct
    {
    int	trkdisk;	/* tracks / disk */
    int	sectrk;		/* sectors / track */
    int	bytsec;		/* bytes / sector */
    int	nhead;		/* number of data heads */
    int	n;     		/* bytes per sector code */
    int	gplfmt;
    int	dtl; 		/* bytes per sector (only if n==00) */
    int	nFiles; 	/* number of files */
    int	ncyl;		/* # of data cylinders */
    int	acyl;		/* # of alternate cylinders */
    int	bcyl;		/* cyl offset (for fixed head area) */
    int	bhead;		/* head offset (for Larks, etc.) */
    int	intrlv;		/* interleave factor */
    int	gap1;		/* gap 1 size */
    int	gap2;		/* gap 2 size */
    int	apc;		/* alternates per cyl (SCSI only) */
    int ppart;		/* physical partition # */
    } DISK_GEOM;
 
 
/* --------------------------------------- Logical Partition Map ------------*/

typedef	struct	partMap 
    {	
    int		partNo;			/* logical partition number */
    char 	name[8];		/* device name */
    int  	drive;			/* physical drive number */
    BOOL 	rtFmt;			/* rt11 format or not */
    int  	trkOffset; 		/* starting track */
    int  	nTracks;		/* length of this device */
    int  	devType;		/* type of device */
    } PART_MAP;

/* ----------------------------------------------------------------------------
* Format of a vxWorks SMD disk label.
* Resides in cylinder 0, sector 0 on each head which is the first
* head of a physical partition (e.g., heads 0 and 2 for a CDC Lark).
* dkl_ppart gives the physical partition number (currently only 0 or 1).
* dkl_bhead must match the head on which the label is found;
* otherwise the label was probably overwritten by another.
*
* sizeof(RF_LABEL) should be 512 (sector size)
*/


typedef struct  
    {
    char	asciilabel[128];
    char	pad[512 - ( 128
			+ sizeof(DISK_GEOM) 
			+ (sizeof(PART_MAP) * NDKMAP)
			+ (2 * sizeof(USHORT))
			  )];
    DISK_GEOM 	geom;			/* geometry of disk */
    PART_MAP	map[NDKMAP];		/* logical partition map */
    USHORT	magic;			/* identifies this label format */
    USHORT	cksum;			/* xor checksum of sector */
    } RF_LABEL;


/* static structure containing the defualt geometry for a SMD disk label */

static RF_LABEL smdLabel[] = 
    {
	{ "Fujitsu 2223 cyl 821 alt 0 hd 10 sctk 33 bh 0 apc 0", "",
	/* trkdsk */	  0,
	/* sectrk */ 	 33,
	/* bytsec */	512,
	/* nhead  */ 	 10,
	/* n	  */	  0,
	/* gplfmt */      0,
	/* dtl    */      0,
	/* nFiles */	  RT_FILES_FOR_2_BLOCK_SEG,
	/* ncyl   */ 	821, 
	/* acyl   */ 	  0,
	/* bcyl	  */	  0,
	/* bhead  */ 	  0,
	/* intrlv */ 	  0, 
	/* gap1   */ 	  0,
	/* gap2   */ 	  0,
	/* apc    */ 	  0,
	/* ppart  */ 	  0,
	/* map    */ 	
	/* partNo, name, drive, rtFmt, trkofst, ntrk, devType */
	        0,    "",     0,     0,       0,    0,       0,
	        0,    "",     0,     0,       0,    0,       0,
	        0,    "",     0,     0,       0,    0,       0,
	        0,    "",     0,     0,       0,    0,       0,
	        0,    "",     0,     0,       0,    0,       0,
	        0,    "",     0,     0,       0,    0,       0,
	        0,    "",     0,     0,       0,    0,       0,
	        0,    "",     0,     0,       0,    0,       0,
	/* magic  */	  0,
	/* chksum */      0
	}
    };
/* ------------------------ vxWorks/rf3200 data types ---------------------*/
 
typedef struct
    {
    int		partNo;
    PART_MAP	map[NDKMAP];
    } RF_PARTITION;

typedef struct rfDev		/* RF_DEV - rf device descriptor */
    {				/* one per logical device */
    RT_VOL_DESC	rtvol;		/* RT-11 volume descriptor */
    int 	ctlr; 		/* controller number */
    PART_MAP	devInfo;	/* device information (for label/mount)*/
    SEM_ID	devSemId;	/* m.e. sem for device */
    SEM_ID	intrSemId;	/* sync sem for device */
    DISK_GEOM	*pDiskGeom;	/* disk format record info */
    PARMBLK	*pPB;		/* paramblk for device */
    struct rfDev *next;		/* For chaining devs */
    } RF_DEV;

typedef struct			/* DRIVE - one per drive */
    {
    int 	drive;		/* drive number */
    RF_DEV 	*devs;		/* list of devs created on this drive */
    RF_DEV	*activeDev;	/* last device making a request on this drive*/
    SEM_ID	semId;		/* m.e. sem ID */
    SEM_ID	intrSemId;	/* interrupt lvl to task lvl sync semaphore */
    int		intStatus;	/* status from interrupt level processing */
    WDOG_ID	wdog;		/* watchdog id */
    BOOL 	timedOut;	/* set TRUE if wdog times out */
    int		devType;	/* type of drive */
    BOOL	ioCtlState;	/* TRUE if doing ioctl commands */
    IOCTL_INFO  ioCtlInfo	/* info from ioCtl commands, see rfIoctl.h */
    } DRIVE;

typedef struct 			/* info particular to the controller */
    {
    int		rfctype;	/* controller type */
    int		bsybit;		/* busy bit toggle */
    int		ctlr;		/* controller number */
    int		driveCnt;	/* number of physical drives on controller */
    UINT	addrs;		/* addrs of this controller */
    UINT	localAdrs;	/* addrs of this controller */
    UINT	intVec;		/* interrupt vector of rfDrv */
    UINT	intLvl;		/* interrupt level of ctlr */
    SEM_ID	rfSemId;	/* semaphore id for controller */
    CMDLIST	*pCmdList;	/* command list for controller */
    DRIVE	*pDrives[NRF];	/* drive descriptors */
    } RF_CTLR;


/* -------------------------------------------- Error Codes -----------------*/

#define ERRFILE			/* we were here */
#define	RFE_INVCMD	0x01	/* invalid command */
#define	RFE_UNITNO	0x02	/* bad unit number */
#define	RFE_UNITTYPE	0x03	/* invalid unit for this command */
#define	RFE_NOCONF	0x04	/* drive not configured */
#define	RFE_BLOCKSTRT	0x06	/* invalid logical block number */
#define	RFE_BLOCKCNT	0x07	/* bad number of block specified */
#define	RFE_TRACKSTRT	0x08	/* bad track starting block */
#define	RFE_TRACKCNT	0x09	/* bad number of blocks for track-wide op */
#define	RFE_BADTAG	0x0a	/* bad tag number */
#define	RFE_NOTZERO	0x0b	/* reserved field in parameter block not zero */
#define	RFE_SGLISTSIZ	0x0c	/* bad number of scatter/gather headers */
#define	RFE_INVTABLE	0x0d	/* bad length of scatter/gather table */
#define RFE_INVCMDLS	0x0f	/* bad command list size */
#define RFE_INVCMDLN	0x10	/* bad command list number >7 or <1 */
#define	RFE_INVCMDL	0x11	/* command list cannot be started/stopped */
#define RFE_SWBTO	0x12	/* software bus timeout */
#define	RFE_BUSTIME	0x13	/* VMEbus memory timeout */
#define	RFE_NODRIVE	0x14	/* drive won't select or not present */
#define	RFE_DRIVERDY	0x15	/* drive is not ready */
#define RFE_DRIVEBSY	0x16	/* disk busy */
#define	RFE_SEEKFAULT	0x1c	/* drive reported seek fault */
#define	RFE_WRITFAULT	0x1e	/* write fault detected */
#define	RFE_OVERRUN	0x23	/* sector too short / overrun error */
#define	RFE_ECC		0x24	/* data ECC error, no correction done */
#define	RFE_IDSYNC	0x25	/* ID sync error (sector not found) */
#define	RFE_IDCRC	0x26	/* ID CRC error */
#define	RFE_DATASYNC	0x27	/* no data synchronization */
#define	RFE_SEEKTIME	0x28	/* seek timeout */
#define	RFE_DATATIME	0x29	/* data operation timeout */
#define	RFE_MISSEEK	0x2a	/* misseek / bad disk format */
#define	RFE_SECTORID	0x2b	/* error reading sector ID */
#define	RFE_ACCESSBAD	0x2c	/* direct access to a bad track or sector */
#define	RFE_ECCTRY	0x2d	/* ECC correction performed */
#define	RFE_ECCFAIL	0x2e	/* ECC correction failed */
#define RFE_SECTCOUNT	0x2f	/* bad sector count	*/
#define RFE_WRITEPROT	0x31	/* drive write protected */
#define	RFE_INVSECTRK	0x32	/* sectors per track greater than physical */
#define	RFE_BADBPS	0x33	/* bad bytes/sector field */
#define	RFE_TOOLONG	0x34	/* field too long */
#define	RFE_BADPARAM	0x37	/* bad parameter in configure command */
#define	RFE_IOCG0	0x39	/* attempt to initialize control group 0 */
#define	RFE_BADSOURCE	0x3a	/* bad source in defect mapping command */
#define	RFE_BADDEST	0x3b	/* bad destination in defect mapping command */
#define	RFE_NOSPARE	0x3c	/* no spare sectors left on this track */
#define	RFE_RECOVERY	0x3d	/* bad recovery field in defect mapping cmd */
#define	MAXERRCODE	0x3d

/* ------------------------------------------Error Messages ------------------*/

char *rfmsg[] = 
    {
    /* 0x00 */	"00 - unknown",
    /* 0x01 */	"invalid command",
    /* 0x02 */	"bad unit number specification",
    /* 0x03 */	"bad unit type for this command",
    /* 0x04 */	"drive not configured",
    /* 0x05 */	"05 - unknown",
    /* 0x06 */	"bad logical block number specified",
    /* 0x07 */	"bad number of blocks specified",
    /* 0x08 */	"bad track starting block",
    /* 0x09 */	"bad number of block for track-wide operation",
    /* 0x0a */	"bad tag",
    /* 0x0b */	"reserved field not zero",
    /* 0x0c */	"bad number of scatter/gather headers specified",
    /* 0x0d */	"bad length of scatter/gather table",
    /* 0x0e */	"command list stopped (info only)",
    /* 0x0f */	"command list size invalid",
    /* 0x10 */	"command list number invalid",
    /* 0x11 */	"command list already started/stopped",
    /* 0x12 */	"software bus timeout",
    /* 0x13 */	"VMEbus memory timeout",
    /* 0x14 */	"drive won't select or not present",
    /* 0x15 */	"drive not ready",
    /* 0x16 */	"disk busy",
    /* 0x17 */	"17 - unknown",
    /* 0x18 */	"18 - unknown",
    /* 0x19 */	"19 - unknown",
    /* 0x1a */	"1A - unknown",
    /* 0x1b */	"1B - unknown",
    /* 0x1c */	"drive reported seek fault",
    /* 0x1d */	"1D - unknown",
    /* 0x1e */	"write fault detected",
    /* 0x1f */	"1F - unknown",
    /* 0x20 */	"20 - unknown",
    /* 0x21 */	"21 - unknown",
    /* 0x22 */	"22 - unknown",
    /* 0x23 */	"sector too short / overrun error",
    /* 0x24 */	"data ECC error, no correction done",
    /* 0x25 */	"ID sync error, sector not found",
    /* 0x26 */	"ID CRC error",
    /* 0x27 */	"no data synchronization",
    /* 0x28 */	"seek timeout",
    /* 0x29 */	"data operation timeout",
    /* 0x2a */	"misseek / bad disk format",
    /* 0x2b */	"error reading sector ID",
    /* 0x2c */	"direct access to bad track or sector",
    /* 0x2d */	"ECC correction performed",
    /* 0x2e */	"ECC correction failed",
    /* 0x2f */	"sector count doesn't match hardware",
    /* 0x30 */	"30 - unknown",
    /* 0x31 */	"drive write protected",
    /* 0x32 */	"sectors per track bad or greater than physical size",
    /* 0x33 */	"bytes/sector field bad",
    /* 0x34 */	"field too long (preamble gap)",
    /* 0x35 */	"35 - unknown",
    /* 0x36 */	"36 - unknown",
    /* 0x37 */	"bad parameter in configure command",
    /* 0x38 */	"38 - unknown",
    /* 0x39 */	"attempt to initialize control group 0",
    /* 0x3a */	"bad source in defect mapping command",
    /* 0x3b */	"bad destination in defect mapping command",
    /* 0x3c */	"no spares left on track",
    /* 0x3d */	"bad recovery field in defect mapping command"
    };



