/* picture.h - jump picture header */

/*
modification history
--------------------
02f,29mar89,shl  documentation.
02e,29mar89,shl  changed declaration of ex_io, bp_io and enp_io to make 
		 force foucs32 happy
02d,04may88,ak	 fixed up to handle mv135's weird definition of
		 LOCAL_MEM_BUS_ADRS gracefully
02c,08apr88,dnw  added definitions of HORIZONTAL_3 and VERTICAL_3.
02b,04apr88,gae  added IMPORTs of ie_...
02a,16mar88,gae  moved config_sym.c stuff here to work with new jump.
		 got rid of unused #define's.
01b,10dec87,jcf  added mv133a.
01a,07nov87,jcf  created.
*/

#ifndef	INCpictureh
#define	INCpictureh

/* jumper types */

#define HORIZONTAL	0	/* horizontal pair */
#define VERTICAL	1	/* vertical pair */
#define HORIZONTAL_3	2	/* horizontal 3 pin jumper */
#define VERTICAL_3	3	/* vertical 3 pin jumper */

#ifdef	INCconfigh
/* optional facilities defined in config/<target>/config.h */

#ifdef INCLUDE_DBX
int inc_dbx = TRUE;		/* support for dbx package */
#else
int inc_dbx = FALSE;
#endif

#ifdef INCLUDE_RPC
int inc_rpc = TRUE;		/* support for rpc package */
#else
int inc_rpc = FALSE;
#endif

#ifdef INCLUDE_FLOATING_POINT
int inc_fp = TRUE;		/* support for floating point i/o */
#else
int inc_fp = FALSE;
#endif

#ifdef INCLUDE_INCLUDE_MC68881
int inc_fc = TRUE;		/* support for MC68881 flt pt proc. */
#else
int inc_fc = FALSE;
#endif

#ifdef INCLUDE_EX
int inc_ex = TRUE;		/* include Excellan Ethernet interface*/
char *ex_io  =(char *)IO_ADRS_EX;	/* 24A,32D Excelan Ethernet controller*/
int il_ex  =	INT_LVL_EX;	/* Excelan interrupt level */
#else
int inc_ex = FALSE;
char *ex_io  =	(char *) NONE;
int il_ex  =	NONE;
#endif

#ifdef INCLUDE_ENP
int inc_enp = TRUE;		/* include CMC Ethernet interface*/
char *enp_io = (char *)IO_ADRS_ENP;     /* 24A,32D CMC Ethernet contr */
int il_enp = 	INT_LVL_ENP;	/* CMC interrupt level */
#else
int inc_enp = FALSE;
char *enp_io =	(char *) NONE;
int il_enp = 	NONE;		
#endif

#ifdef INCLUDE_IE
int inc_ie = TRUE;		/* include Sun Ethernet interface*/
int ie_io  =	(int) IO_ADRS_IE;	/* 24A,32D Sun Ethernet controller */
int il_ie  = 	INT_LVL_IE;	/* Sun interrupt level */
#else
int inc_ie = FALSE;
int ie_io  =	NONE;
int il_ie  = 	NONE;
#endif

#ifdef INCLUDE_NW
int inc_nw = TRUE;		/* include ISI Ethernet interface */
int nw_io  =	(int) IO_ADRS_NW;	/* 24A,32D ISI Ethernet controller */
int il_nw  = 	INT_LVL_NW;	/* ISI interrupt level */
#else
int inc_nw = FALSE;
int nw_io  =	NONE;
int il_nw  = 	NONE;
#endif

#ifdef INCLUDE_PN
int inc_pn = TRUE;		/* include Proteon ProNet interface*/
int pn_io  =	(int) IO_ADRS_PN;	/* 24A,32D Proteon ProNet controller*/
int il_pn  = 	INT_LVL_PN;	/* Proteon interrupt level */
#else
int inc_pn = FALSE;
int pn_io  =	NONE;
int il_pn  = 	NONE;
#endif

#ifdef INCLUDE_BP
int inc_bp = TRUE;		/* include backplane driver */
char *bp_io = (char *)BP_MEM_ADRS;	
#else
int inc_bp = TRUE;		/* include backplane driver */
char *bp_io =	(char *) NONE;	
#endif

#if defined(LOCAL_MEM_BUS_ADRS) && !defined(TARGET_MV135)
int low_byte_bus =	(int) LOCAL_MEM_BUS_ADRS;
#else
int low_byte_bus =	(int) NONE;
#endif

#else	INCconfigh

			/* Excelan EXOS 202 */
IMPORT int inc_ex;
IMPORT int ex_io;
IMPORT int il_ex;
			/* CMC enp10 */
IMPORT int inc_enp;
IMPORT int enp_io;
IMPORT int il_enp;
			/* SUN ie */
IMPORT int inc_ie;
IMPORT int ie_io;
IMPORT int il_ie;
			/* ISI nw */
IMPORT int inc_nw;
IMPORT int nw_io;
IMPORT int il_nw;
			/* PROTEON pronet */
IMPORT int inc_pn;
IMPORT int pn_io;
IMPORT int il_pn;

			/* backplane */
IMPORT int bp_io;

#endif	INCconfigh

#endif	INCpictureh
