/* m68901.h - Motorola MC68901 MFP (Multi-Function Peripheral) */

/*
modification history
--------------------
01d,15feb89,jcc  incorporated MFP_REG_ADDR_INTERVAL into 
		 register address definitions.
01c,16jan89,jcf  added defines for rest of chip.
01b,04may88,gae  fixed name on banner.
01a,30apr88,gae	 extracted from mv133.h.
*/

#ifndef	INCm68901h
#define	INCm68901h

/* register definitions */

						   /* Data I/O port */
#define MFP_GPIP(base)  ((char *)((base)+(0x00*MFP_REG_ADDR_INTERVAL)))	   
						   /* active edge register */
#define MFP_AER(base)	((char *)((base)+(0x01*MFP_REG_ADDR_INTERVAL)))	   
						   /* data direction reg. */
#define MFP_DDR(base)	((char *)((base)+(0x02*MFP_REG_ADDR_INTERVAL)))    
						   /* interrupt enable reg A */
#define MFP_IERA(base)  ((char *)((base)+(0x03*MFP_REG_ADDR_INTERVAL)))    
						   /* interrupt enable reg B */
#define MFP_IERB(base)  ((char *)((base)+(0x04*MFP_REG_ADDR_INTERVAL)))    
						   /* int. pending reg A */
#define MFP_IPRA(base)  ((char *)((base)+(0x05*MFP_REG_ADDR_INTERVAL)))    
						   /* int. pending reg B */
#define MFP_IPRB(base)  ((char *)((base)+(0x06*MFP_REG_ADDR_INTERVAL)))    
						   /* int. in-service reg A */
#define MFP_ISRA(base)  ((char *)((base)+(0x07*MFP_REG_ADDR_INTERVAL)))    
						   /* int. in-service reg B */
#define MFP_ISRB(base)  ((char *)((base)+(0x08*MFP_REG_ADDR_INTERVAL)))    
						   /* interrupt mask reg A */
#define MFP_IMRA(base)  ((char *)((base)+(0x09*MFP_REG_ADDR_INTERVAL)))    
						   /* interrupt mask reg B */
#define MFP_IMRB(base)  ((char *)((base)+(0x0a*MFP_REG_ADDR_INTERVAL)))    
						   /* vector reg */
#define MFP_VR(base)	((char *)((base)+(0x0b*MFP_REG_ADDR_INTERVAL)))    
						   /* timer A control reg */
#define MFP_TACR(base)  ((char *)((base)+(0x0c*MFP_REG_ADDR_INTERVAL)))    
						   /* timer B control reg */
#define MFP_TBCR(base)  ((char *)((base)+(0x0d*MFP_REG_ADDR_INTERVAL)))    
						   /* timers B&C control reg */
#define MFP_TCDCR(base) ((char *)((base)+(0x0e*MFP_REG_ADDR_INTERVAL)))    
						   /* timer A data reg */
#define MFP_TADR(base)  ((char *)((base)+(0x0f*MFP_REG_ADDR_INTERVAL)))    
						   /* timer B data reg */
#define MFP_TBDR(base)  ((char *)((base)+(0x10*MFP_REG_ADDR_INTERVAL)))    
						   /* timer C data reg */
#define MFP_TCDR(base)  ((char *)((base)+(0x11*MFP_REG_ADDR_INTERVAL)))    
						   /* timer D data reg */
#define MFP_TDDR(base)  ((char *)((base)+(0x12*MFP_REG_ADDR_INTERVAL)))    
						   /* sync char reg */
#define MFP_SCR(base)	((char *)((base)+(0x13*MFP_REG_ADDR_INTERVAL)))    
						   /* USART control reg */
#define MFP_UCR(base)	((char *)((base)+(0x14*MFP_REG_ADDR_INTERVAL)))    
						   /* receiver status reg */
#define MFP_RSR(base)	((char *)((base)+(0x15*MFP_REG_ADDR_INTERVAL)))    
						   /* transmitter status reg */
#define MFP_TSR(base)	((char *)((base)+(0x16*MFP_REG_ADDR_INTERVAL)))    
						   /* USART data reg */
#define MFP_UDR(base)   ((char *)((base)+(0x17*MFP_REG_ADDR_INTERVAL)))    

/* vector number offsets */

#define MFP_INT_GP0		0x00		/* general purpose I0 */
#define MFP_INT_GP1		0x01		/* general purpose I1 */
#define MFP_INT_GP2		0x02		/* general purpose I2 */
#define MFP_INT_GP3		0x03		/* general purpose I3 */
#define MFP_INT_TIMER_D		0x04		/* timer D */
#define MFP_INT_TIMER_C		0x05		/* timer C */
#define MFP_INT_GP4		0x06		/* general purpose I4 */
#define MFP_INT_GP5		0x07		/* general purpose I5 */
#define MFP_INT_TIMER_B		0x08		/* timer B */
#define MFP_INT_TX_ERR		0x09		/* transmit error */
#define MFP_INT_TRANS		0x0a		/* transmit buffer empty */
#define MFP_INT_RX_ERR		0x0b		/* receive error */
#define MFP_INT_RECV		0x0c		/* receive buffer full */
#define MFP_INT_TIMER_A		0x0d		/* timer A */
#define MFP_INT_GP6		0x0e		/* general purpose I6 */
#define MFP_INT_GP7		0x0f		/* general purpose I7 */

/* fields of vector register (VR) */

#define MFP_VR_SOFT		0x08	/* software acknowledge interrupts */

/* fields of interrupt enable A (IERA), interrupt pending A (IPRA), */
/* interrupt in-service A (ISRA), interrupt mask A (IMRA) */

#define MFP_A_TIMER_B		0x01	/* timer B */
#define MFP_A_TX_ERR		0x02	/* transmitter error */
#define MFP_A_TX_EMPTY		0x04	/* transmitter buffer empty */
#define MFP_A_RX_ERR		0x08	/* receiver error */
#define MFP_A_RX_FULL		0x10	/* receiver buffer full */
#define MFP_A_TIMER_A		0x20	/* timer A */
#define MFP_A_GPIP6		0x40	/* general purpose i/o 6 */
#define MFP_A_GPIP7		0x80	/* general purpose i/o 7 */

/* fields of interrupt enable B (IERB), interrupt pending B (IPRB), */
/* interrupt in-service B (ISRB), interrupt mask B (IMRB) */

#define MFP_B_GPIP0		0x01	/* general purpose i/o 0 */
#define MFP_B_GPIP1		0x02	/* general purpose i/o 1 */
#define MFP_B_GPIP2		0x04	/* general purpose i/o 2 */
#define MFP_B_GPIP3		0x08	/* general purpose i/o 3 */
#define MFP_B_TIMER_D		0x10	/* timer D */
#define MFP_B_TIMER_C		0x20	/* timer C */
#define MFP_B_GPIP4		0x40	/* general purpose i/o 4 */
#define MFP_B_GPIP5		0x80	/* general purpose i/o 5 */

/* fields of usart control register (UCR) */

#define MFP_UCR_16X		0x80	/* divide clock souce by 16 */
#define MFP_UCR_8BIT		0x00	/* 8 bit word length */
#define MFP_UCR_7BIT		0x20	/* 7 bit word length */
#define MFP_UCR_6BIT		0x40	/* 6 bit word length */
#define MFP_UCR_5BIT		0x60	/* 5 bit word length */
#define MFP_UCR_SYNC		0x00	/* synchronous */
#define MFP_UCR_1STOP		0x08	/* one stop bit */
#define MFP_UCR_1_AND_HALF_STOP	0x10	/* one and a half stop bits */
#define MFP_UCR_2STOP		0x18	/* two stop bits */
#define MFP_UCR_NO_PARITY	0x00	/* disable parity */
#define MFP_UCR_EVEN_PARITY	0x06	/* enable even parity */
#define MFP_UCR_ODD_PARITY	0x04	/* enable odd parity */

/* fields of receiver status register (RSR) */

#define MFP_RSR_RX_ENABLE		0x01	/* enable receiver */
#define MFP_RSR_SYNC_STRIP_ENABLE	0x02	/* strip sync characters */
#define MFP_RSR_CHAR_IN_PROGRESS	0x04	/* receiving a character */
#define MFP_RSR_BREAK_DETECT		0x08	/* break detect */
#define MFP_RSR_FRAME_ERROR		0x10	/* framing error */
#define MFP_RSR_PARITY_ERROR		0x20	/* parity error */
#define MFP_RSR_OVERRUN_ERROR		0x40	/* overrun error */
#define MFP_RSR_BUFFER_FULL		0x80	/* receive buffer full */

/* fields of transmitter status register (TSR) */

#define MFP_TSR_TX_ENABLE		0x01	/* enable receiver */
#define MFP_TSR_HI_Z			0x00	/* hi - Z */
#define MFP_TSR_LOW			0x02	/* LOW */
#define MFP_TSR_HIGH			0x04	/* HIGH */
#define MFP_TSR_LOOP			0x06	/* LOOP */
#define MFP_TSR_BREAK			0x08	/* transmit break */
#define MFP_TSR_EOT			0x10	/* end of transmission */
#define MFP_TSR_AUTO_TURNAROUND		0x20	/* parity error */
#define MFP_TSR_UNDERRUN_ERROR		0x40	/* overrun error */
#define MFP_TSR_BUFFER_EMPTY		0x80	/* transmit buffer empty */

/* fields of timer A and B control register */

#define MFP_TCR_RESET		0x10	/* reset timer */
#define MFP_TCR_STOP		0x0	/* stop timer */
#define MFP_TCR_DELAY_4		0x1	/* delay mode, divide by 4 prescale */
#define MFP_TCR_DELAY_10	0x2	/* delay mode, divide by 10 prescale */
#define MFP_TCR_DELAY_16	0x3	/* delay mode, divide by 16 prescale */
#define MFP_TCR_DELAY_50	0x4	/* delay mode, divide by 50 prescale */
#define MFP_TCR_DELAY_64	0x5	/* delay mode, divide by 64 prescale */
#define MFP_TCR_DELAY_100	0x6	/* delay mode, divide by 100 prescale */
#define MFP_TCR_DELAY_200	0x7	/* delay mode, divide by 200 prescale */
#define MFP_TCR_EVENT		0x8	/* event count mode */
#define MFP_TCR_PULSE_4		0x9	/* pulse mode, divide by 4 prescale */
#define MFP_TCR_PULSE_10	0xa	/* pulse mode, divide by 10 prescale */
#define MFP_TCR_PULSE_16	0xb	/* pulse mode, divide by 16 prescale */
#define MFP_TCR_PULSE_50	0xc	/* pulse mode, divide by 50 prescale */
#define MFP_TCR_PULSE_64	0xd	/* pulse mode, divide by 64 prescale */
#define MFP_TCR_PULSE_100	0xe	/* pulse mode, divide by 100 prescale */
#define MFP_TCR_PULSE_200	0xf	/* pulse mode, divide by 200 prescale */

/* fields of timer C and D control register */

#define MFP_TCDCR_D_MASK	0x7	/* timer D mask */
#define MFP_TCDCR_D_STOP	0x0	/* stop timer */
#define MFP_TCDCR_D_DELAY_4	0x1	/* delay mode, divide by 4 prescale */
#define MFP_TCDCR_D_DELAY_10	0x2	/* delay mode, divide by 10 prescale */
#define MFP_TCDCR_D_DELAY_16	0x3	/* delay mode, divide by 16 prescale */
#define MFP_TCDCR_D_DELAY_50	0x4	/* delay mode, divide by 50 prescale */
#define MFP_TCDCR_D_DELAY_64	0x5	/* delay mode, divide by 64 prescale */
#define MFP_TCDCR_D_DELAY_100	0x6	/* delay mode, divide by 100 prescale */
#define MFP_TCDCR_D_DELAY_200	0x7	/* delay mode, divide by 200 prescale */

#define MFP_TCDCR_C_MASK	0x70	/* timer C mask */
#define MFP_TCDCR_C_STOP	0x00	/* stop timer */
#define MFP_TCDCR_C_DELAY_4	0x10	/* delay mode, divide by 4 prescale */
#define MFP_TCDCR_C_DELAY_10	0x20	/* delay mode, divide by 10 prescale */
#define MFP_TCDCR_C_DELAY_16	0x30	/* delay mode, divide by 16 prescale */
#define MFP_TCDCR_C_DELAY_50	0x40	/* delay mode, divide by 50 prescale */
#define MFP_TCDCR_C_DELAY_64	0x50	/* delay mode, divide by 64 prescale */
#define MFP_TCDCR_C_DELAY_100	0x60	/* delay mode, divide by 100 prescale */
#define MFP_TCDCR_C_DELAY_200	0x70	/* delay mode, divide by 200 prescale */

#endif	INCm68901h
