/* if_bp.c - backplane network header */

/*
modification history
--------------------
01b,06mar89,jcf  added read-location mailbox types.
01a,14jun87,dnw  written
*/

/* backplane interrupt methods */

#define BP_INT_NONE		0	/* no interrupt - poll instead */

#define BP_INT_MAILBOX_1	1	/* mailbox write byte to bus adrs */
#define BP_INT_MAILBOX_2	2	/* mailbox write word to bus adrs */
#define BP_INT_MAILBOX_4	3	/* mailbox write long to bus adrs */
					/*    arg1 = bus address space
					 *    arg2 = bus address
					 *    arg3 = value
					 */

#define BP_INT_BUS		4	/* generate bus interrupt */
					/*    arg1 = interrupt level
					 *    arg2 = interrupt vector
					 */

#define BP_INT_MAILBOX_R1	5	/* mailbox read byte to bus adrs */
#define BP_INT_MAILBOX_R2	6	/* mailbox read word to bus adrs */
#define BP_INT_MAILBOX_R4	7	/* mailbox read long to bus adrs */
					/*    arg1 = bus address space
					 *    arg2 = bus address
					 *    arg3 = value
					 */
