/* sm.h - defines for Interphase SMD driver */

#define NSM	4		/* # controllers supported */
#define Nsm	(4*NSM)		/* # physical drives - 2 per controller */
#define Nsmrt	(8*Nsm)		/* # RT-11 devices - 8 per logical drive */

#define SMINTLEV	3
#define SM_RETRYCNT	5
#define SM_DEV_NAME	"/sm"
#define SM_SECTOR_SIZE	512	/* bytes per sector */
#define SM_MAX_ERRORS	8	/* retry count for interrupt code */

/* 
 * The following structures are similar to the UNIX structures, but the
 * SMD driver didn't follow the UNIX drivers exactly, so sm has it's own
 * structs. For this reason, sm also has it's own badinit and badstrat
 * routines. Maybe someday someone will re-write the SMD driver to use
 * the other structs.
 */

/*
 * Buffer structure used by smbadstrat
 */

struct sm_buf {
	UINT b_flags;			/* see defines below */
	UINT b_bcount;			/* transfer count */
	UINT b_dev;			/* CONT|TARG|LUN|PART */
	UINT b_addr;			/* buffer address */
	UINT b_blkno;			/* block # on device */
	UINT b_resid;			/* words not transferred after err */
}; 
	
/*
 * These flags are kept in b_flags.
 */
#define	B_WRITE		0x00000000	/* non-read pseudo-flag */
#define	B_READ		0x00000001	/* read when I/O occurs */
#define	B_DONE		0x00000002	/* transaction finished */
#define	B_ERROR		0x00000004	/* transaction aborted */
#define	B_BUSY		0x00000008	/* not on av_forw/back list */
#define	B_PHYS		0x00000010	/* physical IO */
#define	B_XXX		0x00000020	/* was B_MAP, alloc UNIBUS on pdp-11 */
#define	B_WANTED	0x00000040	/* issue wakeup when BUSY goes off */
#define	B_AGE		0x00000080	/* delayed write for correct aging */
#define	B_ASYNC		0x00000100	/* don't wait for I/O completion */
#define	B_DELWRI	0x00000200	/* write at exit of avail list */
#define	B_TAPE		0x00000400	/* this is a magtape (no bdwrite) */
#define	B_UAREA		0x00000800	/* add u-area to a swap operation */
#define	B_PAGET		0x00001000	/* page in/out of page table space */
#define	B_DIRTY		0x00002000	/* dirty page to be pushed out async */
#define	B_PGIN		0x00004000	/* pagein op, so swap() can count it */
#define	B_CACHE		0x00008000	/* did bread find us in the cache ? */
#define	B_INVAL		0x00010000	/* does not contain valid info  */
#define	B_LOCKED	0x00020000	/* locked in core (not reusable) */
#define	B_HEAD		0x00040000	/* a buffer header, not a buffer */
#define	B_BAD		0x00100000	/* bad block revectoring in progress */
#define	B_CALL		0x00200000	/* call b_iodone from iodone */
#define B_NOCACHE	0x00400000	/* don't cache block when released */
#define B_18BIT		0x00800000	/* ISI: buffer in 18bit space */
#define B_22BIT		0x01000000	/* ISI: buffer is beyond 18bit space */
#define B_EBLK		0x02000000	/* ISI: buffer available for geteblk */
#define B_VDMA		0x04000000	/* ISI: buffer has VDMA resources */
#define B_FLAGS_BITS \
"\20\33VDMA\32EBK\31B22\30B18\27NOCA\26CAL\25BAD\23HD\22LKD\21IVL\20CA\
\17PIN\16DT\15PT\14UA\13TP\12DWR\11ASY\10AGE\7WAN\6XX\5PH\4BY\3ER\2DN\1RD"

/*
 * sm_diskst structure describes the geometry and partition sizes for a disk.
 */

struct sm_diskst {
	USHORT st_ncpd;			/* num cylinders per drive */
	USHORT st_nspt;			/* num sectors per track */
	USHORT st_ntpc;			/* num tracks per cylinder */
	USHORT st_nspc;			/* num sectors per cylinder */
	short st_spare1;		/* num bytes per sector */
	short st_spare2;
	struct diskst_psize {
		int nblocks;		/* size of partition in blocks */
		int cyloff;		/* start cylinder for partition */
	}	st_size[8];
};
		
#define ST_ncpd		(st->st_ncpd)
#define ST_nspt		(st->st_nspt)
#define ST_ntpc		(st->st_ntpc)
#define ST_nspc		(st->st_nspc)
#define ST_spare1	(st->st_spare1)
#define ST_spare2	(st->st_spare2)

/*
 * Per-device structure
 */

#define DEV_NAME_SIZE	8

struct sm_device {
	RT_VOL_DESC     rtvol;		/* rt volume descriptor struct */
	char		name[DEV_NAME_SIZE]; /* name of device - for badstrat */
	char            ctlr;		/* controller number */
	char            drive;		/* drive number */
	char		partition;	/* partition num for this device */
	int 		blk_size; 	/* block size in bytes */
	unsigned int	dev;		/* CONT|TARG|LUN|PART */
};

/*
 * Per-drive structure
 */

struct sm_drive {
	char            	here;	/* BOOLEAN - drive exists or not */
	struct sm_diskst 	diskst;	/* disk geometry struct */
	struct dkbad 		bad;	/* bad sector map for disk */
};

/*
 * Per-controller structure
 */

struct sm_ctlr {
	SEMAPHORE       ctlr_sem;	/* control of controller sem */
	SEMAPHORE       intr_sem;	/* wait for interrupt complete sem */
	UTINY           errcnt;		/* retry count for interrupt code */
	char            status;		/* interrupt code status */
};

