/* dbxLib.h - header file for Sun's dbxTool interface */

/*
modification history
--------------------
01b,11feb88,rdc  added EVENT_SUSPEND.
01a,18sep87,rdc  written.
*/

#ifndef INCdbxLibh
#define INCdbxLibh	1

#include "lstLib.h"

typedef enum
    {
    EVENT_BREAK,
    EVENT_STOP,
    EVENT_EXIT,
    EVENT_BUS_ERR,
    EVENT_SUSPEND,	/* used for control c interrupt */
    EVENT_ZERO_DIV, 	/* etc */
    EVENT_SIGNAL	/* used to report a signal */
    } EVENT_TYPE;

typedef struct 
    {
    NODE ptraceEventNode;
    int taskId;
    EVENT_TYPE eventType;
    int sigType;        /* holds signal number if eventType is EVENT_SIGNAL */
    } PTRACE_EVENT;

#endif INCdbxLibh
