/* romInit.s - init module for code in rom for MICROBAR DBC68K2 */

/*
modification history
--------------------
01a,15dec87,gae  ripped off from hkv2f version.
	   +jcf  further destruction.
*/

/*
DESCRIPTION
The Microbar DBC68k2 does not have enough PROM space for VxWorks Boot PROMS.
However, the existing PROM can bootstrap this program if it exists on a
device it knows about, viz. floppy or hard disk.
*/

#define ASMLANGUAGE
#include "vxWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_romInit	/* start of system code */

	/* externals */

	.globl	_usrInit	/* system initialization routine */

	.text
	.even

_romInit:
	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit1	/* initial start in rom */

	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit2	/* subsequent starts in rom */

/*******************************************************************************
*
* romInit1 -
*
* Set stack, go to usrInit.
* This routine is position independent.

* romInit1 ()

*/

romInit1:
	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	#BOOT_COLD,a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */

/*******************************************************************************
*
* romInit2 -
*
* Same as romInit; basically unused.
* This routine is position independent.

* romInit2 ()

*/

romInit2:
	link	a6,#0		/* no unlk necessary; we change stacks */

	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	a6@(0x08),a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */

