/* sun3e/config.h - Sun-3/E configuration header */

/*
modification history
--------------------
02d,03apr88,jcf  fixed IO_ADRS_IE.
02c,29oct88,gae  added BOOTROM option for selecting either bp or ie device,
	   +jcf  and getting bootline done correctly; fixed enp address.
02b,30may88,ak   include sun 3 network driver, instead of ex!!
02a,29apr88,gae  relocated bulk to configAll.h.
01f,27apr88,ecs  added EXC_MSG_ADRS.
01e,19apr88,llk  includes RPC and DBX.
01d,20nov87,dnw  changed definitions to new naming conventions.
01c,13nov87,dnw  added new backplane parameters (BP_ANCHOR, etc).
01b,06nov87,rdc  added ethernet address constant
01a,28may87,jcf  created
*/

/*
This file contains the parameters that define the configuration
for VxWorks on the Sun-3/E.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "configAll.h"
#include "sun3e.h"

#undef   INCLUDE_EX	/* untested */

#define	BOOTROM	FALSE	/* TRUE = make boot line work correctly */

#if	BOOTROM
#define DEFAULT_BOOT_LINE \
"bp(0,1)host:/usr/vw/config/sun3e/vxWorks h=50.0.0.50 b=50.0.0.1 u=target"
#else
#undef	INCLUDE_ENP
#define	INCLUDE_IE
#define DEFAULT_BOOT_LINE \
"ie(0,0)host:/usr/vw/config/sun3e/vxWorks h=90.0.0.3 e=90.0.0.50 u=target"

#undef  BOOT_LINE_ADRS /* address where the boot ROMs put the boot line */
#define BOOT_LINE_ADRS          DEFAULT_BOOT_LINE
#endif	BOOTROM
 
#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */

#define IE_ENET_ADDR	{0x08, 0x00, 0x14, 0x20, 0x01, 0x90}

/* Device controller I/O addresses: default addresses are unsuitable */

/* WARNING: only the IE and ENP devices have been tested */

#undef	IO_ADRS_EX
#define IO_ADRS_EX	((char *) 0x13f0000)	/* 24A,32D Excelan Ethernet */
#undef	IO_ADRS_ENP
#define IO_ADRS_ENP	((char *) 0x19e0000)	/* 24A,32D CMC Ethernet */
#undef	IO_ADRS_IE
#define IO_ADRS_IE	((char *) 0x0f00000)	/* 24A,32D Sun Ethernet */
#undef	IO_ADRS_NW
#define IO_ADRS_NW	((char *) 0x13f0000)	/* 24A,32D ISI Ethernet */
#undef	IO_ADRS_PN
#define IO_ADRS_PN	((char *) 0x0d00000)	/* 24A,32D Proteon ProNet */


/* interrupt and system trap vectors */

#undef	VEC_BASE_ADRS
#define VEC_BASE_ADRS		((char *) 0x0fe60c00)

#define INT_VEC_CLOCK		(IVEC_TO_INUM (IV_AUTOVEC_5))
#define INT_VEC_DUART		(IVEC_TO_INUM (IV_AUTOVEC_6))	/* Z8530 DUART*/

#define TRAP_SUN		3	/* trap 3 - sun trap */


/* backplane network parameters */

#define BP_ANCHOR_ADRS	((char *) (0x01400000))	/* bp anchor adrs (8M) */

#define BP_INT_TYPE	BP_INT_NONE		/* no bp interrupt, polls */
#define BP_INT_ARG1	0			/* unused */
#define BP_INT_ARG2	0			/* unused */
#define BP_INT_ARG3	0			/* unused */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#undef	BP_TAS
#define	BP_TAS		FALSE
#define BP_MEM_ADRS	BP_ANCHOR_ADRS		/* bp shared mem adrs */
#define BP_MEM_SIZE	0x00080000		/* 512k */


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the SUN 3/E local memory address is determined by the memory mapping
 * (currently always set to 0);
 * its address on the bus is always 0 when it is dual ported.
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* set by mem map */
#define LOCAL_MEM_BUS_ADRS	0		/* fixed */

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS		0x00300000

/* The following is the address where the boot roms put the boot line */

#endif	INCconfigh
