/* mz8115/config.h - Mizar mz8115 configuration header */

/* Copyright 1988, Mizar Digital Systems, Inc. */

/*
modification history
--------------------
01d,24may89,gae  ifdef'd out INCLUDE_RPC for HALF_MEG.
01c,11aug88,gae  updated to 4.0.
01b,11may88,miz  cleanup.
01a,10feb88,miz  written by modifying v01a of mz7120/config.h.
*/

/*
This module contains the parameters that define the configuration for
VxWorks on the Mizar 8115 cpu board.   The CPU card configuration supported
is 68010 CPU, using the on-card RS232 ports, booting over the network
as per the DEFAULT_BOOT_LINE below.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "configAll.h"
#include "mz8115.h"

#undef	INCLUDE_SPY		/* can't use - no auxiliary clock */

#define	HALF_MEG	TRUE	/* if board has only .5 M */
#if	HALF_MEG
/* if only .5 Meg is available the following modules should be excluded. */
#undef	INCLUDE_DBX
#undef	INCLUDE_NFS
#undef	INCLUDE_RPC
#undef	INCLUDE_TELNET
#undef	INCLUDE_RT11
#undef	INCLUDE_RAMDRV
#endif	HALFMEG

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */


#define	WHICH	0	/* 0=WRS, 1=MIZAR, 2=MIZARBP */

#if	WHICH == 0
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/mz8115/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"
#endif	WHICH_WRS

#if	WHICH == 1
#define DEFAULT_BOOT_LINE \
"enp(0,0)mizar:/usr/vw/config/mz8115/vxWorks e=192.33.35.215 h=192.33.35.10 b=215.1 u=vw"
#endif	WHICH_MIZAR

#if	WHICH == 2
#define DEFAULT_BOOT_LINE \
"bp(0,1)mizar:/usr/vw/config/mz8115/vxWorks b=215.2 h=192.33.35.10 g=215.1 u=vw"
#endif	WHICH_MIZARBP

/* Device controller I/O addresses:
 * MZ8115 board requires the top bits 0xff000000 to be set.
 * Also, the Excelan cannot appear at 0x00ff0000.
 */
 
#undef  IO_ADRS_EX
#define IO_ADRS_EX      ((char *) 0xff7f0000)   /* 24A,32D Excelan Ethernet */
#undef  IO_ADRS_ENP
#define IO_ADRS_ENP     ((char *) 0xffde0000)   /* 24A,32D CMC Ethernet */
#undef  IO_ADRS_IE
#define IO_ADRS_IE      ((char *) 0xff300000)   /* 24A,32D Sun Ethernet */
#undef  IO_ADRS_NW
#define IO_ADRS_NW      ((char *) 0xfff80000)   /* 24A,32D ISI Ethernet */
#undef  IO_ADRS_PN
#define IO_ADRS_PN      ((char *) 0xff100000)   /* 24A,32D Proteon ProNet */


/* interrupt and system trap vectors */

#define INT_VEC_ABORT		(IV_AUTOVEC_7)
#define INT_VEC_S1_IRQ1		(IV_AUTOVEC_6)
#define INT_VEC_BCLR		(IV_AUTOVEC_5)
#define INT_VEC_S1_IRQ2		(IV_AUTOVEC_4)
#define	INT_VEC_SERIAL		(MZ8115_INT_VEC_NUM + IV_OFFSET_68681)


/* backplane network parameters */

#define BP_ANCHOR_ADRS	((char *) (0xff800000))	/* off-board anchor adrs */

#define BP_INT_TYPE	BP_INT_NONE		/* mailbox interrupt, poll */
#define BP_INT_ARG1	0			/* none */
#define BP_INT_ARG2	0			/* none */
#define BP_INT_ARG3	0			/* none */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x40000		/* 256K */


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The mz8115 local memory always appears at 0x00000000 locally.
 * The mz8115 local memory VMEbus address is controlled by PAL
 * 271000 at U10; in the default configuration it is 0x00e80000.
 * Multiple 8115s on a backplane will need different PALs to
 * avoid VMEbus conflicts; see the target(5) man page for
 * further information.
 */

#define LOCAL_MEM_LOCAL_ADRS	MZ_RAM_BASE_ADRS
#define LOCAL_MEM_SIZE		MZ_RAM_SIZE
#define LOCAL_MEM_BUS_ADRS	0x00e80000

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS		0x00f80000

#endif	INCconfigh
