/* mv147/config.h - Motorola MVME-147 configuration header */

/*
modification history
--------------------
01b,10aug88,gae  added onboard BP support.
01a,08aug88,dfm  derived from mv133/config.h.
	  +rdc  
*/

/*
This module contains the parameters that define the configuration
for the MVME-147.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "configAll.h"
#include "mv147.h"

#define NV_RAM_SIZE	NV_BOOT_LINE_SPACE	
#define SYS_CPU_FREQ    20000000        /* 20 MHz system clock */


#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */

#define DEFAULT_BOOT_LINE \
"ln(0,0)host:/usr/vw/config/mv147/vxWorks h=90.0.0.3 e=90.0.0.50 u=target"

#undef INCLUDE_NW
#undef INCLUDE_EX

#define INCLUDE_LN		/* include MVME-147 LANCE Ethernet interface */

#define IO_ADRS_LN ((char *) 0xfffe1800) /* 32A,32D MVME-147 LANCE Ethernet */ 

/* interrupt vectors */
#define INT_VEC_ACFAIL          (PCC_INT_VEC_BASE + PCC_INT_ACFAIL)
#define INT_VEC_BERR            (PCC_INT_VEC_BASE + PCC_INT_BERR)
#define INT_VEC_ABORT           (PCC_INT_VEC_BASE + PCC_INT_ABORT)
#define INT_VEC_SCSI            (PCC_INT_VEC_BASE + PCC_INT_SCSI)
#define INT_VEC_SCSI_DMA        (PCC_INT_VEC_BASE + PCC_INT_SCSI_DMA)
#define INT_VEC_LP              (PCC_INT_VEC_BASE + PCC_INT_PRINTER)
#define INT_VEC_CLOCK           (PCC_INT_VEC_BASE + PCC_INT_TIC_1)
#define INT_VEC_AUX_CLOCK       (PCC_INT_VEC_BASE + PCC_INT_TIC_2)
#define INT_VEC_LN              (PCC_INT_VEC_BASE + PCC_INT_LANCE)
					/* MVME147 LANCE Ethernet controller */
					 
#define INT_LVL_LP              1       /* printer interface */
#define INT_LVL_TIC_1           6       /* system clock is tic 1 */
#define INT_LVL_TIC_2           5       /* aux clock is tic 2 */
#define INT_LVL_TY              4       /* tyCoDrv interface (4 serial lines)*/ 
#define INT_LVL_LN              3       /* MVME147 LANCE Ethernet controller */

/* backplane network parameters */

#define	BP_OFF_BOARD	FALSE

#if	BP_OFF_BOARD
#define BP_ANCHOR_ADRS  ((char *) (0x00800000))   /* bp anchor adrs */
#else
#define	BP_ANCHOR_ADRS  ((char *) (0x00000600))   /* bp anchor adrs */
#endif	BP_OFF_BOARD
 
#define BP_INT_TYPE     BP_INT_MAILBOX_1        /* (signal hp) interrupt */
#define BP_INT_ARG1     VME_AM_SUP_SHORT_IO     /* bus address space */
#define BP_INT_ARG2     ((sysProcNum << 4) + 3) /* bus adrs */
#define BP_INT_ARG3     2                       /* value (SIGHP bit */
  
/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */
    
#if	BP_OFF_BOARD
#define BP_MEM_ADRS     BP_ANCHOR_ADRS	/* bp shared mem adrs */
#define BP_MEM_SIZE     0x80000		/* 512k */
#else
#define BP_MEM_ADRS     NONE          	/* NONE = allocate from memory */
#define BP_MEM_SIZE     0x10000		/* 64k */
#endif	BP_OFF_BOARD
     

/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the MVME-147 local memory address always appears at 0 locally;
 * its address on the bus is set by the RAM_BASE register in the PCC.
 */
     
#define LOCAL_MEM_LOCAL_ADRS    0               /* fixed */
#define LOCAL_MEM_SIZE          (0x400000)	/* 4 MBytes */
#define LOCAL_MEM_BUS_ADRS      (2*LOCAL_MEM_SIZE) /* only for processor 0 */
				     /* must be multiple of memory size */

#define NV_BOOT_LINE            ((char *) (BBRAM + 0x100))
#define NV_BOOT_LINE_SPACE      (0x100)         /* reserve 256 bytes in BBRAM */

/* Base address of the on-board rom */

#define ROM_BASE_ADRS           0xff800000                          

#endif	INCconfigh
