/* pic_cpu.c - MV133, MV133A, MV133XT & MV134 jumpering */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01g,25oct88,ecs  bug fix in MV133A interrupt block.
01f,29jul88,gae  added EPROM locations.
01e,25jun88,gae  added interactive flag to drawBoard().
01d,04apr88,gae  removed printPic() call.  Added real MV133XT draw routine.
		 added watchdog and bus error jumpers.  Fixed bug in VME addr.
01c,16mar88,gae  merged with MV133A & MV134.
		 renamed from pic_mv133.c for new jump.
01b,05feb88,jcf  bug fix in interrupt block.
01a,07nov87,jcf  created
*/

/*
This module contains the jumpering of the MV133, MV133A, MV133XT & MV134.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "vxWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw cpu jumper config
*/

VOID drawBoard (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    char input[90];
    int n = NONE;

    if (interactive)
	{
	printf ("Which CPU (0=MV133, 1=MV133A, 2=MV133XT, 3=MV134) ?");

	gets (input);

	sscanf (input, "%d", &n);

	switch (n)
	    {
	    case 0:
		drawMv133 (pic);
		break;
	    case 1:
		drawMv133a (pic);
		break;
	    case 2:
		drawMv134 (pic, TRUE);
		break;
	    case 3:
		drawMv134 (pic, FALSE);
		break;
	    default:
		return;
	    }
	}
    else
	{
	/* XXX really need to draw them all */
	drawMv134 (pic, TRUE);
	}
    }
/*******************************************************************************
*
* drawMv133 - draw cpu jumper config for MV133
*/

LOCAL VOID drawMv133 (pic)
    char *pic;

    {
    int int_lvl = 0;
    int id_num = ~(low_byte_bus >> 20);

    printAt (pic, 36, 1, "MV133");

    /* Draw PROMS */

    printAt (pic, 15, 14, " --v--   --v--   --v--   --v-- ");
    printAt (pic, 15, 15, "|     | | ROM | |     | | ROM |");
    printAt (pic, 15, 16, "|     | | U31 | |     | | U46 |");
    printAt (pic, 15, 17, "|     | |     | |     | |     |");
    printAt (pic, 15, 18, "|     | | ODD | |     | | EVEN|");
    printAt (pic, 15, 19, "|_____| |_____| |_____| |_____|");

    jumperAt (pic, 3, 3, 4, HORIZONTAL, VERTICAL, id_num);
    printAt (pic, 9, 3, "IO");

    /* int level */
    int_lvl |= (inc_ex)  ? (0x40 >> (il_ex - 1))  : 0;
    int_lvl |= (inc_enp) ? (0x40 >> (il_enp - 1)) : 0;
    int_lvl |= (inc_ie)  ? (0x40 >> (il_ie - 1))  : 0;
    int_lvl |= (inc_nw)  ? (0x40 >> (il_nw - 1))  : 0;
    int_lvl |= (inc_pn)  ? (0x40 >> (il_pn - 1))  : 0;
    jumperAt (pic, 32, 3, 1, HORIZONTAL, VERTICAL, 0x1);
    jumperAt (pic, 34, 3, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 34, 4, "INT");

    /* MISC */
    jumperAt (pic, 3, 4, 1, HORIZONTAL, HORIZONTAL, 0x1);
    printAt  (pic, 3, 5, "SCON");
    }
/*******************************************************************************
*
* drawMv133a - draw cpu jumper config for MV133A
*/

LOCAL VOID drawMv133a (pic)
    char *pic;

    {
    int int_lvl = 0;
    int id_num = ~(low_byte_bus >> 20);

    printAt (pic, 36, 1, "MV133A");

    /* Draw PROMS */

    printAt (pic, 15, 14, " --v--   --v--   --v--   --v-- ");
    printAt (pic, 15, 15, "|     | | ROM | |     | | ROM |");
    printAt (pic, 15, 16, "|     | | U31 | |     | | U46 |");
    printAt (pic, 15, 17, "|     | |     | |     | |     |");
    printAt (pic, 15, 18, "|     | | ODD | |     | | EVEN|");
    printAt (pic, 15, 19, "|_____| |_____| |_____| |_____|");

    jumperAt (pic, 3, 3, 4, HORIZONTAL, VERTICAL, id_num);
    printAt (pic, 9, 3, "IO");

    /* int level */
    int_lvl |= (inc_ex)  ? (0x40 >> (il_ex - 1))  : 0;
    int_lvl |= (inc_enp) ? (0x40 >> (il_enp - 1)) : 0;
    int_lvl |= (inc_ie)  ? (0x40 >> (il_ie - 1))  : 0;
    int_lvl |= (inc_nw)  ? (0x40 >> (il_nw - 1))  : 0;
    int_lvl |= (inc_pn)  ? (0x40 >> (il_pn - 1))  : 0;
    jumperAt (pic, 32, 3, 1, HORIZONTAL, VERTICAL, 0x1);
    jumperAt (pic, 33, 3, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 34, 4, "INT");

    /* MISC */
    jumperAt (pic, 3, 4, 1, HORIZONTAL, HORIZONTAL, 0x1);
    printAt  (pic, 3, 5, "SCON");
    }
/*******************************************************************************
*
* drawMv134 - draw cpu jumper config for MV134 or MV133xt
*/

LOCAL VOID drawMv134 (pic, xt)
    char *pic;
    BOOL xt;	/* is an xt */

    {
    char buff[15];
    int i;
    int x;
    int int_lvl = 0;
    int id_num = 0;
		    /* memory can only be on 400000 boundary */
    int round_addr = LOCAL_MEM_BUS_ADRS & 0xfc00000;
    int tmp = ~(round_addr >> 22);

    printAt (pic, 36, 1, xt ? "MV133XT" : "MV134");
    
    /* Draw PROMS */

    printAt (pic, 5, 14, " --v--   --v--   --v--   --v-- ");
    printAt (pic, 5, 15, "|     | | ROM | |     | | ROM |");
    printAt (pic, 5, 16, "|     | | U12 | |     | | U31 |");
    printAt (pic, 5, 17, "|     | |     | |     | |     |");
    printAt (pic, 5, 18, "|     | | ODD | |     | | EVEN|");
    printAt (pic, 5, 19, "|_____| |_____| |_____| |_____|");

    for (i = 0; i < 6; i++)	/* mirror image the 6 bits  */
	id_num |= ((1 & (tmp >> i)) << (5-i));

    jumperAt (pic, 41, 3, 6, HORIZONTAL, VERTICAL, id_num);
    printAt (pic, 41, 4, xt ? "J15:VME ADDR" : "J16:VME ADDR");
    sprintf (buff," = %x", round_addr);
    printAt (pic, 41, 5, buff);

    /* int level */
    int_lvl |= (inc_ex) ? (1 << (il_ex - 1)) : 0;
    int_lvl |= (inc_enp) ?(1 << (il_enp - 1)) : 0;
    int_lvl |= (inc_ie) ? (1 << (il_ie - 1)) : 0;
    int_lvl |= (inc_nw) ? (1 << (il_nw - 1)) : 0;
    int_lvl |= (inc_pn) ? (1 << (il_pn - 1)) : 0;

    x = 31;
    for (i = 0; i < 7; i++)
	printAt (pic, x++, 3, ((int_lvl >> i) & 1) ? "U" : "D");
    
    printAt (pic, 29, 4, "J13:INT LVL");

    /* watchdog reset */
    jumperAt (pic, 10, 21, 1, HORIZONTAL, HORIZONTAL, 0x0);
    printAt  (pic, 12, 21, "J2:WATCHDOG");

    /* bus error interrupt */
    jumperAt (pic, 50, 21, 1, VERTICAL, VERTICAL, 0x0);
    printAt  (pic, 52, 21, xt ? "J16: BUS ERROR" : "J19:BUS ERROR");

    /* MISC */
    jumperAt (pic, 14, 8, 1, HORIZONTAL, HORIZONTAL, 0x1);
    printAt  (pic, 16, 8, "J4:SYS CNTRLR");
    }
