/* mv131/config.h - Motorola MVME-131 configuration header */

/*
modification history
--------------------
02a,29apr88,gae  relocated bulk to configAll.h.
01f,27apr88,ecs  added EXC_MSG_ADRS.
01e,19apr88,llk  includes RPC and DBX.
01d,20nov87,dnw  changed definitions to new naming conventions.
01c,13nov87,dnw  added new backplane parameters (BP_ANCHOR, etc).
01b,02nov87,jcf  cleaned up
01a,05may87,dnw  created
*/

/*
This file contains the parameters that define the configuration
for the Motorola MVME-131.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "configAll.h"
#include "mv131.h"


#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/mv131/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"


/* Device controller I/O addresses: standard */

/* interrupt vectors */

#define INT_VEC_CLOCK		66	/* timer interrupt */

#define INT_VEC_BP		255	/* backplane interrupt */

#define INT_LVL_BP		5	/* backplane ints start at 4 */


/* backplane network parameters */

#define BP_ANCHOR_ADRS	((char *) (0x800000))	/* bp anchor adrs */

#define BP_INT_TYPE	BP_INT_NONE		/* no bp interrupt */
/* XXX #define BP_INT_TYPE	BP_INT_BUS		/* bus interrupt */
#define BP_INT_ARG1	(INT_LVL_BP - sysProcNum)	/* int level */
#define BP_INT_ARG2	INT_VEC_BP		/* int vector */
#define BP_INT_ARG3	0			/* unused */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#define BP_MEM_ADRS	BP_ANCHOR_ADRS		/* bp shared mem adrs */
#define BP_MEM_SIZE	0x80000			/* 512k */


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the mv131 local memory address local and on the bus are both set by jumpers.
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* jumpers */
#define LOCAL_MEM_BUS_ADRS	0		/* jumpers */

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS		0xfff00000

#endif	INCconfigh
