/* sysALib.s - Matrix MS-CPU100 system dependent assembly language routines */

/* Copyright 1988, Wind River Systems, Inc. */

/*
modification history
--------------------
01b,28sep88,gae  documentation touchup.
01a,17aug88,dmp  written by modifying v01i of hkv2f version.
*/

/*
DESCRIPTION
This module contains system-dependent routines which must be written
in assembly language.  They perform functions such as locking and
unlocking interrupts, trapping to the ROM monitor, etc.

The first routine in this module is the system start-up code.
It is the first code executed after booting.

This module MUST be the first specified on the "ld" command that is used
to build the system.  sysInit is the entry point for VxWorks.

INTERNAL
Many routines in this module "link" and "unlk" the "c" frame pointer
a6@ although they don't use it in any way!  This is only for the benefit of
the stacktrace facility to allow it to properly trace tasks executing within
these routines.
*/

#define ASMLANGUAGE
#include "vxWorks.h"
#include "ms100.h"
#include "sysLib.h"
#include "config.h"

    /* internals */

    .globl  _sysInit		/* start of system code */
    .globl  _sysKernelTrap
    .globl  _sysVwTrap
    .globl  _sysVwTrapRtn
    .globl  _sysAbortIntA         
    .globl  _sysAdjustDualPort
  
    /* externals */

    .globl    _usrInit               /* system initialization routine */
    .globl    _sysToMonitor          /* exit to monitor */

    .text
    .even

/*******************************************************************************
*
* sysInit - start after boot
*
* This is the system start-up entry point for VxWorks in ram.
* It is the first code executed after booting.
* It disables the interrupts, sets up the stack,
* and jumps to the C routine usrInit in usrConfig.c.
*
* The initial stack is set to grow down from sysInit.
* Note that this initial stack is used only by usrInit,
* then is never used again.
* Memory for the stack needs to be accounted for when determining the load
* address of the system.  THIS IS NOT A CALLABLE ROUTINE.

* sysInit ()        /* THIS IS NOT A CALLABLE ROUTINE *

*/

_sysInit:
    movew    #0x3700,sr        /* disable interrupts, turn on M bit */
    movel    #_sysInit,a7        /* set stack to grow down from code */
    movel    #BOOT_WARM_AUTOBOOT,a7@- /* push start type arg = WARM_BOOT */
    jsr    _usrInit        /* never returns - starts up kernel */

/*******************************************************************************
*
* sysKernelTrap - trap to kernel function
*
* This routine traps to the kernel.
* It can only be called from assembly language.
* The trap number for the kernel is defined in config.h.
*
* NOMANUAL

* sysKernelTrap ()

*/
_sysKernelTrap:
    trap    #TRAP_KERNEL
    rts

/*******************************************************************************
*
* sysVwTrap - trap to vxWorks function
*
* This routine traps to VxWorks.
* It can only be called from assembly language.
* The trap number for VxWorks is defined in config.h.
*
* NOMANUAL

* sysVwTrap ()

*/

_sysVwTrap:
    trap    #TRAP_VXWORKS
    rts

/*
 * This routine calls the routine whose address is in a0.  Since the system
 * is now in supervisor state (since we got here from a trap) this can be
 * used to call a routine in supervisor state.
 * THIS IS NOT A C CALLABLE ROUTINE!!
 */

_sysVwTrapRtn:
    jsr    a0@        /* vector to proper routine. */
    rte            /* return from trap */

/*******************************************************************************
*
* sysAbortIntA - handle abort switch interrupt 
*
* This routine returns to VxWorks boot monitor on abort interrupt

* VOID sysAbortIntA ()

*/

_sysAbortIntA:
    jsr    _sysToMonitor        /* go to monitor land */

/*******************************************************************************
*
* sysAdjustDualPort - adjust dual port memory to allow VME access
*
* This routine set the VME bus access to memory to 0x100000.

* VOID sysAdjustDualPort ()

*/


_sysAdjustDualPort:
    link    a6,#0
    movb #0x80,0xfe401b            /* issue a bus-request and hold command */
loop1: 
    movb 0xfe4017,d0               /* read the bcsr */ 
    andb #0x80,d0
    beq   loop1                    /* wait until your master */ 

    movb #0x10,0xfe001d            /* clear the first data-out bit */
    movb #0x40,0xfe001d            /* toggle the vmd shift clock */
    movb #0x40,0xfe001f
    movb #0x00,0xfe401b            /* clear the bus-request & hold command */
    movb #0x06,d0
vmdcl: 
    movb #0x10,0xfe001d            /* set the next data-out bit */
    movb #0x40,0xfe001d            /* toggle the vmd shift clock */
    movb #0x40,0xfe001f
    tstb d0
    dbeq d0,vmdcl
    movb #0x07,d0                  /* begin loading in the adjusted address */
    movb #0x8b,d1                  /* $8b=1Mbyte starting @ $100000 */
loop3:                             /* $89=512kbyte starting $100000 */
    movb  d1,d2
    andb  #0x1,d2                  /* mask off all but the data-out bit */
    beq   clear
    movb #0x10,0xfe001f            /* bit is a 1 so set data-out */
    bra   cont     
clear: 
    movb #0x10,0xfe001d            /* bit is a 0 so clear data-out */
cont:  
    movb #0x40,0xfe001d            /* toggle vmd shift clock to enter data */
    movb #0x40,0xfe001f
    rorb #1,d1                     /* next bit please */
    dbeq d0,loop3
    unlk    a6
    rts

