/* pic_cpu.c - Matrix MS-CPU100 jumpering */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01c,23may89,dab  fixed bad bootrom and jumper positioning.
01b,21nov88,jcf  fixed bad jumper labeling.
01a,21sep88,gae  written.
*/

/*
This module contains the jumpering of the Matrix MS-CPU100.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "vxWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw cpu jumper config
*
* ARGSUSED1
*/

VOID drawBoard (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    int ix;

    /* chop-off P2 bus ...*/

    for (ix = 0; ix <= 22; ix++)
      printAt (pic, 34, ix, "                                            ");

    for (ix = 3; ix <= 22; ix++)
	printAt (pic, 34, ix, "|");

    printAt (pic, 33, 1, "MS-CPU100");

    /* SYSCON */
    printAt (pic, 3, 2, "XX  J6 SYSCON ");
    printAt (pic, 20, 3, "SYSCON J4 X");

    printAt (pic, 15,  7, " -------  ------- ");
    printAt (pic, 15,  8, "|  ROM  ||  ROM  |");
    printAt (pic, 15,  9, "|       ||       |");
    printAt (pic, 15, 10, "|  U23  ||  U22  |");
    printAt (pic, 15, 11, "|       ||       |");
    printAt (pic, 15, 12, "|  EVEN ||  ODD  |");
    printAt (pic, 15, 13, " ---^---  ---^--- ");

    /* EPROM size */
    printAt (pic, 30, 17, "XX");
    printAt (pic, 30, 18, ".X");
    printAt (pic, 30, 19, "X.");
    printAt (pic, 19, 20, "EPROM SIZE J2");
    }
