/* romInit.s - Ironics IV-1624A initialization module */

/*
modification history
--------------------
01c,13jul88,gae  fixed name to IV-1624A.  Documentation.
01b,19nov87,dnw changed to use ROM_BASE_ADRS & LOCAL_MEM_LOCAL_ADRS in config.h.
01a,18sep87,dnw  written
*/

#define ASMLANGUAGE
#include "vxWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_romInit	/* start of system code */

	/* externals */

	.globl	_usrInit	/* system initialization routine */


	.text
	.even

/*******************************************************************************
*
* romInit - initial entry points
*
* Cold start starts at romInit which will go to romInit1.
* Warm start starts at romInit + 16 which will go to romInit2.

* NOMANUAL

*/

_romInit:
	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit1	/* initial start in rom */

	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit2	/* subsequent starts in rom */

/*******************************************************************************
*
* romInit1 -
*
* clear all memory, copy rom to ram, set stack, go to usrInit
*
* This code is the cold start initialization.
* Copies the data segment from rom to ram, sets the stack to grow
* down from the start of the data segment in ram, and goes to usrInit with
* the arg BOOT_COLD.
*
* This routine is position independent.

* romInit1 ()

*/

romInit1:

	/* clear all of memory;
	 * outer loop counter in d2 = 0x03 =
	 *
	 *   1M bytes to clear
	 *   ------------------  - 1
	 *   64K * 4               ^
	 *    ^    ^               |
	 *    |    |               for dbra at end of outer loop
	 *    |    bytes per inner loop
	 *    inner loops per outer loop
	 */

	movel	#0x03,d2		/* outer loop counter */
	movel	#LOCAL_MEM_LOCAL_ADRS,a0	/* get start of local memory */
	clrl	d0			/* value to fill */


fb1:	movel	#0xffff,d1		/* set to fill 64K */
fb2:	movel	d0,a0@+			/* move 4 bytes */
	dbra	d1,fb2			/* inner loop test */
	dbra	d2,fb1			/* outer loop test */

	movew	#0,0xf7e200		/* setup control word */

	/* copy system from rom to ram */

	movel	#_romInit,a0		/* where system should be in ram */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in rom */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop1:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbf	d1,loop1


	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	#BOOT_COLD,a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */

/*******************************************************************************
*
* romInit2 - warm start initialization
*
* This code is the warm start initialization. It enables the cache,
* copies the data segment from rom to ram, sets the stack to grow
* down from the start of the data segment in ram, and goes to usrInit with
* the arg that was passed to it.
*
* This routine is position independent.

* romInit2 ()

*/

romInit2:
	link	a6,#0		/* no unlk necessary; we change stacks */

	/* copy system from rom to ram */

	movel	#_romInit,a0		/* where system should be in ram */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in rom */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop2:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbf	d1,loop2


	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	a6@(0x08),a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */

