/* is20/config.h - Integrated Solutions VME68K20 configuration header */

/*
modification history
--------------------
02c,02oct88,gae  fixed boot line to use nw board.
02b,07jun88,gae  added define of INCLUDE_NW and undefined INCLUDE_EX.
02a,29apr88,gae  relocated bulk to configAll.h.
01m,27apr88,ecs  added EXC_MSG_ADRS.
01l,19apr88,llk  includes RPC and DBX.
01k,20nov87,dnw  changed definitions to new naming conventions.
01j,13nov87,dnw  added new backplane parameters (BP_ANCHOR, etc).
01i,01nov87,jcf  cleaned up by adding in information for other drivers
01h,09oct87,jlf  changed to use vb as default, instead of bp.
01g,05jun87,dnw  removed obsolete MAIL_BOX_SIZE, BP_POLL,
		   LOW_BYTE_{BUS,LOCAL}_ADRS definitions.
		 moved ISR_STACK_SIZE to usrConfig.h.
		 added CPU, BP_INT_TYPE, BP_INT_ARG[123].
		 added trap definitions.
		 added defines for optional floating point support.
01f,26mar87,rdc  additional constants for backplane network driver 
01e,26feb87,rdc  moved ISR_STACK_SIZE from usrConfig.c
01d,14feb87,dnw  added IL_EX, LOW_BYTE_{LOCAL,BUS}_ADRS
01c,20dec86,dnw  changed DEFAULT_BOOT_LINE
01b,04dec86,dnw  added DEFAULT_BOOT_LINE
01a,30nov86,dnw  created
*/

/*
This file contains the parameters that define the configuration
for the Integrated Solutions VME68K20.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "vme68k20.h"
#include "sysLib.h"

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"nw(0,0)host:/usr/vw/config/is20/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_CDB		/* CDB source debugger */
#define INCLUDE_DEBUG           /* native debugging */
#define INCLUDE_FLOATING_POINT  /* floating point I/O */
#define	INCLUDE_FORTRAN		/* NKR run time Fortran library */
#define INCLUDE_MC68881         /* MC68881/2 float point co-processor */
#define INCLUDE_NETWORK         /* network subsystem code */
#define INCLUDE_NET_INIT        /* network subsystem initialization */
#define INCLUDE_NET_SYM_TBL     /* load symbol table from network */
/*#define INCLUDE_NFS             /* nfs package */
#define INCLUDE_RAMDRV          /* ram disk driver */
#define INCLUDE_RLOGIN          /* remote login */
#define INCLUDE_RPC             /* rpc package */
#define INCLUDE_RT11            /* RT-11 file system */
#define INCLUDE_SHELL           /* interactive c-expression interpreter */
#define INCLUDE_SPY             /* spyLib for task monitoring */
#define INCLUDE_STDIO           /* standard I/O */
#define INCLUDE_TELNET          /* telnet-style remote login */
#define INCLUDE_TIMEX           /* timexLib for exec timing */

/* included hardware support */

#define	INCLUDE_CP		/* include ISI ICP8/16 interface */
#define	INCLUDE_DR		/* include Ikon DR-11W interface */
#define INCLUDE_ENP		/* include CMC Ethernet interface*/
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define	INCLUDE_SM		/* include Interphase 3200/4200 SMD interface */
#define	INCLUDE_TS		/* include ISI QIC2-X/TC-50 tape interface */
/*#define	INCLUDE_VB		/* include ISI VB driver */
#define INCLUDE_BP		/* include backplane net interface */


/* EXCLUDED facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_ADA		/* include Ada support */
#define INCLUDE_DBX             /* dbx package */
#define INCLUDE_STANDALONE_SYM_TBL      /* compiled-in symbol table */
#define INCLUDE_STARTUP_SCRIPT  /* execute start-up script */

#define INCLUDE_IE		/* include Sun Ethernet interface*/
#define INCLUDE_PN		/* include Proteon network interface*/
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE

/*
 * Default NFS parameters - constants may be changed here, variables
 * may be changed in usrConfig.c at the point where NFS is included.
 */

#ifdef	INCLUDE_NFS

#define NFS_USER_ID		2001	/* dummy nfs user id */
#define NFS_GROUP_ID		100	/* dummy nfs user group id */

#endif	INCLUDE_NFS

/******************************************************************************/
/*                                                                            */
/*                           BOARD CONFIGURATION                              */
/*                                                                            */
/******************************************************************************/

/* Device controller I/O addresses: only used if the devices are included. */

#define IO_ADRS_EX	((char *) 0x00ff0000)	/* 24A,32D Excelan Ethernet */
#define IO_ADRS_ENP	((char *) 0x00de0000)	/* 24A,32D CMC Ethernet */
#define IO_ADRS_IE	((char *) 0x00300000)	/* 24A,32D Sun 3e Ethernet */
#define IO_ADRS_NW	((char *) 0x00f80000)	/* 24A,32D ISI Ethernet */
#define IO_ADRS_PN	((char *) 0x00100000)	/* 24A,32D Proteon ProNet */

/* interrupt vectors */

#define INT_VEC_CONSOLE		IVEC_TO_INUM (IV_AUTOVEC_5)
#define INT_VEC_CLOCK		IVEC_TO_INUM (IV_AUTOVEC_6)

#define INT_VEC_BP	IVEC_TO_INUM (IV_AUTOVEC_4)	/* backplane int */

/*
 * Interrupt vectors: only used if the devices are included.
 */

#define INT_VEC_ENP		192	/* CMC Ethernet controller*/
#define INT_VEC_EX		193	/* Excelan Ethernet controller*/
#define INT_VEC_IE		194	/* Sun Ethernet controller*/
#define INT_VEC_NW		195	/* ISI Ethernet controller*/
#define INT_VEC_PN		196	/* Proteon Ethernet controller*/

/*
 * Interrupt levels: only used if the devices are included.
 */

#define INT_LVL_ENP		3	/* CMC Ethernet controller */
#define INT_LVL_EX		2	/* Excelan Ethernet controller */
#define INT_LVL_IE		3	/* Sun 3e Ethernet controller */
#define INT_LVL_NW		3	/* ISI Ethernet controller */
#define INT_LVL_PN		1	/* Proteon ProNet controller */

/* backplane network parameters */

/*
 * Mailbox interrupt addresses:
 * processor #:       VME short I/O address:
 *     0                   0xc000
 *     1                   0xc002
 *     2                   0xc004
 *     3                   0xc006
 */

#define BP_ANCHOR_ADRS	((char *) (0xf00000))		/* bp anchor adrs */

#define BP_INT_TYPE	BP_INT_MAILBOX_2		/* mailbox interrupt */
#define BP_INT_ARG1	VME_AM_SUP_SHORT_IO		/* bus address space */
#define BP_INT_ARG2	(0xC000 | (sysProcNum << 1))	/* bus adrs */
#define BP_INT_ARG3	0				/* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#define BP_MEM_ADRS	BP_ANCHOR_ADRS		/* bp shared mem adrs */
#define BP_MEM_SIZE	0x80000			/* 512k */

/* Backplane parameter */
#define	BP_TAS	TRUE		/* hardware supports test-and-set */

/* The ISI VME-68k20 can also be used with ISI vb driver */

#define VB_SHARED_MEM	0x00f00000		/* vb backplane shared memory */
#define VB_SHMEM_SIZE   0x40000                 /* default 256k */

/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the VME-68k20 local memory always appears at 0 locally and
 * at 0 on the bus when dual ported.
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* fixed */
#define LOCAL_MEM_BUS_ADRS	0		/* fixed */

/* The following address is the base address of the on-board rom. */

#define ROM_BASE_ADRS           0x54000000

/* VME Address space offsets: CPU-->BUS mapping */

#define VME_SHORTIO     0x00FD0000
#define VME_STANDARD    0x00000000
#define VME_EXTENDED    0x00000000
#define VME_WINDOW_STD  0
#define VME_WINDOW_EXT  0

#endif	INCconfigh
