/* romInit.s - init module for code in ROM for Heurikon HK68/V20,V2F,V2FA */

/*
modification history
--------------------
01e,04may89,dnw+rml  moved all BCL code to sysLib.c
01d,22jun88,dnw  added clearing of BCL to compensate for sysHwInit not clearing
		   system controller bit.
01c,19nov87,dnw  changed to use ROM_BASE_ADRS & LOCAL_MEM_LOCAL_ADRS in config.h
01b,16nov87,jcf	 romInit2 now takes an argument from sysToMonitor
01a,18sep87,dnw  written
*/

#define ASMLANGUAGE
#include "vxWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_romInit	/* start of system code */

	/* externals */

	.globl	_usrInit	/* system initialization routine */


	.text
	.even

/*******************************************************************************
*
* romInit - 
*
* This is the start of the ROM code.  The CPU will vector here upon reset.
* sysToMonitor() jumps to romInitWarm.
*/

_romInit:
	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit1	/* initial start in ROM */

_romInitWarm:
	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit2	/* subsequent starts in ROM */


/*******************************************************************************
*
* romInit1 -
*
* enable cache, clear all memory, copy ROM to RAM, set stack, go to usrInit
* This routine is position independent.

* romInit1 ()

*/

romInit1:
	/* clear and enable instruction cache */

	movel	#0x09,d0		/* clear and enable cache */
	.word	0x4e7b,0x0002		/* movec d0,cacr */

	/* clear all of memory */

	movel	#LOCAL_MEM_LOCAL_ADRS,a0 /* start of local memory */
	clrl	d0			/* value to fill */

	movel	#0x3f,d2		/* outer loop fills 16M bytes */
fb1:	movel	#0xffff,d1		/* inner loop fills 265K bytes */
fb2:	movel	d0,a0@+			/* fill 4 bytes */
	dbra	d1,fb2			/* inner loop test */
	dbra	d2,fb1			/* outer loop test */

	/* copy system from ROM to RAM */

	movel	#_romInit,a0		/* where system should be in RAM */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in ROM */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop1:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbf	d1,loop1

	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	#BOOT_COLD,a7@-		/* push startType arg */
	jsr	_usrInit		/* call usrInit; never returns */

/***********************************************************************
*
* romInit2 -
*
* Similar to romInit but doesn't clear memory.
* Also passes startType argument to usrInit.

* romInit2 (startType)

*/

romInit2:
	movel	a7@(4),d7		/* save 1st arg (startType) */

	/* clear and enable instruction cache */

	movel	#0x09,d0		/* clear and enable cache */
	.word	0x4e7b,0x0002		/* movec d0,cacr */

	/* copy system from ROM to RAM */

	movel	#_romInit,a0		/* where system should be in RAM */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in ROM */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop2:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbf	d1,loop2

	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	d7,a7@-			/* push startType arg */
	jsr	_usrInit		/* call usrInit; never returns */
