/* pic_cpu.c - HK68/V20,V2F jumpering */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01e,04may89,dnw  changed to say V20,V2F
01d,28oct88,gae  added PROMs and SYSRESET.
01c,04apr88,gae  removed call to printPic().
01b,16mar88,gae  renamed from pic_hkv2f.c for new jump.
01a,07nov87,jcf  created
*/

/*
This module contains the jumpering of the HK68/V20 and HK68/V2F.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "vxWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw CPU jumper config
*/

VOID drawBoard (pic, interactive)
    char *pic;		/* array holding picture */
    int interactive;

    {
    printAt (pic, 33, 1, "HK68/V20,V2F");

    /* This is the factory default, but for CPU to do system-wide
     * reset this jumper will be set.  Unfortunately, then the
     * CPU will ignore other resets.
     */

    printAt (pic, 15,  5, ".");
    printAt (pic, 15,  6, "X");
    printAt (pic, 15,  7, "J8 SYSRESET");

    /* PROMs */

    printAt (pic, 30, 13, " -------  ------- ");
    printAt (pic, 30, 14, "|  ROM  ||  ROM  |");
    printAt (pic, 30, 15, "|       ||       |");
    printAt (pic, 30, 16, "| HIGH  ||  LOW  |");
    printAt (pic, 30, 17, "|       ||       |");
    printAt (pic, 30, 18, "|  U16  ||  U15  |");
    printAt (pic, 30, 19, " ---^---  ---^--- ");
    }
