/* hkv2f.h - Heurikon HK68/V20,V2F,V2FA CPU board header file */

/*
modification history
--------------------
01h,17apr89,jcf  added include of new m68901.h file.
       +dnw+rml  misc cleanups
01g,29apr88,gae  added BUS and CPU constants.
		 moved MFP definitions to m68901.h
01f,15nov87,dnw  added missing MFP interrupt vector numbers.
01e,23oct87,dnw  changed HK_BCL_BUS_MASTER to HK_BCL_SYS_CONTROLLER.
01d,14jul87,dnw  broke out VSMAP definitions.
01c,08apr87,llk  added MFP interrupt level mask and enable definitions
		 (MFP_INT_LEVEL_1 through MFP_INT_LEVEL_7).
01b,30nov86,dnw  change VS_MAP_BITS to really only include map bits.
01a,24sep86,llk	 written.
*/

/*
This file contains I/O address and related constants
for the Heurikon HK68/V20 family.
*/

#ifndef	INChkv2fh
#define	INChkv2fh

#define	MFP_REG_ADDR_INTERVAL     2  /* address diff of adjacent regs. */
#include "m68901_new.h"

#define	TARGET_HK_V2F

#define BUS		VME_BUS
#define CPU		MC68020


/* interrupt vector locations */

#define PARITY_ERROR_VEC_NUM	31		/* mem parity error vector num*/

#define MFP_INT_VECT_NUM	64		/* MFP interrupt vector num */

/*
 * Motorola MC68901 MFP (Multi-Function Peripheral)
 */

#define	MFP_BASE_ADR	(0x00fec000)

#define MFP_INT_LEVEL_1		0x02	/* level 1 interrupt mask and enable */
#define MFP_INT_LEVEL_2		0x04	/* level 2 interrupt mask and enable */
#define MFP_INT_LEVEL_3		0x08	/* level 3 interrupt mask and enable */
#define MFP_INT_LEVEL_4		0x40	/* level 4 interrupt mask and enable */
#define MFP_INT_LEVEL_5		0x80	/* level 5 interrupt mask and enable */
#define MFP_INT_LEVEL_6		0x40	/* level 6 interrupt mask and enable */
#define MFP_INT_LEVEL_7		0x80	/* level 7 interrupt mask and enable */
#define MFP_MBOX_INT		0x80	/* mbox interrupt mask and enable */

/* vector number offsets */

#define MFP_INT_SYS_FAIL	MFP_INT_GP0	/* SYSFAIL */
#define MFP_INT_AC_FAIL		MFP_INT_GP1	/* ACFAIL */
#define MFP_INT_VME_2		MFP_INT_GP2	/* VMEbus interrupt level 2 */
#define MFP_INT_VME_PENDING	MFP_INT_GP3	/* VMEbus interrupt pending */
#define MFP_INT_VME_4		MFP_INT_GP4	/* VMEbus interrupt level 4 */
#define MFP_INT_MAILBOX		MFP_INT_GP5	/* mailbox interrupt */
#define MFP_INT_VME_6		MFP_INT_GP6	/* VMEbus interrupt level 6 */
#define MFP_INT_VME_7		MFP_INT_GP7	/* VMEbus interrupt level 7 */

/* memory constants */

#define HK_RAM_BASE_ADRS	0x02000000	/* 1st on-card RAM adrs */
#define HK_ROM_BASE_ADRS	0		/* 1st on-card ROM adrs */

#define HK_VEC_IRQ1		((unsigned short *) 0x00fee002)
#define HK_VEC_IRQ2		((unsigned short *) 0x00fee004)
#define HK_VEC_IRQ3		((unsigned short *) 0x00fee006)
#define HK_VEC_IRQ4		((unsigned short *) 0x00fee008)
#define HK_VEC_IRQ5		((unsigned short *) 0x00fee00a)
#define HK_VEC_IRQ6		((unsigned short *) 0x00fee00c)
#define HK_VEC_IRQ7		((unsigned short *) 0x00fee00e)

#define HK_RELEASE_SYSFAIL	((char *) 0xfe0000) /* turn off SYSFAIL */

/* VME bus control latch. */

#define HK_BUS_CONTROL_LATCH	((unsigned long *) 0xfe8000)

#define HK_BCL_MBOX_BASE_MASK	0xff000000
#define HK_BCL_MBOX_BASE_SHIFT	24
#define HK_BCL_VSB_ARBE		0x00800000
#define HK_BCL_VSB_ROR		0x00400000
#define HK_BCL_MBOX_ENABLE	0x00200000
#define HK_BCL_WDOG_DISABLE	0x00100000
#define HK_BCL_IRQ6_ENABLE	0x00080000
#define HK_BCL_IRQ5_ENABLE	0x00040000
#define HK_BCL_IRQ3_ENABLE	0x00020000
#define HK_BCL_IRQ1_ENABLE	0x00010000
#define HK_BCL_BC_RWD		0x00000000	/* release VME bus when done */
#define HK_BCL_BC_ROR		0x00004000	/* release VME bus on request */
#define HK_BCL_BC_RBCLR		0x00008000	/* release VME only on BCLR */
#define HK_BCL_BC_NO_RELEASE	0x0000c000	/* never release VME bus */
#define HK_BCL_USER_LED		0x00002000	/* user LED 0=on */
#define HK_BCL_SYS_CONTROLLER	0x00001000	/* 1 if this is sys controller*/
#define HK_BCL_RELEASE_HOLD	0x00000800

/* VSMAP in BCL contains three fields: MP1, MP2, MP3 */

#define HK_BCL_VSMAP_MASK	0x000007ff	/* mask for all three fields */

/* MP1 */

#define HK_BCL_MP1_NO_ACCESS	0x000
#define HK_BCL_MP1_STD_SUP_DATA	0x100
#define HK_BCL_MP1_STD_DATA	0x200
#define HK_BCL_MP1_STD		0x300
#define HK_BCL_MP1_EXT_SUP_DATA	0x400
#define HK_BCL_MP1_EXT_DATA	0x500
#define HK_BCL_MP1_EXT_SUP	0x600
#define HK_BCL_MP1_EXT		0x700

/* MP2: A = number of adrs lines */

#define HK_BCL_MP2_32A_0000	0x000
#define HK_BCL_MP2_32A_0400	0x010
#define HK_BCL_MP2_32A_0800	0x020
#define HK_BCL_MP2_32A_1000	0x030
#define HK_BCL_MP2_32A_2000	0x040
#define HK_BCL_MP2_32A_4000	0x050
#define HK_BCL_MP2_32A_8000	0x060
#define HK_BCL_MP2_32A_9000	0x070
#define HK_BCL_MP2_32A_A000	0x080
#define HK_BCL_MP2_32A_C000	0x090
#define HK_BCL_MP2_32A_C400	0x0A0
#define HK_BCL_MP2_32A_C800	0x0B0
#define HK_BCL_MP2_32A_CC00	0x0C0
#define HK_BCL_MP2_32A_D000	0x0D0
#define HK_BCL_MP2_32A_E800	0x0E0
#define HK_BCL_MP2_24A		0x0F0

/* MP3:  M = meg of onboard ram, V = meg of VSB ram, A = number of adrs lines */

#define HK_BCL_MP3_1M_0V_32A_00		0x000
#define HK_BCL_MP3_1M_0V_32A_10		0x001
#define HK_BCL_MP3_1M_0V_32A_20		0x002
#define HK_BCL_MP3_1M_2V_32A_00		0x003
#define HK_BCL_MP3_1M_4V_32A_00		0x004
#define HK_BCL_MP3_1M_8V_32A_00		0x005
#define HK_BCL_MP3_1M_16V_32A_00	0x006
#define HK_BCL_MP3_4M_0V_32A_40		0x007
#define HK_BCL_MP3_4M_0V_32A_80		0x008
#define HK_BCL_MP3_4M_0V_32A_C0		0x009
#define HK_BCL_MP3_4M_8V_32A_00		0x00A
#define HK_BCL_MP3_4M_16V_32A_00	0x00B
#define HK_BCL_MP3_16M_0V_32A_100	0x00C
#define HK_BCL_MP3_1M_0V_24A_00		0x00D
#define HK_BCL_MP3_4M_0V_24A_00		0x00E
#define HK_BCL_MP3_16M_0V_24A_00	0x00F

/* non-volatile ram constants */

#define HK_NV_RECALL	0x50000
#define HK_NV_STORE	0x40000
#define HK_NVRAM_ADDR	0x30000
#define HK_NVRAM_SIZE	128

#endif	INChkv2fh
