/* frc37.h - Force SYS68K/CPU-37 CPU board header file */

/*
modification history
--------------------
01a,28nov88,jcf  written.
*/

/*
This file contains I/O address and related constants for
VxWorks on the Force SYS68K/CPU-37.
*/

#ifndef	INCfrc37h
#define	INCfrc37h

#include "s62421.h"
#include "s68155.h"
#include "m68230.h"

#define DUSCC_REG_ADDR_INTERVAL	  1  /* address diff of adjacent regs. */
#include "m68562_new.h"

#define	MFP_REG_ADDR_INTERVAL     1  /* address diff of adjacent regs. */
#include "m68901_new.h"

#define	TARGET_FRC_37

#define BUS		VME_BUS
#define CPU		MC68020

/* interrupt vectors */

#define INT_VEC_SCSI		25	/* SCSI control chip */
#define INT_VEC_LANCE		26	/* LANCE ethernet control chip */
#define INT_VEC_MFP		27	/* MFP int. vector base num */
#define INT_VEC_PIT		29	/* PIT port interrupt */
#define INT_VEC_FDC		30	/* FDC */
#define INT_VEC_ABORT		31	/* ABORT */
#define INT_VEC_DUSCC		80	/* DUSCC int. vector base num */

/* LANCE defines */

#define FRC37_LANCE_INT_LVL	2		/* fixed priority of LANCE */
#define LN_POOL_ADRS 		((char *) 0xfff00000)	/* dedicated ln pool */
#define LN_POOL_SIZE 		((ULONG)  0x10000)	/* size of memory pool*/
#define LN_DATA_WIDTH 		2		/* word access only */

/* Local I/O addresses */

#define	FRC37_PIT_BASE_ADRS	((char *) 0xff800c00) /* m68230 PI/T */
#define	FRC37_DUSCC_BASE_ADRS	((char *) 0xff802000) /* m68562 DUSCC */
#define	FRC37_RTC_BASE_ADRS	((char *) 0xff803000) /* s62421 tod clock */
#define	FRC37_SCSI_BASE_ADRS	((char *) 0xff803400) /* 87031 SCSI */
#define	FRC37_FDC_BASE_ADRS	((char *) 0xff803800) /* wd1772 disk controler*/
#define	FRC37_LANCE_BASE_ADRS	((char *) 0xff804000) /* Am7990 LANCE */
#define FRC37_MFP_BASE_ADRS	((char *) 0xff805000) /* m68901 MFP */
#define	FRC37_IRHDL_BASE_ADRS	((char *) 0xff805800) /* m68155 int. handler */
#define	FRC37_BBRAM		((char *) 0xffc00000) /* battery backed up ram*/


/* PIT Port B defines */

/* memory size mask */
#define MEM_SIZE_MASK	0x7
#define MEM_SIZE_4M_NB	0x7	/* Memory does not support nibble mode */
#define MEM_SIZE_1M_NB	0x6	/* Memory does not support nibble mode */
#define MEM_SIZE_1M	0x5
#define MEM_SIZE_2M	0x4
#define MEM_SIZE_4M	0x3
#define MEM_SIZE_8M	0x2
#define MEM_SIZE_16M	0x1
#define MEM_SIZE_32M 	0x0

	/* board id mask */
#define BOARD_ID_MASK	0xf8


/* PIT Port C defines */
	/* system controller arbitration modes */
#define ARB_RAT		0x1		/* release after 125 ms timeout */
#define ARB_ROR		0x2		/* release on request */
#define ARB_NOT_REC	0x4		/* Don't release on every cycle */
#define ARB_RBCLR	0x10		/* release on bus clear */
#define VME_DATA32	0x80		/* vme data port = 32 bits (0 = 16b) */

/* Miscellaneous */
#define CLOCK_FREQ		8064000 	/* freq of PI/T clock input */
#define AUX_CLOCK_FREQ		3686400		/* freq of DUSCC clock input */

#endif	INCfrc37h
