/* pic_cpu.c - Force CPU-31 jumpering */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01a,24may89,shl  added name for B8 and B14.
01a,03mar89,jcf  created
*/

/*
This module contains the jumpering of the Force CPU-31.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "vxWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw CPU jumper config
*/

VOID drawBoard (pic, interactive)
    char *pic;		/* array holding picture */
    int interactive;

    {
    printAt (pic, 35, 1, "CPU-31");

    /* JUMPERS */

    jumperAt (pic,  4, 2, 4, HORIZONTAL, VERTICAL, 0xb);
    jumperAt (pic,  8, 1, 2, VERTICAL, HORIZONTAL, 0x3);
    jumperAt (pic,  9, 2, 5, HORIZONTAL, VERTICAL, 0x1e);
    jumperAt (pic, 14, 1, 2, VERTICAL, HORIZONTAL, 0x2);
    printAt (pic,  5, 4, "(B14) SYSCLK");
    printAt (pic,  9, 3, "*");
    printAt (pic, 10, 3, "*");
    printAt (pic, 10, 21, "* sys controller only");

    jumperAt (pic, 17, 13, 3, HORIZONTAL, VERTICAL, 0x0);
    jumperAt (pic, 20, 12, 2, VERTICAL, HORIZONTAL, 0x2);
    jumperAt (pic, 21, 13, 1, HORIZONTAL, VERTICAL, 0x1);
    printAt (pic, 18, 14, "(B8) EPROM SIZE");

    /* PROMs */

    printAt (pic, 25, 3, ".. ----------- ");
    printAt (pic, 25, 4, "  |    ROM    |");
    printAt (pic, 25, 5, "  >    J16    |");
    printAt (pic, 25, 6, "  |UPPER UPPER|");
    printAt (pic, 25, 7 ,".. ----------- ");

    printAt (pic, 40, 3, ".. ----------- ");
    printAt (pic, 40, 4, "  |    ROM    |");
    printAt (pic, 40, 5, "  >    J14    |");
    printAt (pic, 40, 6, "  |   UPPER   |");
    printAt (pic, 40, 7, ".. ----------- ");

    printAt (pic, 25,  8, ".. ---------- ");
    printAt (pic, 25,  9, "  |    ROM    |");
    printAt (pic, 25, 10, "  >    J12    |");
    printAt (pic, 25, 11, "  |   LOWER   |");
    printAt (pic, 25, 12 ,".. ----------- ");

    printAt (pic, 40,  8, ".. ----------- ");
    printAt (pic, 40,  9, "  |    ROM    |");
    printAt (pic, 40, 10, "  >    J10    |");
    printAt (pic, 40, 11, "  |LOWER LOWER|");
    printAt (pic, 40, 12 ,".. ----------- ");
    }
