/* pic_cpu.c - Force CPU-30 jumpering */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01b,24may89,shl  changed to correct eprom jumper field
		 added name for B1 and B10.
01a,03mar89,jcc  created
*/

/*
This module contains the jumpering of the Force CPU-30.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "vxWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw CPU jumper config
*/

VOID drawBoard (pic, interactive)
    char *pic;		/* array holding picture */
    int interactive;

    {
    printAt (pic, 35, 1, "CPU-30");

    /* JUMPERS */

    jumperAt (pic, 3,  2, 4, VERTICAL, HORIZONTAL, 0xb);
    jumperAt (pic, 3,  6, 2, HORIZONTAL, VERTICAL, 0x3);
    jumperAt (pic, 3,  7, 5, VERTICAL, HORIZONTAL, 0x1e);
    jumperAt (pic, 3, 12, 2, HORIZONTAL, VERTICAL, 0x1);
    printAt (pic, 3, 13, "(B10) SYSCLK");
    printAt (pic, 5, 8, "*");
    printAt (pic, 5, 9, "*");
    printAt (pic, 5, 21, "* sys controller only");

    jumperAt (pic, 30, 13, 4, HORIZONTAL, VERTICAL, 0x0);
    jumperAt (pic, 35, 13, 2, VERTICAL, HORIZONTAL, 0x3);
    jumperAt (pic, 36, 13, 2, HORIZONTAL, VERTICAL, 0x3);
    printAt (pic, 40, 13, "(B1) EPROM SIZE");

    /* PROMs */

    printAt (pic, 15,  7, ".. ----------- ");
    printAt (pic, 15,  8, "  |    ROM    |");
    printAt (pic, 15,  9, "  >    J8     |");
    printAt (pic, 15, 10, "  |   UPPER   |");
    printAt (pic, 15, 11 ,".. ----------- ");

    printAt (pic, 30,  7, ".. ----------- ");
    printAt (pic, 30,  8, "  |    ROM    |");
    printAt (pic, 30,  9, "  >    J10    |");
    printAt (pic, 30, 10, "  |UPPER UPPER|");
    printAt (pic, 30, 11, ".. ----------- ");

    printAt (pic, 45,  7, ".. ---------- ");
    printAt (pic, 45,  8, "  |    ROM    |");
    printAt (pic, 45,  9, "  >    J4     |");
    printAt (pic, 45, 10, "  |LOWER LOWER|");
    printAt (pic, 45, 11 ,".. ----------- ");

    printAt (pic, 60,  7, ".. ----------- ");
    printAt (pic, 60,  8, "  |    ROM    |");
    printAt (pic, 60,  9, "  >    J6     |");
    printAt (pic, 60, 10, "  |   LOWER   |");
    printAt (pic, 60, 11 ,".. ----------- ");
    }
