/* eagle5.h - Integrated Solutions - Eagle-5 CPU board header file */

/*
This file contains I/O address and related constants for
vxWorks on the Integrated Solutions - Eagle-5 CPU
*/

#ifndef	INCeagle5h
#define	INCeagle5h

#define TARGET_ISI_E5
#define TARGET_ISI

#define BUS     VME_BUS
#define CPU     MC68020

/* port addresses for Signetics SCN2681 DUART */

#define N_USART_CHANNELS	2		/* Number of serial channels */

#define	VME_U_BASE	0xfec00000

#define	VME_U_MR2A ((char *) (VME_U_BASE+0x00))  /* Mode Registers A1 and A2 */
#define	VME_U_MR1A ((char *) (VME_U_BASE+0x00))  /* Mode Registers A1 and A2 */
#define	VME_U_MR2B ((char *) (VME_U_BASE+0x08))  /* Mode Registers B1 and B2 */
#define	VME_U_MR1B ((char *) (VME_U_BASE+0x08))  /* Mode Registers B1 and B2 */
#define VME_U_IMR  ((char *) (VME_U_BASE+0x05))  /* Interrupt Mask Register */
#define VME_U_ISR  ((char *) (VME_U_BASE+0x05))  /* Interrupt Status Register */
#define VME_U_CRA  ((char *) (VME_U_BASE+0x02))  /* Command Register A */
#define VME_U_CRB  ((char *) (VME_U_BASE+0x0A))  /* Command Register B */
#define VME_U_CSRA ((char *) (VME_U_BASE+0x01))  /* Clock Select Register A */
#define VME_U_CSRB ((char *) (VME_U_BASE+0x09))  /* Clock Select Register B */
#define VME_U_RHRA ((char *) (VME_U_BASE+0x03))  /* Rx Holding Register A */
#define VME_U_THRA ((char *) (VME_U_BASE+0x03))  /* Tx Holding Register A */
#define VME_U_RHRB ((char *) (VME_U_BASE+0x0B))  /* Rx Holding Register B */
#define VME_U_THRB ((char *) (VME_U_BASE+0x0B))  /* Tx Holding Register B */
#define VME_U_ACR  ((char *) (VME_U_BASE+0x04))  /* Aux Control Reg */
#define VME_U_CTUR ((char *) (VME_U_BASE+0x06))  /* Counter/Timer MSB */
#define VME_U_CTLR ((char *) (VME_U_BASE+0x07))  /* Counter/Timer LSB */
#define VME_U_START_TMR ((char *) (VME_U_BASE+0x0E)) /* start-timer command */
#define VME_U_STOP_TMR ((char *) (VME_U_BASE+0x0F))  /* stop-timer command */


/* Bit values for options selected by MR1A/B of the DUART */

#define	VME_U_NO_PAR	0x10
#define	VME_U_8_BITS	0x03


/* Bit values for options selected by MR2A/B of the DUART */

#define	VME_U_1_STOP	0x07


/* Bit values for options selected by CRA/B of the DUART */

#define	VME_U_MR_RST	0x08
#define	VME_U_RX_RST	0x10
#define	VME_U_TX_RST	0x18
#define	VME_U_ERR_RST	0x20
#define	VME_U_BRK_RST	0x28	
#define	VME_U_TX_EN	0x04
#define	VME_U_TX_DIS	0x08
#define	VME_U_RX_EN	0x01
#define	VME_U_RX_DIS	0x02

/* Bit values for options selected by CSRA/B of the DUART */

#define	VME_U_RX_9600	0xB0
#define	VME_U_TX_9600	0x0B
#define	VME_U_RX_1200	0x60
#define	VME_U_TX_1200	0x06

/* Bit values for options selected by IMR of the DUART */

#define	VME_U_INT_RXA		0x02
#define	VME_U_INT_TXA		0x01
#define	VME_U_INT_RXB		0x20
#define	VME_U_INT_TXB		0x10
#define	VME_U_INT_TIMER		0x08

/* bits and commands in the DUART ACR reg */

#define VME_U_ACR_BRG_SEL	0x80		/* select BRG freq */
#define VME_U_ACR_CTR_EXT	0x00		/* counter-mode, extern clock */
#define VME_U_ACR_CTR_TXCA	0x10		/* counter-mode, Tx clock A */
#define VME_U_ACR_CTR_TXCB	0x20		/* counter-mode, Tx clock B */
#define VME_U_ACR_CTR_XTAL	0x30		/* counter-mode, xtal */
#define VME_U_ACR_TMR_EXT	0x40		/* timer-mode, extern clock */
#define VME_U_ACR_TMR_EXT_16	0x50		/* timer-mode, extern / 16 */
#define VME_U_ACR_TMR_XTAL	0x60		/* timer-mode, xtal */
#define VME_U_ACR_TMR_XTAL_16	0x70		/* timer-mode, xtal / 16 */

/* non-volatile RAM */
/* change nvram_boot_argsize later because it takes
 * up all of the nvram now KRM
 */
#define NVRAM_BASE		0xfec03000
#define NVRAM_SAVE		0xfec05000
#define NVRAM_SIZE		0x100
#define NVRAM_BYTES		(NVRAM_SIZE/2)	/* each address has one nib */
#define NVRAM_MASK		(NVRAM_SIZE-1)

#define	NVRAM_BOOT_ARGSIZE	80 		/* size of boot arg */ 
#define	NVRAM_BOOT_ARG	(NVRAM_BYTES-NVRAM_BOOT_ARGSIZE)
#define NVRAM_PROC_NUMBER	10		/* offset to processor number */

/* 7 segment LED display */
#define SEG7_ADDR		0xfec04000

/* The PIT device is used for status/control ports */

#define PIT_BASE		0xfec02000

#define PIT_GCR			((char *)(PIT_BASE + 0x00))
#define PIT_SRR			((char *)(PIT_BASE + 0x01))
#define PIT_ADDR		((char *)(PIT_BASE + 0x02))
#define PIT_BDDR		((char *)(PIT_BASE + 0x03))
#define PIT_CDDR		((char *)(PIT_BASE + 0x04))
#define PIT_PIVR		((char *)(PIT_BASE + 0x05))
#define PIT_ACR			((char *)(PIT_BASE + 0x06))
#define PIT_BCR			((char *)(PIT_BASE + 0x07))
#define PIT_ADR			((char *)(PIT_BASE + 0x08))
#define PIT_BDR			((char *)(PIT_BASE + 0x09))
#define PIT_AAR			((char *)(PIT_BASE + 0x0a))
#define PIT_BAR			((char *)(PIT_BASE + 0x0b))
#define PIT_CDR			((char *)(PIT_BASE + 0x0c))
#define PIT_PSR			((char *)(PIT_BASE + 0x0d))

#define PIT_TCR			((char *)(PIT_BASE + 0x10))
#define PIT_TIVR		((char *)(PIT_BASE + 0x11))
#define PIT_CPRH		((char *)(PIT_BASE + 0x13))
#define PIT_CPRM		((char *)(PIT_BASE + 0x14))
#define PIT_CPRL		((char *)(PIT_BASE + 0x15))
#define PIT_CRH			((char *)(PIT_BASE + 0x17))
#define PIT_CRM			((char *)(PIT_BASE + 0x18))
#define PIT_CRL			((char *)(PIT_BASE + 0x19))
#define PIT_TSR			((char *)(PIT_BASE + 0x1a))

#define TCR_TMR_ENA		0x41
#define TCR_TMR_DIS		0x40

#define TSR_TMR_INT		0x01

/* Register B of PIT */

#define NMI_ACFAIL		0x10
#define NMI_ABORT		0x08
#define NMI_MASK		(NMI_ACFAIL|NMI_ABORT)

#define SEM7_ENAB		0x00
#define SEM7_DISAB		0x40
#define ABORT_ENAB		0x00
#define ABORT_DISAB		0x20
#define ARB_RWD			0x00
#define ARB_ROR			0x04
#define AM5_NORM		0x00
#define AM5_USER		0x02
#define AM4_NORM		0x00
#define AM4_USER		0x01

#define DISPLAY_OFF		0x04
#define DISPLAY_ON		(~DISPLAY_OFF)


/* real-time clock register functions */
#define RTC_YRHI		0xc
#define RTC_YRLO		0xb
#define RTC_MOHI		0xa
#define RTC_MOLO		0x9
#define RTC_DYHI		0x8
#define RTC_DYLO		0x7
#define RTC_WEEK		0x6
#define RTC_HRHI		0x5
#define RTC_HRLO		0x4
#define RTC_MIHI		0x3
#define RTC_MILO		0x2
#define RTC_SEHI		0x1
#define RTC_SELO		0x0

#define RTC_24HRS		0x08
#define RTC_12HRS		0x00

/* interrupt handler chip and local vectors */

#define LOCAL_INT_BASE		0x80
#define IHAN_INT_BASE		LOCAL_INT_BASE
#define INT_NUM_IHAN1		(IHAN_INT_BASE + 1)	/* level 1 at IHAN */
#define INT_NUM_IHAN2		(IHAN_INT_BASE + 2)	/* level 2 at IHAN */
#define INT_NUM_IHAN3		(IHAN_INT_BASE + 3)	/* level 3 at IHAN */
#define INT_NUM_IHAN4		(IHAN_INT_BASE + 4)	/* level 4 at IHAN */
#define INT_NUM_IHAN5		(IHAN_INT_BASE + 5)	/* level 5 at IHAN */
#define INT_NUM_IHAN6		(IHAN_INT_BASE + 6)	/* level 6 at IHAN */
#define INT_NUM_IHAN7		(IHAN_INT_BASE + 7)	/* level 7 at IHAN */

#define IHAN_BASE		0xfec01000
#define IHAN_PR			((char *)(IHAN_BASE + 1))
#define IHAN_CR			((char *)(IHAN_BASE + 0x1 * 2 + 1))
#define IHAN_VR			((char *)(IHAN_BASE + 0x2 * 2 + 1))
#define IHAN_LMR		((char *)(IHAN_BASE + 0x3 * 2 + 1))
#define IHAN_LSR		((char *)(IHAN_BASE + 0x4 * 2 + 1))
#define IHAN_BMR		((char *)(IHAN_BASE + 0x5 * 2 + 1))
#define IHAN_BSR		((char *)(IHAN_BASE + 0x6 * 2 + 1))
#define IHAN_LIA		((char *)(IHAN_BASE + 0x7 * 2 + 1))

/* control register constants */
#define CR_ACTIVE_LO		0x0
#define CR_ACTIVE_HI		0x1
#define CR_EDGE_SENSE		0x2
#define CR_LEVEL_SENSE		0x0
#define CR_VEC_ENAB		0x4
#define CR_VEC_DIS		0x0

/* mask register constants */
#define LMR_NMI_VEC_ENAB	0x1
#define LMR_NMI_VEC_DIS		0x0
#define LMR_NMI_ENAB		0x80
#define LMR_NMI_DIS		0x0

/* miscellaneous stuff */

#define VME_PAGE_SIZE		0x1000
#define VME_PAL_ADRS		0x400000

#endif	INCvme68k20h

#define	VSB_START		0xf0000000
