/* e5/config.h - Integrated Solutions Eagle-5 configuration header */

/* 
modification history
--------------------
*/

/* This file contains parameters that define the configuration
for the Integrated Solutions Eagle-5 SBC.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "eagle5.h"
#include "vme.h"
#include "iv68k.h"

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"nw(0,0)host:/usr/vw/config/e5/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */
/******************************************************************************/

#define FREE_RAM_ADRS		(&end)	/* start right after bss of vxWorks */	

#define MAX_TASKS		25	/* maximum # of tasks in system */

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 file open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_CDB		/* CDB source debugger */
#define INCLUDE_DEBUG           /* native debugging */
#define INCLUDE_FLOATING_POINT  /* floating point I/O */
/*#define	INCLUDE_FORTRAN		/* NKR run time Fortran library */
#define INCLUDE_MC68881         /* MC68881/2 float point co-processor */
#define INCLUDE_NETWORK         /* network subsystem code */
#define INCLUDE_NET_INIT        /* network subsystem initialization */
#define INCLUDE_NET_SYM_TBL     /* load symbol table from network */
#define INCLUDE_NFS             /* nfs package */
#define INCLUDE_RAMDRV          /* ram disk driver */
#define INCLUDE_RLOGIN          /* remote login */
#define INCLUDE_RPC             /* rpc package */
#define INCLUDE_RT11            /* RT-11 file system */
#define INCLUDE_SHELL           /* interactive c-expression interpreter */
#define INCLUDE_SPY             /* spyLib for task monitoring */
#define INCLUDE_STDIO           /* standard I/O */
#define INCLUDE_TELNET          /* telnet-style remote login */
#define INCLUDE_TIMEX           /* timexLib for exec timing */

/* included hardware support */

/*#define	INCLUDE_CP		/* include ISI ICP8/16 interface */
/*#define	INCLUDE_DR		/* include Ikon DR-11W interface */
/*#define INCLUDE_ENP		/* include CMC Ethernet interface*/
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_EE		/* include onboard Lance Ethernet interface */
/*#define INCLUDE_NW		/* include ISI Ethernet interface */
/*#define	INCLUDE_SM		/* include Interphase 3200/4200 SMD interface */
/*#define	INCLUDE_TS		/* include ISI QIC2-X/TC-50 tape interface */
/*#define	INCLUDE_VB		/* include ISI VB driver */


/* EXCLUDED facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_ADA		/* include Ada support */
#define INCLUDE_DBX             /* dbx package */
#define INCLUDE_STANDALONE_SYM_TBL      /* compiled-in symbol table */
#define INCLUDE_STARTUP_SCRIPT  /* execute start-up script */

#define INCLUDE_IE		/* include Sun Ethernet interface*/
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_BP		/* include backplane net interface */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE


/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_VXWORKS		1	/* trap 1 - vxWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */

#ifdef	KERNEL_VRTX
#define TRAP_MPV		TRAP_KERNEL	/* MPV goes through VRTX */
#else	KERNEL_VRTX
#define	TRAP_MPV		3	/* MPV handles its own traps */
#endif	KERNEL_VRTX


/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/* Default NFS parameters */

#define NFS_USER_ID	2001
#define NFS_GROUP_ID	100

#define IO_ADRS_EX	((char *) 0xfffe0000)	/* 24A,32D Excelan Ethernet */
#define IO_ADRS_ENP	((char *) 0xffde0000)	/* 24A,32D CMC Ethernet */
#define IO_ADRS_IE	((char *) 0xff300000)	/* 24A,32D Sun 3e Ethernet */
#define IO_ADRS_NW	((char *) 0xfff80000)	/* 24A,32D ISI Ethernet */

/* VME Address space offsets: CPU-->BUS mapping */

#define	VME_SHORTIO	0xffff0000 	/* to 0xffff ffff */
#define VME_STANDARD	0xff000000	/* to 0xfffe ffff */
#define	VME_EXTENDED	0x00000000	/* to 0xefff ffff */
#define VME_WINDOW_STD	0
#define	VME_WINDOW_EXT	0

/* interrupt vectors */

#define INT_NUM_CONSOLE		INT_NUM_IHAN4
#define INT_NUM_CLOCK		INT_NUM_IHAN6
#define INT_NUM_NMI		INT_NUM_IHAN7
#define INT_NUM_VSB		INT_NUM_IHAN2
#define INT_NUM_IPIN		INT_NUM_IHAN5
#define INT_NUM_SCSI		INT_NUM_IHAN1
#define INT_NUM_IPI		INT_NUM_IHAN3
#define INT_NUM_SEM		(LOCAL_INT_BASE+8)

#define INT_VEC_NMI		((INT_NUM_NMI)*4)
#define INT_VEC_SEM		((INT_NUM_SEM)*4)
#define INT_VEC_IPI		((INT_NUM_IPI)*4)

#define VB_SHARED_MEM	0x00f00000		/* vb backplane shared memory */
#define	VB_SHMEM_SIZE	0x40000		/* default 256k */

/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The Eagle 5 local memory always appears at 0 locally 
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* fixed */


/* The following address is the base address of the on-board rom. */

#define ROM_BASE_ADRS           0xfe800000

/* Mailbox interrupt addresses */

#endif	INCconfigh
