/* e5/config.h - Integrated Solutions Eagle-5 configuration header */

/* 
modification history
--------------------
*/

/* This file contains parameters that define the configuration
for the Integrated Solutions Eagle-5 SBC.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "eagle5.h"
#include "vme.h"
#include "iv68k.h"

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"nw(0,0)host:/usr/vw/config/e5/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_CDB		/* CDB source debugger */
#define INCLUDE_DEBUG           /* native debugging */
#define INCLUDE_FLOATING_POINT  /* floating point I/O */
/*#define	INCLUDE_FORTRAN		/* NKR run time Fortran library */
#define INCLUDE_MC68881         /* MC68881/2 float point co-processor */
#define INCLUDE_NETWORK         /* network subsystem code */
#define INCLUDE_NET_INIT        /* network subsystem initialization */
#define INCLUDE_NET_SYM_TBL     /* load symbol table from network */
#define INCLUDE_NFS             /* nfs package */
#define INCLUDE_RAMDRV          /* ram disk driver */
#define INCLUDE_RLOGIN          /* remote login */
#define INCLUDE_RPC             /* rpc package */
#define INCLUDE_RT11            /* RT-11 file system */
#define INCLUDE_SHELL           /* interactive c-expression interpreter */
#define INCLUDE_SPY             /* spyLib for task monitoring */
#define INCLUDE_STDIO           /* standard I/O */
#define INCLUDE_TELNET          /* telnet-style remote login */
#define INCLUDE_TIMEX           /* timexLib for exec timing */

/* included hardware support */

/*#define	INCLUDE_CP		/* include ISI ICP8/16 interface */
/*#define	INCLUDE_DR		/* include Ikon DR-11W interface */
/*#define INCLUDE_ENP		/* include CMC Ethernet interface*/
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_EE		/* include onboard Lance Ethernet interface */
/*#define INCLUDE_NW		/* include ISI Ethernet interface */
#define	INCLUDE_SM		/* include Interphase 3200/4200 SMD interface */
/*#define	INCLUDE_TS		/* include ISI QIC2-X/TC-50 tape interface */
#define	INCLUDE_VB		/* include ISI VB driver */


/* EXCLUDED facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_ADA		/* include Ada support */
#define INCLUDE_DBX             /* dbx package */
#define INCLUDE_STANDALONE_SYM_TBL      /* compiled-in symbol table */
#define INCLUDE_STARTUP_SCRIPT  /* execute start-up script */

#define INCLUDE_IE		/* include Sun Ethernet interface*/
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_BP		/* include backplane net interface */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE

/*
 * Default NFS parameters - constants may be changed here, variables
 * may be changed in usrConfig.c at the point where NFS is included.
 */

#ifdef	INCLUDE_NFS

#define NFS_USER_ID		2001	/* dummy nfs user id */
#define NFS_GROUP_ID		100	/* dummy nfs user group id */

#endif	INCLUDE_NFS

/******************************************************************************/
/*                                                                            */
/*                           BOARD CONFIGURATION                              */
/*                                                                            */
/******************************************************************************/

/* Device controller I/O addresses: only used if the devices are included. */

#define IO_ADRS_EX	((char *) 0xffff0000)	/* 24A,32D Excelan Ethernet */
#define IO_ADRS_ENP	((char *) 0xffde0000)	/* 24A,32D CMC Ethernet */
#define IO_ADRS_IE	((char *) 0xff300000)	/* 24A,32D Sun 3e Ethernet */
#define IO_ADRS_NW	((char *) 0xfff80000)	/* 24A,32D ISI Ethernet */

/* interrupt vectors */

#define INT_VEC_CONSOLE		IVEC_TO_INUM (IV_AUTOVEC_5)
#define INT_VEC_CLOCK		IVEC_TO_INUM (IV_AUTOVEC_6)

#define INT_VEC_BP	IVEC_TO_INUM (IV_AUTOVEC_4)	/* backplane int */

/*
 * Interrupt vectors: only used if the devices are included.
 */

#define INT_VEC_ENP		192	/* CMC Ethernet controller*/
#define INT_VEC_EX		193	/* Excelan Ethernet controller*/
#define INT_VEC_IE		194	/* Sun Ethernet controller*/
#define INT_VEC_NW		195	/* ISI Ethernet controller*/
#define INT_VEC_PN		196	/* Proteon Ethernet controller*/

/*
 * Interrupt levels: only used if the devices are included.
 */

#define INT_LVL_ENP		3	/* CMC Ethernet controller */
#define INT_LVL_EX		2	/* Excelan Ethernet controller */
#define INT_LVL_IE		3	/* Sun 3e Ethernet controller */
#define INT_LVL_NW		3	/* ISI Ethernet controller */
#define INT_LVL_PN		1	/* Proteon ProNet controller */

/* backplane network parameters */

/*
 * Mailbox interrupt addresses:
 * processor #:       VME short I/O address:
 *     0                   0xc000
 *     1                   0xc002
 *     2                   0xc004
 *     3                   0xc006
 */

/* TODO: What should BP defines be ? */

/* Backplane parameter */
#define	BP_TAS	TRUE		/* hardware supports test-and-set */

/* The ISI Eagle-5 SBC can also be used with the ISI vb driver */

#define VB_SHARED_MEM	0x00f00000		/* vb backplane shared memory */
#define	VB_SHMEM_SIZE	0x40000		/* default 256k */

/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The Eagle 5 local memory always appears at 0 locally 
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* fixed */

/* The following address is the base address of the on-board rom. */

#define ROM_BASE_ADRS           0xfe800000

/* VME Address space offsets: CPU-->BUS mapping */

#define	VME_SHORTIO	0xefff0000 	/* to 0xefff ffff */
#define VME_STANDARD	0xff000000	/* to 0xfffe ffff */
#define	VME_EXTENDED	0x00000000	/* to 0xeffe ffff */
#define VME_WINDOW_STD	0
#define	VME_WINDOW_EXT	0

/* Eagle-5 specific defines */

/* interrupt vectors */

#define INT_NUM_CONSOLE		INT_NUM_IHAN4
#define INT_NUM_CLOCK		INT_NUM_IHAN6
#define INT_NUM_NMI		INT_NUM_IHAN7
#define INT_NUM_VSB		INT_NUM_IHAN2
#define INT_NUM_IPIN		INT_NUM_IHAN5
#define INT_NUM_SCSI		INT_NUM_IHAN1
#define INT_NUM_IPI		INT_NUM_IHAN3
#define INT_NUM_SEM		(LOCAL_INT_BASE+8)

#define INT_VEC_NMI		((INT_NUM_NMI)*4)
#define INT_VEC_SEM		((INT_NUM_SEM)*4)
#define INT_VEC_IPI		((INT_NUM_IPI)*4)

/* Mailbox interrupt addresses */

#endif	INCconfigh
