/* dy4/config.h - DY4-134 configuration header */

/*
modification history
--------------------
02a,29apr88,gae  relocated bulk to configAll.h.
01h,24mar88,ecs  added EXC_MSG_ADRS.
01g,19apr88,llk  includes RPC and DBX.
01f,20nov87,dnw  changed definitions to new naming conventions.
01e,19nov87,ecs  added coercion to BP_INT_ARG2 & BP_MEM_SIZE to please lint.
01d,13nov87,dnw  added new backplane parameters (BP_ANCHOR, etc).
		 changed to include ENP interface instead of NW.
01c,23oct87,jcf  setup for mailbox interrupts
01b,02oct87,jcf  cleaned up for new release
		 removed obsolete MAIL_BOX_SIZE, BP_POLL definitions.
		 moved ISR_STACK_SIZE to usrConfig.h.
		 added CPU, BP_INT_TYPE, BP_INT_ARG[123].
		 added trap definitions.
		 added defines for optional floating pt support.
01a,13jul87,jcf  created by modifying 01g of hkv2f/config.h 
*/

/*
This file contains the parameters that define the configuration
for the DY4-134.
*/

#ifndef INCconfigh
#define INCconfigh

#include "configAll.h"
#include "dy4_134.h"


#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/dy4/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"


/* Device controller I/O addresses: dy4 needs 0x01000000 bit set */

#undef	IO_ADRS_EX
#define IO_ADRS_EX	((char *) 0x01ff0000)	/* 24A,32D Excelan Ethernet */
#undef	IO_ADRS_ENP
#define IO_ADRS_ENP	((char *) 0x01de0000)	/* 24A,32D CMC Ethernet */
#undef	IO_ADRS_IE
#define IO_ADRS_IE	((char *) 0x01300000)	/* 24A,32D Sun Ethernet */
#undef	IO_ADRS_NW
#define IO_ADRS_NW	((char *) 0x01f80000)	/* 24A,32D ISI Ethernet */
#undef	IO_ADRS_PN
#define IO_ADRS_PN	((char *) 0x01100000)	/* 24A,32D Proteon ProNet */


/* interrupt vectors */

#define INT_VEC_CLOCK		(MFP_INT_VECT_NUM + MFP_INT_TIMER_A)
#define INT_VEC_PARITY_ERROR	(MFP_INT_VECT_NUM + MFP_INT_GP5)
#define INT_VEC_BP		(MFP_INT_VECT_NUM + MFP_INT_GP2) /* backplane */


/* backplane network parameters */

/*
 * Mailbox addresses for dy4 boards are accomplished by using the location
 * monitor.  This interrupts via the MFP when ever a write access occurs to
 * an odd address in the upper 1k of dual ported memory.  It is important that
 * the board not be in BI mode because it will not respond to such accesses
 * correctly.  It is up to the MFP mail box routine to poll the lm status
 * register to determine which particalar location was accessed.
 *
 * processor #:       VME standard I/O address:
 *     0                   0x001ffc02
 *     1                   0x001ffc06
 *     2                   0x001ffc0a
 *     etc...
 */

#define BP_ANCHOR_ADRS	((char *) (0x01800000))	/* 24A,32D bp shared memory */

#define BP_INT_TYPE	BP_INT_MAILBOX_2	/* mailbox interrupt */
#define BP_INT_ARG1	VME_AM_STD_SUP_DATA	/* bus address space */
#define BP_INT_ARG2	(0x1ffc00 + (sysProcNum << 2) + 2) /* bus address */
#define BP_INT_ARG3	0			/* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#define BP_MEM_ADRS	BP_ANCHOR_ADRS		/* bp shared mem adrs */
#define BP_MEM_SIZE	0x80000			/* 512k */


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the dy4 local memory always appears at 0 locally;
 * its address on the bus is set by jumpers which are read at run time!
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* fixed/runtime */
#define	LOCAL_MEM_BUS_ADRS	0		/* XXX ??? */

/* The following address is the base address of the on-board rom. */
 
#define ROM_BASE_ADRS		0xfffb0000

#endif	INCconfigh
