/* configVrtx.c - VxWorks/VRTX system configuration */

/*
modification history
--------------------
01h,01may89,dnw  added MAX_TASKS, previously in configAll.h.
01g,24aug88,gae  changed name of VX_ types to VRTX_.
01f,08jul88,jcf  lint.
01e,12jun88,jcf  changed into c file which just defines the config table.
01d,17may88,ecs  removed copyright line.
01c,22apr88,gae  changed VRTX functions to use vrtx prefix.
01b,19apr88,llk  increased shell's stack size from 5000 to 10000.
01a,15feb88,jcf  written by extracting from usrConfig.c
*/

#include "vxWorks.h"
#include "config.h"

IMPORT VOID vrtxTcreateHook ();	/* task creation extension */
IMPORT VOID vrtxTswitchHook ();	/* task switch extension */

/* globals */

#define MAX_TASKS	25	/* maximum # of tasks in system */

/* workspace = 2748 + ISR_STACK_SIZE + MAX_TASKS * 160 + 128 + X */

#define WORKSPACE_SIZE	10000	/* # of bytes for kernel workspace */

char vrtxWorkspace[WORKSPACE_SIZE];

#if (CPU == MC68020)			/* use VRTX/32 for MC68020 */
#include "vrtx32.h"

/*******************************************************************************
*
* VRTX/32 configuration table
*/

VRTX_CONFIG_TABLE usrCftbl =
    {
    (char *) vrtxWorkspace,	/* VRTX/32 workspace address */
    WORKSPACE_SIZE,		/* VRTX/32 workspace size */
    0,				/* system-mode task VRTX/32 stack size */
    ISR_STACK_SIZE,		/* ISR stack size */
    0,				/* control block count */
    0,				/* blank1 */
    0,				/* blank2 */
    INT_LOCK_LEVEL,		/* VRTX/32 disable mask */
    0,				/* user-mode task VRTX/32 stack size */
    0,				/* blank3 */
    MAX_TASKS,			/* user task count (max tasks) */
    0,				/* blank4 */
    (FUNCPTR) 0,		/* no TXRDY driver */
    vrtxTcreateHook,		/* system task create routine */
    (FUNCPTR) 0,		/* no delete routine */
    vrtxTswitchHook,  		/* system task switch routine */
    (char *) 0			/* no component vector table */
    };

#else (CPU != MC68020)		/* use VRTX/680X0 for MC68010/MC68000 */
#include "vrtx.h"

/*******************************************************************************
*
* VRTX configuration table
*/


VRTX_CONFIG_TABLE usrCftbl =
    {
    (char *) vrtxWorkspace,	/* VRTX workspace address */
    WORKSPACE_SIZE,		/* VRTX workspace size */
    0,				/* system-mode task VRTX stack size */
    0,				/* ISR stack size */
    0,				/* blank1 */
    0,				/* blank2 */
    INT_LOCK_LEVEL,		/* VRTX disable mask */
    0,				/* user-mode task VRTX stack size */
    0,				/* blank3 */
    MAX_TASKS,			/* user task count (max tasks) */
    0,				/* blank4 */
    (FUNCPTR) 0,		/* TXRDY driver address */
    vrtxTcreateHook,		/* system task create routine */
    (FUNCPTR) 0,		/* no delete routine */
    vrtxTswitchHook,  		/* system task switch routine */
    (char *) 0			/* CVT address */
    };
#endif (CPU)
