/* configAll.h - default configuration header */

/*
modification history
--------------------
01i,25may89,gae  if'd out INCLUDE_DBX, INCLUDE_NFS,and INCLUDE_RPC for release.
01h,01may89,dnw  removed MAX_TASKS to configVrtx.c and configPsos.c since
		   WRS kernel has no pre-defined maximum.
01g,20dec88,gae  added BP_TAS backplane parameter.
01f,08nov88,dnw  removed DBX_DEBUG_ADA, added INCLUDE_ADA.
01e,01nov88,gae  removed IMPORTS; added DBX_DEBUG_ADA.
01d,09sep88,llk  added NFS IMPORTs; boosted ROOT_STACK_SIZE from 5K.
01c,11jun88,jcf  added kernel defines.
		 added include of config.h so CPU is defined.
		 removed INCLUDE_SIGNALS. (they're not optional)
01b,05jun88,dnw  changed INCLUDE_TIMLIB to INCLUDE_TIMEX.
01a,22apr88,gae  created by merging <target>/config.h's.
*/

/*
This module contains the parameters that define
the default configuration for VxWorks.
*/

#ifndef	INCconfigAllh
#define	INCconfigAllh

#include "if_bp.h"
#include "vme.h"
#include "iv68k.h"

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */
/******************************************************************************/

#define FREE_RAM_ADRS		(&end)	/* start right after bss of VxWorks */	

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define ROOT_STACK_SIZE		10000	/* size of root's stack, in bytes */
#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 files open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_VXWORKS		1	/* trap 1 - vxWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */

/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/******************************************************************************/
/*                                                                            */
/*                           TASK PRIORITIES                                  */
/*                                                                            */
/******************************************************************************/

#define PRIORITY_CDBDAEMON	100	/* cdb task */
#define PRIORITY_CDBSERVER	100	/* cdb server task */
#define PRIORITY_DBX    	20	/* dbx task */
#define PRIORITY_EXC		0	/* exception task */
#define PRIORITY_IDLE		254	/* idle task */
#define PRIORITY_ISIBOOTD	100	/* boot daemon task */
#define PRIORITY_LOG		0	/* logging task */
#define PRIORITY_NETD		5	/* network task */
#define PRIORITY_PORTMAPD	100	/* portmapper */
#define PRIORITY_RLOGIND	11	/* rlogin tasks */
#define PRIORITY_RLOGINDIN	11
#define PRIORITY_RLOGINDOUT	11
#define PRIORITY_SHELL		10	/* shell task */
#define PRIORITY_SPY		5	/* spy task */
#define PRIORITY_TELNETD	2	/* telnet task */
#define PRIORITY_VBPOLL		11	/* backplane poll task */
#endif	INCconfigAllh
