/* 3x4Lib.c - 3.2 to 4.0 conversion library */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01d,07sep88,gae  made it pass lint.
01c,01sep88,gae  documentation.
01b,26aug88,gae  changed VX_ to VRTX_, fixed vxTaskTcb ().
01a,11aug88,gae  generated/written.
*/

/*
DESCRIPTION
This library contains routines to convert 3.2 calling sequences to
4.0 equivalents.  In addition, some obsolete 3.2 routines are provided.
The tool 3x4 is provided to convert source code to 4.0.

SPECIAL NOTE
The following routines are a incompatible and have no corresponding
3.2 to 4.0 mapping.
.CS
    memPartInit
    fprintf
    iosFdSet
.CE

SEE ALSO: 3x4ALib (1), 3x4 (4)
*/

#include "vxWorks.h"
#include "memLib.h"
#include "vrtx.h"
#include "loadLib.h"
#include "taskLib.h"
#include "ctype.h"

IMPORT int taskIdCurrent;

#ifndef	LINT

/*******************************************************************************
*
* spawn -
*
* NOMANUAL
*/

int spawn (priority,id,options,entryAddress,stacksize,
	   arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10)
    int priority;
    int id;
    int options;
    FUNCPTR entryAddress;
    int stacksize;
    int arg1;
    int arg2;
    int arg3;
    int arg4;
    int arg5;
    int arg6;
    int arg7;
    int arg8;
    int arg9;
    int arg10;
    {
    char name[30];

    sprintf (name, "%s",id);

    return (taskSpawn (name, priority, options, stacksize, entryAddress,
	    arg1, arg2, arg3, arg4, arg5, arg6,
	    arg7, arg8, arg9, arg10));
    }
/*******************************************************************************
*
* spawnat -
*
* NOMANUAL
*/

int spawnat (priority,id,options,entryAddress,botOfStack,stacksize,pTcbx,
	arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10)
    int priority;
    int id;
    int options;
    FUNCPTR entryAddress;
    char *botOfStack;
    int stacksize;
    TCBX *pTcbx;	/* VRTX_TCBX *pTcbx; */
    int arg1;
    int arg2;
    int arg3;
    int arg4;
    int arg5;
    int arg6;
    int arg7;
    int arg8;
    int arg9;
    int arg10;
    {
    int tid;
    char name[30];

    sprintf (name, "%s",id);

    tid = taskCreate (name, priority, options,
		      botOfStack, stacksize, pTcbx, entryAddress,
                      arg1, arg2, arg3, arg4, arg5, arg6,
                      arg7, arg8, arg9, arg10);

    if (tid != ERROR && taskActivate (tid) == ERROR)
	tid = ERROR;

    return (tid);
    }
/*******************************************************************************
*
* fppGetTaskRegs -
*
* NOMANUAL
*/

fppGetTaskRegs (pTcb,fpregs,pFpcr,pFpsr,pFpiar)
	VRTX_TCB *pTcb;
	{
	return (fppTaskRegsGet (pTcb->tcb_id,fpregs,pFpcr,pFpsr,pFpiar));
	}
/*******************************************************************************
*
* fppSetTaskRegs -
*
* NOMANUAL
*/

fppSetTaskRegs (pTcb,fpregs,fpcr,fpsr,fpiar)
	VRTX_TCB *pTcb;
	{
	return (fppTaskRegsSet (pTcb->tcb_id,fpregs,fpcr,fpsr,fpiar));
	}
/*******************************************************************************
*
* fppPrintRegs -
*
* NOMANUAL
*/

fppPrintRegs (pTcb)
	VRTX_TCB *pTcb;
	{
	return (fppTaskRegsShow (pTcb->tcb_id));
	}
/*******************************************************************************
*
* vxSetTaskRegs -
*
* NOMANUAL
*/

vxSetTaskRegs (pTcb,dregs,aregs,sp,sr,pc)
	VRTX_TCB *pTcb;
	{
	return (taskRegsSet (pTcb->tcb_id,dregs,aregs,sp,sr,pc));
	}
/*******************************************************************************
*
* vxTaskRegs -
*
* NOMANUAL
*/

VOID vxTaskRegs (pTcb, dregs, aregs, sp, sr, pc)
    VRTX_TCB *pTcb;       /* TCB of task to get info about */
    int dregs[];        /* buffer for data registers 0 - 7 */
    int aregs[];        /* buffer for address registers 0 - 6 */
    char **sp;          /* buffer for stack pointer */
    USHORT *sr;         /* buffer for status register */
    INSTR **pc;         /* buffer for program counter */

    {
    taskRegsGet (pTcb->tcb_id, dregs, aregs, sp, sr, pc);
    }
/*******************************************************************************
*
* vxGetTaskRegs -
*
* NOMANUAL
*/

VOID vxGetTaskRegs (pTcb, dregs, aregs, sp, sr, pc)
    VRTX_TCB *pTcb;       /* TCB of task to get info about */
    int dregs[];        /* buffer for data registers 0 - 7 */
    int aregs[];        /* buffer for address registers 0 - 6 */
    char **sp;          /* buffer for stack pointer */
    USHORT *sr;         /* buffer for status register */
    INSTR **pc;         /* buffer for program counter */

    {
    taskRegsGet (pTcb->tcb_id, dregs, aregs, sp, sr, pc);
    }
/*******************************************************************************
*
* vxPrintRegs -
*
* NOMANUAL
*/

vxPrintRegs (pTcb)
	VRTX_TCB *pTcb;
	{
	return (taskRegsShow (pTcb->tcb_id));
	}
/*******************************************************************************
*
* vxSetTaskSR -
*
* NOMANUAL
*/

vxSetTaskSR (pTcb,sr)
	VRTX_TCB *pTcb;
	{
	return (taskSRSet (pTcb->tcb_id,sr));
	}
/*******************************************************************************
*
* vxAddTaskVar -
*
* NOMANUAL
*/

vxAddTaskVar (pVar)
	{
	return (taskVarAdd (taskIdCurrent,pVar));
	}
/*******************************************************************************
*
* vxDelTaskVar -
*
* NOMANUAL
*/

vxDelTaskVar (pVar)
	{
	return (taskVarDelete (taskIdCurrent,pVar));
	}

/********************************************************************************
* fioSetIn - assign standard input (obsolete)
*
* NOMANUAL
*/
 
VOID fioSetIn (fd)
    int fd;             /* fd to become standard input */
 
    {
    ioGlobalStdSet (STD_IN, fd);
    }
/********************************************************************************
* fioSetOut - assign standard output (obsolete)
*
* NOMANUAL
*/
 
VOID fioSetOut (fd)
    int fd;             /* fd to become standard output */
 
    {
    ioGlobalStdSet (STD_OUT, fd);
    }
/********************************************************************************
* fioSetErr - assign standard error (obsolete)
*
* NOMANUAL
*/
 
VOID fioSetErr (fd)
    int fd;             /* fd to become standard error */
 
    {
    ioGlobalStdSet (STD_ERR, fd);
    }
/********************************************************************************
* skipSpace - advance pointer past white space
*
* Increments the string pointer passed as a parameter to the next
* non-white-space character in the string.
*
* NOMANUAL
*/
 
VOID skipSpace (strptr)
    char **strptr;      /* pointer to pointer to string */
 
    {
    while (isspace (**strptr))
        ++*strptr;
    }
/*******************************************************************************
*
* create -
*
* NOMANUAL
*/

int create (name, mode)
    char *name;         /* Name of the file to create */
    int mode;           /* Mode in which to open the file */
 
    {
    return (creat (name, mode));
    }
/*******************************************************************************
*
* ldLoadAt -
*
* NOMANUAL
*/

STATUS ldLoadAt (fd, symFlag, loadAddress)
    int fd;                     /* fd from which to read module */
    int symFlag;                /* symbols to be added to table
                                 *   ([NO | GLOBAL | ALL]_SYMBOLS) */
    char *loadAddress;          /* address where to load
                                 *   (NONE = mem pool) */

    {
    char *pText = (loadAddress == (char *)NONE) ? LD_NO_ADDRESS : loadAddress;

    return (loadModuleAt (fd, symFlag, &pText, (char **)NULL, (char **)NULL));
    }
/*******************************************************************************
*
* memStat -
*
* NOMANUAL
*/

memStat ()
    {
    memShow (0);
    }
/*******************************************************************************
*
* memList -
*
* NOMANUAL
*/

memList ()
    {
    memShow (1);
    }
/*******************************************************************************
*
* movbuf -
*
* NOMANUAL
*/

VOID movbuf (to_buf, from_buf, nbytes)
    char *to_buf;
    char *from_buf;
    int nbytes;
    {
    bcopy (from_buf, to_buf, nbytes);
    }
/*******************************************************************************
*
* vxSetTaskBreakable -
*
* NOMANUAL
*/

VOID vxSetTaskBreakable (tid, breakable)
    int tid;
    BOOL breakable;
    {
    taskOptionsSet (tid, VX_UNBREAKABLE, (breakable ? VX_UNBREAKABLE : 0));
    }
/*******************************************************************************
*
* vxTaskTcb -
*
* NOMANUAL
*/

VRTX_TCB *vxTaskTcb (tid)
    int tid;
    {
    extern VRTX_TCB *taskTcb ();

    return (taskTcb (tid));
    }
/*******************************************************************************
*
* atof -
*
* RETURNS:
*      0 if no conversion, otherwise
*      1 (doesn't return number of chars eaten)
*
* NOMANUAL
*/

int atof (s, fptr,width)
    char *s;
    double *fptr;
    int width;
    {
    return (sscanf (s, "%lf", fptr));
    }
/********************************************************************************
* atow - get a word from an ASCII string
*
* This routine copies a sequence of non-white space characters from
* string `line' to `word', terminating the string with a null. Copying
* starts at the first non-space character in `line', and continues until
* white space or EOS is found, or maxchars characters have been copied.
* If maxchars == 0 then the number of characters consumed is limited
* only by reaching EOS.
*
* RETURNS: The number of characters consumed.
*
* NOMANUAL
*/
 
int atow (line, word, maxchars)
    char line [];       /* ASCII string to crack                */
    char *word;         /* where to return next word            */
    int maxchars;       /* max. number of characters to consume */
                        /* 0 = until EOS                        */
 
    {
    int iw = 0;         /* index into line */
    int il = 0;         /* index into word */
 
    while (isspace (line [il]))
        il++;
 
    while (!isspace (line [il]) && line [il] != EOS &&
           (iw < maxchars || maxchars == 0))
        {
        word [iw++] = line [il++];
        }
 
    word [iw] = EOS;
 
    return (il);
    }    
/********************************************************************************
* atos - get a sub-string from an ASCII string
*
* This routine copies from line to buf.  It stops copying when maxchars
* chars have been copied, when end of file is reached, or when it encounters
* a char in line which is not in the string charsAllowed.  buf will be NULL
* terminated.
*
* The charsAllowed string should be of the form "[...]".  All chars in
* the brackets are part of the set of "allowed" chars will be copied.
* Sequences, of the form "a-z", or "0-9" are also allowed.  If the first
* char following the left bracket is "^", the set is negated.  In that
* case, chars will be copied until a char is found that is in charsAllowed.
*
* This routine will not automatically terminate copying when a newline is
* reached.
*
* RETURNS: the number of chars copied.
*
* NOMANUAL
*/
 
int atos (line, charsAllowed, buf, maxchars)
    FAST char *line;            /* The string to look in */
    FAST char *charsAllowed;    /* The chars (not) allowed in the string */
    FAST char *buf;             /* Where to copy the string to */
    int maxchars;               /* max chars to copy (if != 0) */
 
    {
    FAST int i;
    FAST char lastChar=0;               /* assignment to appease lint */
    char charsAllowedTbl [128];
    BOOL complemented = FALSE;
 

    /* Look at charsAllowed.  For each char allowed, set it equal to TRUE
       in charsAllowedTbl */
 
    if (*charsAllowed == '[')           /* skip past the [ */
        charsAllowed++;
 
    if (*charsAllowed == '^')           /* It's the negated case */
        {
        charsAllowed++;                 /* skip past ^ */
        complemented = TRUE;
        }
 
    for (i = 0; i < sizeof (charsAllowedTbl); i++)
        charsAllowedTbl [i] = FALSE;
 
    /* Check for the first char of the set being '-' or ']', in which case
       they are not special chars. */
 
    while ((*charsAllowed == ']') || (*charsAllowed == '-'))
        {
        charsAllowedTbl [*charsAllowed] = TRUE;
        charsAllowed++;
        }
 
    /* Examine the rest of the set, and put it into the table. */
 
    while (*charsAllowed != ']')
        {
        if (*charsAllowed == '-')
            {
            /* Its of the form x-y.  If x<y, then allow all chars in the
               range.  If x>=y, its not a legal range.  Just allow '-'.
               Also, if the '-' is the last char before the final ']',
               just allow '-'. */
 
            if ((lastChar < *(charsAllowed+1)) && (*(charsAllowed+1) != ']'))
                {
                charsAllowed++;
                for (i = lastChar; i <= *charsAllowed; i++)
                    charsAllowedTbl [i] = TRUE;
                charsAllowed++;
                continue;
                }
            }
        charsAllowedTbl [*charsAllowed] = TRUE;
        lastChar = *charsAllowed;
        charsAllowed++;
        }
 
    /* Complement the table, if appropriate */
 
    if (complemented)
        {
        for (i = 0; i < sizeof (charsAllowedTbl); i++)
            charsAllowedTbl [i] = !charsAllowedTbl [i];
        }
 
    /* Copy the appropriate portion of the string */
 
    for (i = 0;
            (charsAllowedTbl [line [i]] && ((i < maxchars) || (maxchars == 0)));            i++)
        {
        buf [i] = line [i];
        }
 
    buf [i] = EOS;
    return (i);
    }
/********************************************************************************
* atoi - convert an ASCII string to an integer
*
* This routine converts an ASCII string, in character buffer `s', and
* using the specified base, to an integer.
* The integer is returned in the location pointed to by `nptr'.
* A maximum of `width' characters is used, with zero implying no limit.
* Atoi recognizes an optional string of spaces,
* then an optional sign, then a string of digits.
* The first unrecognized character ends the string.
*
* NOTE: Not UNIX compatible.
*
* RETURNS: The number of characters consumed.
*
* NOMANUAL
*/
 
int atoi (s, base, nptr, width)
    char s [];          /* ASCII string                          */
    int base;           /* number base (10 for dec., 16 for hex) */
    int *nptr;          /* where to put converted integer        */
    int width;          /* max. number of characters to consume  */

    {
    BOOL neg;   /* negative or positive? */
    int dig;    /* digit at i'th position */
    int i = 0;  /* index into string */
    int j = 0;  /* present used width */
    int n = 0;  /* buffer for building number */

    /* skip white stuff */

    while (isspace (s [i]))
        i++;

    neg = (s [i] == '-');

    /* skip over sign */

    if (neg || s [i] == '+')
        i++;

    dig = digtobin (s [i]);

    for (; (0 <= dig) && (dig < base) && (j < width || width == 0); j++)
        {
        n = (n * base) + dig;
        dig = digtobin (s [++i]);
        }

    *nptr = neg ? -n : n;

    return (i);
    }
/*******************************************************************************
*
* digtobin -
*
* NOMANUAL
*/

int digtobin (digit)
    char digit;
    {
    if (isdigit (digit))
        return (digit - '0');
 
    else if (islower (digit))
        return (digit - 'a' + 10);

    else if (isupper (digit))
        return (digit - 'A' + 10);

    else
        return (-1);
    }
/*******************************************************************************
*
* bcdtoi - 
*
* NOMANUAL
*/

int bcdtoi (bcd)
    UTINY bcd;
    {
    return ((bcd & 0x0f) + (10 * (int)((bcd >> 4) & 0x0f)));
    }
/*******************************************************************************
*
* itobcd - 
*
* NOMANUAL
*/

int itobcd (number)
    short number;
    {
    short i   = 0;
    short bcd = 0;

    while (number != 0)
	{
	bcd |= (number % 10) << i;

	number /= 10;
	i += 4;
	}

    return (bcd);
    }
#endif	LINT
