/* mz7122/config.h - Mizar mz7122 and mz7124 configuration header */

/* Copyright 1988, Mizar Digital Systems, Inc. */

/*
modification history
--------------------
*/

/*
This module contains the parameters that define the configuration for
VxWorks on the Mizar mz7122 and mz7124.
*/

#ifndef INCconfigh
#define INCconfigh

#include "mz7122.h"

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */

#define	WHICH	0	/* 0=WRS,1=MIZAR,2=MIZARBP,3=MIZARAA */

#if (WHICH == 0)
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/mz7122/vxWorks h=90.0.0.2 e=90.0.0.57 u=target"
#endif	WHICH_WRS
#if (WHICH == 1)
#define DEFAULT_BOOT_LINE \
"enp(0,0)mizar:/usr/vw/config/mz7122/vxWorks e=192.33.35.122 h=192.33.35.10 b=122.1 u=vw"
#endif	WHICH_MIZAR
#if (WHICH == 2)
#define DEFAULT_BOOT_LINE \
"bp(0,1)mizar:/usr/vw/config/mz7122/vxWorks b=122.2 g=122.1 h=192.33.35.10 u=vw"
#endif	WHICH_MIZARBP
#if (WHICH == 3)
#define DEFAULT_BOOT_LINE \
"enp(0,0)aaec1:/usr/gray/vw/config/mz7122/vxWorks e=192.9.200.4 h=192.9.200.1 u=mmw"
#endif	WHICH_MIZARAA

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */
/******************************************************************************/

#define FREE_RAM_ADRS		(&end)	/* start right after bss of UniWorks */	

#define MAX_TASKS		25	/* maximum # of tasks in system */

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define ROOT_STACK_SIZE		5000	/* size of root's stack, in bytes */
#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 file open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_SHELL		/* command shell */
#define	INCLUDE_RLOGIN		/* remote login */
#define INCLUDE_TELNET		/* telnet-style remote login */
#define INCLUDE_RPC		/* rpc package */
#define INCLUDE_NFS		/* nfs package */
#define INCLUDE_FLOATING_POINT	/* floating point I/O */
#define INCLUDE_MC68881		/* MC68881/2 float point proc */
#define	INCLUDE_STDIO		/* standard I/O */
#define	INCLUDE_RT11		/* RT-11 file system */
#define	INCLUDE_RAMDRV		/* ram disk driver */
#define INCLUDE_DEBUG		/* native debugging */
#define	INCLUDE_TIMEX		/* timexLib for exec timing */
#define	INCLUDE_SPY		/* spyLib for task monitoring */
#define	INCLUDE_1.5COMPAT		/* 1.5 compatibility routines */
#define	INCLUDE_RAM		/* RAM pseudo-disk driver */
#define	INCLUDE_DBX		/* DBX debugger */

/* included hardware support */

#define INCLUDE_BP		/* include backplane net interface */
#define INCLUDE_ENP		/* include CMC Ethernet interface*/

/* excluded hardware support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define INCLUDE_VB		/* include isi backplane net interface*/
#define INCLUDE_HM		/* include isi backplane net interface*/
#define	INCLUDE_TS		/* TC50 half-inch tape driver */
#define	INCLUDE_SM		/* Interphase SMD controller */
#define INCLUDE_IE		/* include Sun Ethernet interface*/
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE

/* excluded facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*#define INCLUDE_FORTRAN*/
#define INCLUDE_PASCAL		/* support for Pascal */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_UNIWORKS		1	/* trap 1 - UniWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */


/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/* Default NFS parameters */

#define NFS_USER_ID	2001
#define NFS_GROUP_ID	100


#if	FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			/* optional facilities */

#define	INCLUDE_MZ7810			/* support for Mizar daughter card with
					   2 serial/1 parallel port */
#define	INCLUDE_MZ7830			/* support for Mizar daughter card with
					   SCSI interface */

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif


/* Device controller I/O addresses:
 * MZ7122/4 board requires the top bits 0xff000000 to be set.
 * Also, the Excelan cannot appear at 0x00ff0000.
 */

#define	IO_ADRS_EX	((char *) 0xff7f0000)	/* 24A,32D Excelan Ethernet */
#define	IO_ADRS_ENP	((char *) 0xffde0000)	/* 24A,32D CMC Ethernet */
#define	IO_ADRS_IE	((char *) 0xff300000)	/* 24A,32D Sun Ethernet */
#define	IO_ADRS_NW	((char *) 0xfff80000)	/* 24A,32D ISI Ethernet */
#define	IO_ADRS_PN	((char *) 0xff100000)	/* 24A,32D Proteon ProNet */


/* interrupt and system trap vectors */

#define INT_VEC_MISC		(IV_AUTOVEC_7)
#define INT_VEC_SIRQ		(IV_AUTOVEC_6)
#define INT_VEC_MBOX		(IV_AUTOVEC_5)
#define INT_VEC_DCARD		(IV_AUTOVEC_4)
#define INT_VEC_HBTIMER		(IV_AUTOVEC_3)
#define INT_VEC_SOFT_INT2	(IV_AUTOVEC_2)
#define INT_VEC_SOFT_INT1	(IV_AUTOVEC_1)


/* backplane network parameters */
/*
 * Mailbox addresses for Mizar boards are defined by 8 bits in the bus latch.
 * We set the high order 3 bits to one and use the five low order bits to
 * define the address based on the processor number:
 *
 * processor #:       VME short I/O address:
 *     0                   0x8000
 *     1                   0x8001
 *     2                   0x8002
 *     etc ...
 */

#define	BP_OFF_BOARD	FALSE

#if	BP_OFF_BOARD
#define BP_ANCHOR_ADRS	((char *) (0xff800000))	/* off-board anchor adrs */
						/* mz7122/24 does dual port
						 * on-board memory */
						/* note this is in A24 space */
#else
#define	BP_ANCHOR_ADRS	((char *) (0x00000600))	/* on-board anchor adrs */
#endif	BP_OFF_BOARD

#define BP_INT_TYPE	BP_INT_MAILBOX_2	/* mailbox interrupt:
						 * 16 bit write */
#define BP_INT_ARG1	VME_AM_SUP_SHORT_IO	/* bus address space */
#define BP_INT_ARG2	(sysMailboxAddressSet())/* define and return
						 * bus address */
#define BP_INT_ARG3	0			/* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#if	BP_OFF_BOARD
#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x40000		/* 256K */
#else
#define BP_MEM_ADRS	NONE		/* NONE = allocate from memory pool */
#define BP_MEM_SIZE	0x10000		/* 64K */
#endif	BP_OFF_BOARD

/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The mz7122/24 local memory always appears at 0x00000000 locally.
 */

#define LOCAL_MEM_LOCAL_ADRS		MZ_RAM_BASE_ADRS
#define LOCAL_MEM_BUS_ADRS		0x00400000	/* arbitrary */

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS			MZ_ROM_BASE_ADRS

#endif	INCconfigh
