/* dy4_134.h - DY4-134 CPU board header file */

/*
modification history
--------------------
02a,29apr88,gae  added BUS and CPU constants.
		 moved MFP defintions to m68901.h.
01c,04nov87,jcf	 changed the location monitor base address to correct value.
01b,05oct87,jcf	 cleaned up for new release
01a,13jul87,jcf	 written by modifying the hkv2f version 01c. 
*/

/*
This file contains I/O address and related constants for
VxWorks on the DY4-134.
*/

#ifndef	INCdy4_134h
#define	INCdy4_134h

#include "m68901.h"

#define TARGET_DY4_134

#define BUS		VME_BUS
#define CPU		MC68020

#define DY4_RAM_BASE_ADRS	0x00000000	/* first on-card RAM address */

/* control and status register stuff */

#define DY4_SR		((short *) 0xfffd0000)	/* the status register */
#define DY4_CR		((short *) 0xfffd4000)	/* the control register */
#define DY4_LMF		((char *)  0xfffd8000)	/* the location monitor FIFO */
#define DY4_SYSRES	((char *)  0xfffdc000)	/* software system reset */
#define DY4_NO_BI	((short *) 0x000ffff2)	/* an odd word in the LM */

/* masks for local I/O */

#define CR_INIT		0xffa9			/* parity is disabled for now */

/* interrupt vector locations */

#define PARITY_ERROR_VEC_NUM	31		/* parity error vector number */
#define MFP_INT_VECT_NUM	0x40		/* MFP int. vector base num */

#define MFP_MBOX_INT		0x04	/* mbox interrupt mask and enable */


/*
 * Motorola MC68901 MFP (Multi-Function Peripheral)
 */

#define	MFP_BASE_ADR	0xfffe0000

#endif	INCdy4_134h
