/* intALib.s - interrupt library assembly language routines */

	.data
	.asciz	"Copyright 1984-1988, Wind River Systems, Inc."

/*
modification history
--------------------
*/

/*
DESCRIPTION

These routines are used to support various functions associated with
interrupts from C.

intLevelSetVBR (2) changes the vector base register on the 68020.

intSet (2) changes the current interrupt level of the processor.

SEE ALSO
intLib (1)

INTERNAL
Some routines in this module "link" and "unlk" the "c" frame pointer
(a6) although they don't use it in any way!  This is only for the benefit of
the stacktrace facility to allow it to properly trace tasks executing within
these routines.

*/

#define ASMLANGUAGE
#include "asm.h"

	.text
	.even

	/* internal */

	.globl	_intSet
	.globl	_intSetVBR
	.globl	_intGetVBR

	/* external */

/***********************************************************************
*
* intSet - set interrupt level
*
* This routine changes the interrupt mask in the status register to take
* on the value specified by level.  It is strongly advised that the level
* be in the range 0 - 7.
*
* Setting interrupts involves privelaged instructions, so user level tasks
* must trap to supervisor level before executing this routine.
* This routine should only be called in supervisor mode.
*
* RETURNS: Old interrupt level, 0 - 7.
*
* SEE ALSO: sysVwTrap (2).

* int intSet (level)
*     int level;	/* new interrupt level mask, 0 - 7 *

*/

_intSet:
	link	a6,#0
	movew	sr,d0		/* get old sr into d0 */
	andw	#0xf8ff,d0	/* clear interrupt mask in saved sr */
	movel	a6@(ARG1),d1	/* get new level into d1 */
	andl	#0x7,d1		/* clear all but interrupt mask */
	lslw	#8,d1		/* get level into high order byte */
	orw	d0,d1		/* combine with saved status reg contents */
	movew	sr,d0		/* remember status register */
	movew	d1,sr		/* set status register */

	lsrw	#8,d0		/* shift interrupt level to low bits */
	andl	#0x7,d0		/* clear all but interrupt mask */
	unlk	a6
	rts

/***************************************************************************
*
* intSetVBR - set the vector base register
*
* This routine should only be called in supervisor mode.
* It is not used on the M68000.
*
* NOMANUAL

* VOID intSetVBR (baseAddr)
*      FUNCPTR *baseAddr;	/* vector base address *

*/

_intSetVBR:
	movel	sp@(4),d0
	movec	d0,vb
	rts


_intGetVBR:
	movec	vb,d0
	rts
