/* if_nw.c - the isi ethernet card driver */

static char *copyright = "Copyright 1988, Wind River Systems, Inc.";

/*
modification history
--------------------
*/
 
#include "UniWorks.h"
#include "param.h"
#include "mbuf.h"
#include "protosw.h"
#include "ioctl.h"
#include "socket.h"
#include "errno.h"
#include "uio.h"
#include "if.h"
#include "route.h"
#include "iv68k.h"
#include "systm.h"

#ifdef	INET
#include "in.h"
#include "in_systm.h"
#include "in_var.h"
#include "ip.h"
#include "ip_var.h"
#include "if_ether.h"
#endif	INET

#ifdef	NS
#include "../netns/ns.h"
#include "../netns/ns_if.h"
#endif	NS

#ifdef	TRFS
#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"
#include "../wipc/wipc_pklink.h"
#define	PKLEN		(nwmtu - 32 - 4)
#define	PKBURST		10
#endif	TRFS

#ifdef	APPLETALK
#include "../netddp/atalk.h"
#include "../netddp/katalk.h"
#include "../netddp/aarp.h"
#endif	APPLETALK

#ifdef	ENETFILTER
#include "../is68kif/enet.h"
#endif	ENETFILTER

#include "if_nwreg.h"

IMPORT VOID ipintr ();

#define	NWMTU	ETHERMTU	/* NWMAXMTU */

#define NNW	1	/* max number of nw boards */

int nwmtu = NWMTU;

extern char vme_std[];

u_short *nwstd[] = {
	(u_short *) &vme_std[0xF80000],
	(u_short *) &vme_std[0xF40000],
	0};

/* forward declarations */

int nwprobe();
int nwattach();
int nwintr();
int nwinit();
int nwioctl();
int nwoutput();
int nwreset();
int nwwatch();
LOCAL VOID nwHandleInput ();
struct	mbuf *nwget();
u_short	nwdata();

#ifdef	TRFS
int	nw_xmit(), nw_relse();
#endif	TRFS


/*
 * Ethernet software status per interface.
 * Each interface is referenced by a network interface structure,
 * ns_if, which the routing code uses to locate the interface.
 */
struct	nw_softc 
    {
    struct	arpcom	ns_ac;		/* common ethernet structures */
#define ns_if		ns_ac.ac_if	/* network-visible interface */
#define ns_addr		ns_ac.ac_enaddr	/* hardware ethernet address */
    struct nwdevice	*ns_nwp;	/* virtual address of dual ported ram */
    short		ns_vector;	/* configured vector */
    u_int		ns_stat[NUMBER_OF_STATS]; /* soft statistics */
    unsigned char	ns_promiscuous;	/* state of promisc mode */
#define 	PROM_OFF 	 0
#define 	PROM_ON 	 1
#define 	PROM_OFF_PENDING 2
    char		ns_ipend;	/* need to ack probe interrupt */
    struct bcb	*ns_cmd_pkt;	/* cmdpkt ack awaiting processing */
    struct ring	*ns_tonw;	/* pointers to rings */
    struct ring	*ns_nwfree;
    struct ring	*ns_tohost;
    struct ring	*ns_hostfree;
    short		ns_enetunit;	/* ENET: unit number for filtering */
    short		ns_enetinit;	/* ENET: interface is initialized */
    unsigned char	ns_ix;		/* TRFS: */
    unsigned char	ns_atnode;	/* APPLETALK: assigned node number */

	/* Wind River Extensions */

    int ivec;
    int	ilevel;
    } nw_softc[NNW];

#ifdef	RFS
extern struct ifqueue rfsintrq;
#endif	RFS

/*********************************************************************
*
* nwprobe - reset nw board
*
* nwprove resets the nw board and waits for the onboard diagnostics
* to complete.  It also sets up some local data structures including
* the board's hardwired ethernet address.
*/

LOCAL VOID nwprobe(nwp, unit, ivec)
    struct nwdevice *nwp;
    int unit;
    int ivec;

    {
    struct nw_softc *ns = &nw_softc[unit];
    register int i;

    /* reset board */
    RESET_NW(nwp);
    nwp->nw_ctl_stat = CTL_STAT_RESET;
    nwp->nw_jumper  = 0xff;
    UNRESET_NW(nwp);

    /* wait for diagnostics */
    for (i = 5 * sysClkGetRate ();
	 i && (nwp->nw_ctl_stat != CTL_STAT_READY) && 
	   ((nwp->nw_jumper&0xf0) || ((nwp->nw_jumper&ACTION) == ENTER_STD));
	 i--)
	    taskDelay (1);

    /* if standard firmware, start the board, then wait */
    nwp->nw_ivector = ns->ns_vector = ivec;
    if ((nwp->nw_jumper&ACTION) == ENTER_STD) 
	{
	if (nwp->nw_ctl_stat != CTL_STAT_READY) 
	    {
	    printf("   NW%d  failed selftest %d\n", unit, 
		    nwp->nw_testno);
	    return (0);
	    }
	nwp->nw_ipend_tohost = 0;
	GO_NW(nwp);
	taskDelay (sysClkGetRate () / 2);

	ns->ns_ipend = 1;	/* remember to ack the interrupt */
	if (nwp->nw_base_addr != (int)nwp) 
	    {
	    printf("   NW%d  failed long access, rejumper CPU\n", unit);
	    return(0);
	    }
	if (nwp->nw_version == NW_VERSION_OLD) 
	    {
	    printf("   NW%d  firmware rev not supported\n", unit);
	    return(0);
	    }
	}

    ns->ns_nwp = nwp;
    ns->ns_tonw = nwp->nw_tonw;
    ns->ns_tohost = nwp->nw_tohost;
    ns->ns_nwfree = nwp->nw_nwfree;
    ns->ns_hostfree = nwp->nw_hostfree;
    bcopy((char *)nwp->nw_etheraddr, (char *)ns->ns_addr, sizeof (ns->ns_addr));
    return sizeof(struct nwdevice);
    }
/*********************************************************************
*
* nwattach - attach the nw driver to the network
*
* nwattach connects the nw ISR (nwintr), sets up nwsoftc and attaches
* the interface.
*/

STATUS nwattach (unit)
    int unit;
    {
    int ivec;
    int ilevel;
    struct nw_softc *ns = &nw_softc[unit];
    register struct nwdevice *nwp;
    register struct ifnet *ifp = &ns->ns_if;

    nwp = (struct nwdevice *) nwstd[unit];
    ivec = freevec();
    ilevel = 4;
    intConnect(INUM_TO_IVEC (ivec), nwintr, unit);
    sysIntEnable (ilevel);

    nwprobe (nwp, unit, ivec);    

    ns->ivec = ivec;
    ns->ilevel = ilevel;
    ifp->if_unit = unit;
    ifp->if_name = "nw";
    ifp->if_mtu = nwmtu;
    ifp->if_flags = IFF_BROADCAST;
    ifp->if_init = nwinit;
    ifp->if_ioctl = nwioctl;
    ifp->if_output = nwoutput;
    ifp->if_reset = nwreset;
    if_attach(ifp);
#ifdef	TRFS
    ns->ns_ix = IfaceAttach(ifp->if_unit, nw_xmit, nw_relse,
	    PKLEN, PKBURST, etherbroadcastaddr, sizeof(ns->ns_addr));
#endif	TRFS
#ifdef	RFS
    RfsAttach(ifp, &ns->ns_ac);
#endif	RFS

    return (OK);
    }
/*********************************************************************
* 
* nwreset - reset the nw board
*
* nwreset resets the nw board and marks the interface as not running.
*
*/

LOCAL VOID nwreset(unit)
    int unit;

    {
    FAST struct nw_softc *ns = &nw_softc[unit];
    FAST struct nwdevice *nwp = ns->ns_nwp;

    RESET_NW(nwp);
    nwp->nw_ctl_stat = CTL_STAT_RESET;
    UNRESET_NW(nwp);
    ns->ns_if.if_flags &= ~IFF_RUNNING;
    }
/*********************************************************************
*
* nwinit - initialize the interface
* 
* nwinit throws out all unprocessed packets in the ring buffer and
* marks the interface as up.
*
*/

LOCAL VOID nwinit(unit)
    int unit;

    {
    FAST struct nw_softc *ns = &nw_softc[unit];
    FAST struct ifnet *ifp = &ns->ns_if;
    FAST struct bcb *bcbp;
    FAST int s;

    if (ns->ns_ipend) 
	{		/* ack the probe interrupt */
	ns->ns_ipend = 0;
	ns->ns_nwp->nw_ipend_tohost = 0;
	}

    s = splnet ();
    while (bcbp = (struct bcb *)nwringget(ns->ns_tohost))
	    nwringput(ns->ns_nwfree, bcbp);
    splx (s);
#ifndef	TRFS
    /* not yet, if address still unknown */
    if (ifp->if_addrlist == (struct ifaddr *)0)
	    return;
#endif	TRFS

    ifp->if_flags |= IFF_RUNNING;
#ifdef	ENETFILTER
    if (!ns->ns_enetinit) 
	{
	struct endevp enp;

	ns->ns_enetinit++;
	enp.end_dev_type = ENDT_10MB;
	enp.end_addr_len = sizeof(ns->ns_addr);
	enp.end_hdr_len = sizeof(struct ether_header);
	enp.end_MTU = nwmtu;
	bcopy(ns->ns_addr, enp.end_addr, sizeof(ns->ns_addr));
	bcopy(etherbroadcastaddr,enp.end_broadaddr,sizeof(ns->ns_addr));
	ns->ns_enetunit = enetattach(ifp, &enp);
	}
#endif	ENETFILTER
    }
/*********************************************************************
*
* nwintr - the nw ISR
* 
* nwintr reads packets from its input queue and hands them to nwHandleInput
* via netTask (nwHandleInput must be called from task level)
*/

LOCAL VOID nwintr (unit)
    {

    FAST struct nw_softc *ns = &nw_softc[unit];
    FAST struct bcb *bcbp;

    ns->ns_nwp->nw_ipend_tohost = 0;		/* ack interrupt */
    while (bcbp = (struct bcb *)nwringget (ns->ns_tohost)) 
	netToDoAdd (nwHandleInput, ns, bcbp);
    }
/*********************************************************************
*
* nwHandleInput - handle input packet
*/

LOCAL VOID nwHandleInput (ns, bcbp)
    struct nw_softc *ns;
    struct bcb *bcbp;

    {
    nwread (ns, bcbp);
    nwringput (ns->ns_nwfree, bcbp);
    }
/*********************************************************************
*
* nwread - read a packet off the board
*
*/

LOCAL int nwread(ns, bcbp)
    FAST struct nw_softc *ns;
    FAST struct bcb *bcbp;

    {
    FAST struct ifnet *ifp = &ns->ns_if;
    FAST struct ether_header *eh;
    FAST struct mbuf *m;
    int len, off, resid, s;
    register struct ifqueue *inq;

    ns->ns_if.if_ipackets++;

    /* pass command packet to sleeping user ioctl, let ioctl free packet */

    if (bcbp->b_type == BCB_TYPE_COMMAND) 
	{
	ns->ns_cmd_pkt = bcbp;
	/*XXX wakeup((caddr_t) &(ns->ns_cmd_pkt)); */
	panic ("nwread: got BCB_TYPE_COMMAND.\n");
	return(1);	
	}

    eh = (struct ether_header *)bcbp->b_addr;
    len = nwlen(bcbp) - sizeof(struct ether_header);
    eh->ether_type = ntohs((u_short)eh->ether_type);

#ifdef	TRFS
    if (eh->ether_type == ETHERTYPE_WIPC)
	    return !nw_recv(ns - nw_softc, bcbp);
#endif	TRFS
    if (eh->ether_type >= ETHERTYPE_TRAIL &&
	eh->ether_type < ETHERTYPE_TRAIL+ETHERTYPE_NTRAILER) 
	{
	if ((off = (eh->ether_type - ETHERTYPE_TRAIL)*512) >= nwmtu)
	    return 0;			/* sanity */
	eh->ether_type = ntohs(nwdata(bcbp, off));
	resid = ntohs(nwdata(bcbp, off + sizeof(u_short)));
	if (off + resid > len)
	    return 0;			/* sanity */
	len = off + resid;
	} 
    else
	off = 0;
    if (len == 0)
	return 0;
    /*
     * Pull all bcb's in the packet off interface. Off is nonzero if 
     * packet has trailing header; nwget will then force this header 
     * information to be at the front and drop the type and length at the 
     * head of trailers.
     */
    if ((m=nwget(bcbp, len, off, sizeof(struct ether_header), ifp))==0)
	return 0;

    switch ((int)eh->ether_type) 
	{
#ifdef INET
	case ETHERTYPE_IP:
	    netToDoAdd (ipintr, 0);
	    inq = &ipintrq;
	    break;

	case ETHERTYPE_ARP:
	    arpinput(&ns->ns_ac, m);
	    return 0;
#endif
#ifdef NS
	case ETHERTYPE_NS:
	    schednetisr(NETISR_NS);
	    inq = &nsintrq;
	    break;

#endif
#ifdef	RFS
	  case ETHERTYPE_RFS:
	    schednetisr(NETISR_RFS);
	    inq = &rfsintrq;
	    break;
#endif
#ifdef	APPLETALK
	case ETHERTYPE_AARP:
	    aarpinput(&ns->ns_ac, m);
	    return 0;

	case ETHERTYPE_APPLETALK:
	    if (ns->ns_atnode) {
		    ddp_setifp(ifp, ns->ns_atnode);
		    schednetisr(NETISR_DDP);
		    inq = &ddpintq;
		    break;
	    }
	    /* fall thru */
#endif	APPLETALK
	default:
#ifdef	ENETFILTER
	    if (ns->ns_enetinit && ns->ns_enetunit >= 0) {
		    register struct mbuf *mtop;

		    /*
		     * We need the local net header after all. Oh well,
		     * this could be improved.
		     */
		    MGET(mtop, M_DONTWAIT, MT_DATA);
		    if (mtop) {
			    /* undo the swap done earlier */
			    eh->ether_type = htons((u_short)eh->ether_type);
			    bcopy((struct ether_header*)eh->ether_dhost,
				    mtod(mtop, struct ether_header *),
				    sizeof(struct ether_header));
			    mtop->m_len = sizeof(struct ether_header);
			    /* remove interface pointer */
			    m->m_len -= sizeof(ifp);
			    m->m_off += sizeof(ifp);
			    mtop->m_next = m;
			    enetFilter(ns->ns_enetunit, mtop,
				    (len + sizeof(struct ether_header)) );
			    return 0;
		    }
	    }
#endif	ENETFILTER
	m_freem(m);
	return 0;
	}
    s = splimp();
    if (IF_QFULL(inq)) 
	{
	IF_DROP(inq);
	m_freem(m);
	} 
    else
	IF_ENQUEUE(inq, m);

    splx(s);
    return 0;
    }
/*********************************************************************
*
* nwlen - find packet length given bcb chain, drop off the CRC 
*
*/

LOCAL int nwlen(bcbp)
    FAST struct bcb *bcbp;

    {
    FAST int len = 0;
    FAST struct bcb *last_bcbp = 0;

    while (bcbp) 
	{
	len += bcbp->b_msglen;
	last_bcbp = bcbp;
	bcbp = bcbp->b_link;
	}

    if (last_bcbp) 
	{
	last_bcbp->b_msglen -= CRCLENGTH;
	len -= CRCLENGTH;
	}
    return len;
    }
/*********************************************************************
*
* nwdata - return the packet data (short) in bcb chain at the given offset 
*
*/

LOCAL u_short nwdata(bcbp, off)
    FAST struct bcb *bcbp;
    FAST int off;

    {
    off += sizeof(struct ether_header);
    while (bcbp->b_msglen < off) 
	{
	off -= bcbp->b_msglen;
	if ((bcbp = bcbp->b_link) == 0)
	    panic("nwdata");
	}
    if ((bcbp->b_msglen - off) > sizeof(short))
	return *((u_short *)(bcbp->b_addr + off));
    else
	panic("nwdataaddr");

    return (NULL);			/* keep lint happy */
    }
/***********************************************************************
*
* if_rqbget - get a mbuf
*
* Pull read data off a interface. Len is length of data without local 
* net header, hlen is length of interface header.
* We copy the trailer information and then all the normal data into mbufs.
* Prepend a pointer to the interface structure, so that protocols can 
* determine where incoming packets arrived.  
* Note: we may be called to receive from a transmit buffer by some devices.
*/

struct mbuf *if_rqbget (ifu, totlen, hlen, ifp0)
    FAST u_char *ifu;
    FAST int totlen;
    FAST int hlen;
    struct ifnet *ifp0;

    {
    FAST struct mbuf *m;
    struct mbuf *top = 0, **mp = &top;
    FAST struct ifnet *ifp = ifp0;
    FAST u_char *cp = ifu + hlen;
    FAST int len;

    while (totlen > 0)
	{
	MGET (m, M_DONTWAIT, MT_DATA);
	if (m == 0)
	    {
	    m_freem (top);
	    top = 0;
	    break;
	    }
	len = totlen;

	/* if requested, leave room for interface pointer */
	if (ifp)
	    {
	    ifp = 0;
	    m->m_len = MIN (MLEN - sizeof (ifp), len);
	    m->m_off += sizeof (ifp);
	    }
	else
	    m->m_len = MIN (MLEN, len);

	bcopy ((char *)cp, (char *)mtod (m, u_char *), (unsigned)m->m_len);
	cp += m->m_len;

	/* if no trailers, simple. */
	totlen -= m->m_len;
	*mp = m;
	mp = &m->m_next;
    }

    /* prepend interface pointer */
    if (top && ifp0)
	{
	top->m_len += sizeof (ifp);
	top->m_off -= sizeof (ifp);
	*(mtod (top, struct ifnet **)) = ifp0;
	}

    return (top);
    }
/*********************************************************************
*
* nwget - get a packet
*
* Pull read data off the bcbp0 chain of buffer control blocks and return a
* pointer to the chain of mbufs containing the data. Len is length of data 
* without local net header, hlen is length of interface header.  Off0 
* is non-zero if a trailer protocol was used, and gives the offset of the 
* trailer information. We copy the trailer information and then all the 
* normal data into mbufs using the contiguous region "if_rqbget" routine.
* The first call to if_rqbget will prepend a pointer to the interface 
* structure, so that protocols can determine where incoming packets arrived.  
*
* RETURNS - pointer to mbuf chain containing packet
*/

LOCAL struct mbuf *nwget(bcbp0, totlen, off0, hlen, ifp0)
    struct bcb *bcbp0;
    FAST int totlen;
    struct ifnet *ifp0;

    {
    FAST struct bcb *bcbp = bcbp0;
    struct mbuf *top = 0;
    FAST struct mbuf **mp = &top;
    FAST int len, off = hlen, offt = 0;

    /* if trailer, go through bcb's to start; droping trailer type/length */
    if (off0) 
	{
	offt = off0 + (2 * sizeof(u_short));
	off = offt + hlen;
	while (bcbp->b_msglen < off) 
	    {
	    off -= bcbp->b_msglen;
	    if ((bcbp = bcbp->b_link) == 0)
		goto bad;
	    }
	}

    while (totlen) 
	{
	if (bcbp == 0)
	    goto bad;
	len = MIN(totlen - offt, bcbp->b_msglen - off);
	if ((*mp = (struct mbuf *) if_rqbget((u_char *)bcbp->b_addr,
					     len, off, ifp0))
	    == 0)
	    goto bad;
	mp = &((*mp)->m_next);
	bcbp = bcbp->b_link;
	ifp0 = 0;
	off = 0;
	if (offt == 0)
	    totlen -= len;
	else 
	    if ((offt += len) == totlen) 
		{
		offt = 0;
		totlen = off0;
		off = hlen;
		bcbp = bcbp0;
		} 
	    else 
		if (offt > totlen)
		    goto bad;
	}
    return top;

bad:	
    m_freem(top);
    return 0;
    }
/*********************************************************************
*
* nwoutput - network output routine
*
* Encapsulate a packet of type family for the local net.
* Use trailer local net encapsulation if enough data in first packet leaves 
* a multiple of 512 bytes of data in remainder. If destination is this 
* address or broadcast, send packet to loop device to kludge around the fact 
* that most interfaces can't talk to themselves.
*/
LOCAL int nwoutput(ifp, m0, dst)
    struct ifnet *ifp;
    struct mbuf *m0;
    struct sockaddr *dst;

    {

    FAST struct nw_softc *ns = &nw_softc[ifp->if_unit];
    FAST struct mbuf *m = m0;
    FAST struct ether_header *eh;
    FAST int off;
    int type, error;
    u_char edst[6];
    struct in_addr idst;
    int usetrailers;
#ifdef	RFS
    extern struct ifnet loif;
    extern int useloopback;
#endif
#ifdef	APPLETALK
    struct mbuf *mcopy = (struct mbuf *)0;
    struct sockaddr_at *dat = (struct sockaddr_at *)dst;
    struct lap *lap;
    struct a_addr *appleaddr;
    int ltype, dnode;
#endif	APPLETALK

    switch( dst->sa_family ) 
	{
#ifdef INET
	case AF_INET:
	    idst = ((struct sockaddr_in *)dst)->sin_addr;
	    if (!arpresolve(&ns->ns_ac, m, &idst, edst, &usetrailers))
		    return 0;	/* if not yet resolved */
	    off = ((u_short)mtod(m, struct ip *)->ip_len) - m->m_len;
	    if (usetrailers && off > 0 && (off & 0x1ff) == 0 &&
		m->m_off >= MMINOFF + 2 * sizeof (u_short)) 
		{
		type = ETHERTYPE_TRAIL + (off>>9);
		m->m_off -= 2 * sizeof(u_short);
		m->m_len += 2 * sizeof(u_short);
		*mtod(m, u_short *) = htons((u_short)ETHERTYPE_IP);
		*(mtod(m, u_short *) + 1) = htons((u_short)m->m_len);
		goto gottrailertype;
		}
	    type = ETHERTYPE_IP;
	    off = 0;
	    goto gottype;
#endif
#ifdef NS
	case AF_NS:
	    type = ETHERTYPE_NS;
	    bcopy((caddr_t)&(((struct sockaddr_ns *)dst)->sns_addr.x_host),
		    edst, sizeof (edst));
	    off = 0;
	    goto gottype;
#endif
#ifdef	RFS
	    /*
	     * Normally we would call arpresolve directly.  But when
	     * out source and destination are the same arpresolve will
	     * pass the mbuf onto the loopback driver changing the
	     * sa_family type to AF_INET.  So we do the check here and
	     * call looutput if necessary.
	     */
	  case AF_RFS:
	    idst = ((struct sockaddr_in *)dst)->sin_addr;
	    if (idst.s_addr == ns->ns_ac.ac_ipaddr.s_addr && useloopback) {
		    (void) looutput (&loif, m, dst);
		    return (0);
	    } else if (!arpresolve(&ns->ns_ac, m, &idst, edst, 
				    &usetrailers))
		    return (0);	/* if not yet resolved */
	    type = ETHERTYPE_RFS;
	    off = 0;
	    goto gottype;
#endif
#ifdef	APPLETALK
	case AF_APPLETALK:
	    if (ns->ns_atnode == 0) {
		    error = ENETUNREACH;
		    goto bad;
	    }
	    lap = mtod(m, struct lap *);
	    lap->src = ns->ns_atnode;
	    ltype = lap->type & 0xff;
	    if (ltype == LT_DDP) { /* remote net - send it to the bridge */
		    appleaddr = ddp_getaddr(ifp);
		    if (appleaddr->at_Net)
			    lap->dst = dnode = appleaddr->at_Abridge & 0xff;
		    else
			    lap->dst = dnode = dat->at_node;
	    } else		/* local net - lap->dst already filled in */
		    dnode = lap->dst & 0xff;

	    idst.s_addr = 0L;
	    /* fake out arpresolve */
	    ((char *)(&idst))[3] = dnode;

	    if (dnode == 0xff) {		/* broadcast */
		    if ((mcopy = m_copy(m, 0, M_COPYALL)) == NULL) {
			    error = ENOBUFS;
			    goto bad;
		    }
		    bcopy((caddr_t)etherbroadcastaddr, edst, sizeof(edst));
	    } else {
		    /* can't send long ddp's to one's self */
		    if ((dnode == ns->ns_atnode)&&(ltype == LT_SHORTDDP)) {
			    mcopy = m;
			    goto gotlocal;
		    } else if (!aarpresolve(&ns->ns_ac, m, &idst,
			edst, &usetrailers))
			    return (0);	/* if not yet resolved */
	    }
	    type = ETHERTYPE_APPLETALK;
	    goto gottype;
#endif APPLETALK
	case AF_IMPLINK:
	    eh = mtod(m, struct ether_header *);
	    goto gotheader;

	case AF_UNSPEC:
	    eh = (struct ether_header *)dst->sa_data;
	    bcopy((char *)eh->ether_dhost, (char *)edst, sizeof (edst));
	    type = eh->ether_type;
	    goto gottype;

	default:
	    printf("nw%d: can't handle af%d\n", ifp->if_unit,
		    dst->sa_family);
	    error = EAFNOSUPPORT;
	    goto bad;
	}

gottrailertype:
    /* trailer: move first packet (control information) to end of chain. */
    while (m->m_next)
	    m = m->m_next;
    m->m_next = m0;
    m = m0->m_next;
    m0->m_next = 0;
    m0 = m;

gottype:
    /* Add local net header. If no space in mbuf, allocate another */
    if (m->m_off > MMAXOFF ||
	MMINOFF + sizeof(struct ether_header) > m->m_off) 
	    {
	    MGET(m, M_DONTWAIT, MT_HEADER);
	    if (m == 0) 
		{
		error = ENOBUFS;
		goto bad;
		}
	    m->m_next = m0;
	    m->m_off = MMINOFF;
	    m->m_len = sizeof(struct ether_header);
	    } 
	else 
	    {
	    m->m_off -= sizeof(struct ether_header);
	    m->m_len += sizeof(struct ether_header);
	    }
    eh = mtod(m, struct ether_header *);
    eh->ether_type = htons((u_short)type);
    bcopy((char *)edst, (char *)eh->ether_dhost, sizeof (edst));

gotheader:
    bcopy((char *)ns->ns_addr, (char *)eh->ether_shost, sizeof(ns->ns_addr));

    /* transfer message to destination input queue if possible */
    if (nwput(ns, m)) 
	{
	IF_DROP(&ifp->if_snd);
	m_freem(m);
/*		printf("nw%d: constipated transmitter\n", ifp->if_unit); /**/
	return (ENOBUFS);
	}
    ns->ns_if.if_opackets++;
#ifdef	APPLETALK
gotlocal:
    return(mcopy ? looutput(&loif, mcopy, dst) : 0);
#else	APPLETALK
    return 0;
#endif	APPLETALK

bad:	
    m_freem(m0);
    return error;
    }
/*********************************************************************
*
* nwput - Routine to copy from mbuf chain to a bcb chain for transmit 
*
*/

LOCAL int nwput(ns, m0)
    struct nw_softc *ns;
    struct mbuf *m0;

    {
    FAST struct mbuf *m = m0;
    FAST struct bcb  *bcbp, *bcbp0;
    FAST int len, offb = 0, offm = 0;
    FAST int ml, bl;

    if ((bcbp0 = bcbp = (struct bcb *)nwringget(ns->ns_hostfree)) == 0)
	return 1;
    bcbp->b_type = BCB_TYPE_DATA;
    ml = m->m_len;
    bl = bcbp->b_len;
    while (m) 
	{
	if (len = MIN(bl, ml)) 
	    {
	    bcopy((char *)mtod(m, u_char *)+offm, (char *)bcbp->b_addr+offb,
		  (unsigned)len);
	    ml -= len; offm += len;
	    bl -= len; offb += len;
	    }
	if (ml == 0) 
	    {
	    if (m = m->m_next)
		ml = m->m_len;
	    offm = 0;
	    }
	if (ml && bl == 0) 
	    {
	    if ((bcbp->b_link = (struct bcb *)nwringget(ns->ns_hostfree)) == 0) 
		{
		for (bcbp = bcbp0; bcbp; bcbp = bcbp->b_link)
		    bcbp->b_len = 0;
		if (nwringput(ns->ns_tonw, bcbp0) == 1)
		    intr_nw(ns);
		return 1;
		}
		bcbp = bcbp->b_link;
		bl = bcbp->b_len; offb = 0;
	    }
	}
    m_freem(m0);
    bcbp->b_len = offb;
    if (nwringput(ns->ns_tonw, bcbp0) == 1)
	    intr_nw(ns);
    return 0;
    }
#if FALSE
/* XXX watchdog currently not implemented */
/* Watchdog routine, get statistics from board. */
nwwatch(unit)
	int unit;
{
	register struct nw_softc *ns = &nw_softc[unit];
	register struct nwdevice *nwp = ns->ns_nwp;
	register struct ifnet *ifp = &ns->ns_if;
	register int i, msk;
	
	/* report change in condition, and update condition */
	for (i = 0, msk = 0; i < NUMBER_OF_STATS; i++)
		if (ns->ns_stat[i] != nwp->nw_stat[i]) {
			msk |= 1<<i;
			ns->ns_stat[i] = nwp->nw_stat[i];
		}
	msk &= NWSTATREPORT_MASK;
	if (msk)
		printf("nw%d: condition %b\n", unit, msk, NWSTAT_BITS);
	ifp->if_ierrors = NWSTAT_IERRORS(ns->ns_stat);
	ifp->if_oerrors = NWSTAT_OERRORS(ns->ns_stat);
	ifp->if_collisions = NWSTAT_CERRORS(ns->ns_stat);
	ifp->if_timer = NWWATCHINTERVAL;
}
#endif FALSE
/*********************************************************************
* 
* intr_nw - Interrupt card with proper interlock. 
*
*/

LOCAL VOID intr_nw (ns)
    FAST struct nw_softc *ns;

    {
    FAST struct nwdevice *nwp = ns->ns_nwp;

    if (nwp->nw_ipend_tonw == 0) 
	{
	nwp->nw_ipend_tonw = (u_char) 0xff;
	INTR_NW(nwp);
	}
    }
/*********************************************************************
*
* nwioctl - ioctl for nw driver
*
*/

LOCAL int nwioctl(ifp, cmd, data)
    register struct ifnet *ifp;
    int cmd;
    caddr_t data;

    {
    register struct ifaddr *ifa = (struct ifaddr *)data;
    struct nw_softc *ns = &nw_softc[ifp->if_unit];
    int s = splimp(), error = 0;

    switch (cmd) 
	{
	case SIOCSIFADDR:
	    ifp->if_flags |= IFF_UP;
	    nwinit(ifp->if_unit);

	    switch (ifa->ifa_addr.sa_family) 
		{
#ifdef INET
		case AF_INET:
		    ((struct arpcom *)ifp)->ac_ipaddr =
			    IA_SIN(ifa)->sin_addr;
		    arpwhohas((struct arpcom *)ifp, &IA_SIN(ifa)->sin_addr);
#ifdef	APPLETALK
		    if (ns->ns_atnode)
			    ddp_deleteifp(ns->ns_atnode);
		    ns->ns_atnode = getatnode(&ns->ns_ac);
#endif	APPLETALK
		    break;
#endif
#ifdef NS
		case AF_NS:
		    {
		    register struct ns_addr *ina = &(IA_SNS(ifa)->sns_addr);
		    
		    if (ns_nullhost(*ina))
			    ina->x_host = *(union ns_host *)(ns->ns_addr);
/*			else
			    nwsetaddr(ina->x_host.c_host,ifp->if_unit); /**/
		    break;
		}
#endif
	    }
	    break;

	case SIOCSIFFLAGS:
	    nwinit(ifp->if_unit);
	    break;

	default:
	    error = EINVAL;
	}
    splx(s);
    return error;
    }

#if FALSE
/* some day, this code may be useful */
nwr_ioctl( dev, cmd, arg, fflag )
	dev_t dev;
	caddr_t *arg;
{
	register struct nw_softc *ns = &nw_softc[minor(dev)];
	register struct nwdevice *nwp = ns->ns_nwp;
	register struct cpcb *cp = (struct cpcb *)arg;
	register struct bcb *bcbp;
	union command_packet *cpkt;
	register int error = 0, s;


	if (minor(dev) > NNW || nwp == 0)
		return ENODEV;
	if (!suser())
		return EPERM;
	switch (cmd) {
	    case NWIORESET:
		RESET_NW(nwp);
		bzero(ns->ns_stat, sizeof (ns->ns_stat));
		break;

	    case NWIOUNRESET:
		nwp->nw_ctl_stat = CTL_STAT_RESET;
		UNRESET_NW(nwp);
		break;

	    case NWIOGO:
		nwp->nw_ivector = ns->ns_vector; 
		GO_NW(nwp);
		nwinit(dev);
		nw_softc[dev].ns_if.if_flags &= ~IFF_UP;
		break;

	    case NWIOCMDPKT:
/* NOTE: TODO: no mechanism for only a single cmd packet pending! */
		/* get a free bcb chain and copy the packet into it */
		if ((bcbp = (struct bcb *)nwringget(ns->ns_hostfree)) == 0)
			return(EIO);
		bcbp->b_len = MIN(bcbp->b_len, cp->c_len);
		if (copyin(cp->c_addr, bcbp->b_addr, bcbp->b_len))
			return(EFAULT);
		cpkt = (union command_packet *)bcbp->b_addr;
#ifdef NETANAL
		/* 
		 * If packet sets a promiscuous mode, turn on address checking.
		 * If packet clears all promiscuous modes, turn off address 
		 * checking after ack packet received.
		 */
		if (cpkt->nw_commandp == NW_CMD_CONFIG_WRITE)
		    if (cpkt->nw_mode&(NW_MODE_PROMISCUOUS|NW_MODE_SELF_RCV_ALL))
			ns->ns_promiscuous = PROM_ON;
		    else
			ns->ns_promiscuous = PROM_OFF_PENDING;
#endif NETANAL
		/* transmit command packet and sleep on a response */
		bcbp->b_type = BCB_TYPE_COMMAND;
		s = splimp(s);
		if (nwringput(ns->ns_tonw, bcbp) == 1)
		    intr_nw(ns);
		sleep((caddr_t)&ns->ns_cmd_pkt, PWAIT);
		splx(s);

		/* 
		 * Copy any singlecast addresses written to the board over the 
		 * board's own default Ethernet address. This is a kludge 
		 * implemented simply to permit testing of the ability to set 
		 * the board's address.
		 */
		bcbp = ns->ns_cmd_pkt;
		cpkt = (union command_packet *) (bcbp->b_addr);
		if (cpkt->nw_commandp == NW_CMD_CONFIG_WRITE)
			bcopy(cpkt->nw_enet_addresses[NW_MY_ENET_ADDR], 
				ns->ns_addr, 6);
#ifdef NETANAL
		/* turn off promiscuous flag after ack received */
		if (ns->ns_promiscuous == PROM_OFF_PENDING)
		    ns->ns_promiscuous = PROM_OFF;
#endif NETANAL

		/* pass the response back to the user */
		bcbp->b_len = MIN(bcbp->b_msglen, cp->c_len);
		error = copyout(bcbp->b_addr, cp->c_addr, bcbp->b_len);
		nwringput(ns->ns_nwfree, ns->ns_cmd_pkt);
		return error;
	}
	return (0);
}
#endif FALSE

#ifdef	TRFS
nw_xmit(unit, naddr, p, len, fp0, fp1)
	int unit;
	struct ether_addr *naddr;
	struct packet *p;
	unsigned long len;
	struct fragment *fp0, *fp1;
{
	register struct bcb *bcbp;
	register struct ether_header *eh;
	register struct nw_softc *ns = &nw_softc[unit];
	register struct pkbuf *pkb;

	if ((bcbp = (struct bcb *)nwringget(ns->ns_hostfree)) == 0)
		return 1;
	eh = (struct ether_header *)bcbp->b_addr;
	bcopy(naddr, eh->ether_dhost, sizeof(eh->ether_dhost));
	bcopy(ns->ns_addr, eh->ether_shost, sizeof (eh->ether_shost));
	eh->ether_type = ETHERTYPE_WIPC;
	bcbp->b_len = (sizeof(struct pklink) - sizeof(struct packet)) +
		pkbuild(&((struct pklink *)eh)->packet, p, len, fp0, fp1);
	if (bcbp->b_len - sizeof(struct ether_header) < ETHERMIN)
		bcbp->b_len = ETHERMIN + sizeof(struct ether_header);
	if (nwringput(ns->ns_tonw, bcbp) == 1)
		intr_nw(ns);
	ns->ns_if.if_opackets++;
	return 0;
}

nw_recv(unit, bcbp)
	int unit;
	register struct bcb *bcbp;
{
	register struct pklink *p = (struct pklink *)bcbp->b_addr;

	ovbcopy(((struct ether_header *)p)->ether_shost, p->netaddr, 6);
	p->buflen = nwmtu;
	p->prelen = 0;
	p->ix = nw_softc[unit].ns_ix;
	p->handle = (int)bcbp;
	return ReceivePacket(p);
}

nw_relse(unit, p)
	int unit;
	struct pklink *p;
{
	register struct nw_softc *ns = &nw_softc[unit];

	nwringput(ns->ns_nwfree, (struct bcb *)p->handle);
}
#endif	TRFS
